#!/bin/sh
# the next line restarts using tclsh -*- tcl -*- \
exec tclsh "$0" "$@"

package require Tnm 3.0
package require Rrd 0.1

set rrdfile "[lindex $argv 0]-[lindex $argv 1].rrd"

# create rrdfile if not yet existent
if {[file exists $rrdfile] == 0} {
    Rrd::create $rrdfile --step 300 DS:inOctets:COUNTER:600:U:U RRA:TOTAL:0.5:1:288 RRA:TOTAL:0.5:7:5 RRA:TOTAL:0.5:5:12 RRA:TOTAL:0.5:12:10
}

# get an snmp session context
set session [Tnm::snmp generator -address [lindex $argv 0]]

# walk through ifTable rows (ifDescr column) to find the right interface
$session walk descr IF-MIB!ifDescr {

    # is this the right interface?
    if {"[Tnm::snmp value $descr 0]" == "[lindex $argv 1]"} {

	# get the instance part of this table row
	set inst [lindex [Tnm::mib split [Tnm::snmp oid $descr 0]] 1]

	# get the two interface's octet counter values
	set in [lindex [lindex [$session get IF-MIB!ifInOctets.$inst] 0] 2]
	set out [lindex [lindex [$session get IF-MIB!ifOutOctets.$inst] 0] 2]

	# write the value to the rrd
	Rrd::update $rrdfile --template inOctets:outOctets N:$in:$out

	#puts [Rrd::fetch $rrdfile]
    }
}

