#include <applet-widget.h>

#ifndef PROPERTIES_H__
#define PROPERTIES_H__

typedef struct 
{
    gchar	*color1;		/* traffic data 1 */
    gchar	*color2;		/* traffic data 2 */
    gchar	*colorb;		/* background (offline) */
    gchar	*colora;		/* background (active) */
    gchar	*colorl;		/* lines */
    guint	speed;			/* update freq in milli seconds */
    guint	height;
    guint	width;
    gboolean    look;
    gchar	*commandup;		/* command to activate */
    gchar	*commanddown;		/* command to deactivate */
    gchar	*agent;			/* SNMP agent host */
    guint	port;			/* SNMP agent port */
    gchar	*community;		/* SNMP community string */
    guint	retries;
    guint	timeout;
    gchar	*oidstatus;		/* OID of line status object */
    guint	up;			/* status value that denotes `up' */
    gchar	*oidv1;			/* OID of first value */
    gchar	*oidv2;			/* OID of second value */
    guint	line;			/* stripchart line spacing */
} snmpload_properties;

void properties(AppletWidget *applet, gpointer data);
void load_properties(char *path, snmpload_properties *prop);
void save_properties(char *path, snmpload_properties *prop);

#endif
