/* GNOME snmpload panel applet - properties dialog
 * (C) 2000 Frank Strauss
 *
 * Author: Frank Strauss
 *
 */

#include <stdio.h>
#include <string.h>
#include <config.h>
#include <gnome.h>
#include <applet-widget.h>

#include "properties.h"



void color1_changed_cb( GnomeColorPicker *widget );
void color2_changed_cb( GnomeColorPicker *widget );
void colorb_changed_cb( GnomeColorPicker *widget );
void colora_changed_cb( GnomeColorPicker *widget );
void colorl_changed_cb( GnomeColorPicker *widget );
void height_cb( GtkWidget *widget, GtkWidget *spin );
void width_cb( GtkWidget *widget, GtkWidget *spin );
void freq_cb( GtkWidget *widget, GtkWidget *spin );
GtkWidget *create_general_frame(void);
void oids_cb( GtkWidget *widget, GtkWidget *value );
void line_cb( GtkWidget *widget, GtkWidget *spin );
GtkWidget *create_oids_frame(void);
void apply_cb( GtkWidget *widget, void *data );
void close_cb( GtkWidget *widget, void *data );

GtkWidget *propbox;
extern snmpload_properties props;
static snmpload_properties new_props;

void setup_colors(void);
void setup_size(void);
void setup_snmp(void);
void start_timer(void);



void load_properties(char *path, snmpload_properties *prop)
{
    gnome_config_push_prefix(path);
    prop->color1    = gnome_config_get_string ("snmpload/gcolor1=#00ff00");
    prop->color2    = gnome_config_get_string ("snmpload/gcolor2=#0000ff");
    prop->colorb    = gnome_config_get_string ("snmpload/colorb=#000000");
    prop->colora    = gnome_config_get_string ("snmpload/colora=#ff0000");
    prop->colorl    = gnome_config_get_string ("snmpload/colorl=#e88a40");
    prop->speed     = gnome_config_get_int    ("snmpload/speed=1000");
    prop->height    = gnome_config_get_int    ("snmpload/height=40");
    prop->width     = gnome_config_get_int    ("snmpload/width=40");
    prop->look      = gnome_config_get_bool   ("snmpload/look=1");
    prop->commandup = gnome_config_get_string ("snmpload/commandup=ifup ppp0");
    prop->commanddown = gnome_config_get_string ("snmpload/commanddown=ifdown ppp0");
    prop->agent     = gnome_config_get_string ("snmpload/agent=localhost");
    prop->port      = gnome_config_get_int    ("snmpload/port=161");
    prop->community = gnome_config_get_string ("snmpload/community=public");
    prop->retries   = gnome_config_get_int    ("snmpload/retries=3");
    prop->timeout   = gnome_config_get_int    ("snmpload/timeout=100");
    prop->oidstatus = gnome_config_get_string ("snmpload/oidstatus=ifOperStatus.3");
    prop->up	    = gnome_config_get_int    ("snmpload/up=1");
    prop->oidv1     = gnome_config_get_string ("snmpload/oidv1=ifInOctets.3");
    prop->oidv2     = gnome_config_get_string ("snmpload/oidv2=ifOutOctets.3");
    prop->line      = gnome_config_get_int    ("snmpload/line=2000");
    gnome_config_pop_prefix();
}



void save_properties(char *path, snmpload_properties *prop )
{
    gnome_config_push_prefix(path);
    gnome_config_set_string( "snmpload/color1", prop->color1);
    gnome_config_set_string( "snmpload/color2", prop->color2);
    gnome_config_set_string( "snmpload/colorb", prop->colorb);
    gnome_config_set_string( "snmpload/colora", prop->colora);
    gnome_config_set_string( "snmpload/colorl", prop->colorl);
    gnome_config_set_int   ( "snmpload/speed", prop->speed);
    gnome_config_set_int   ( "snmpload/height", prop->height);
    gnome_config_set_int   ( "snmpload/width", prop->width);
    gnome_config_set_bool  ( "snmpload/look", prop->look);
    gnome_config_set_string( "snmpload/commandup", prop->commandup);
    gnome_config_set_string( "snmpload/commanddown", prop->commanddown);
    gnome_config_set_string( "snmpload/agent", prop->agent);
    gnome_config_set_int   ( "snmpload/port", prop->port);
    gnome_config_set_int   ( "snmpload/retries", prop->retries);
    gnome_config_set_int   ( "snmpload/timeout", prop->timeout);
    gnome_config_set_string( "snmpload/community", prop->community);
    gnome_config_set_string( "snmpload/oidstatus", prop->oidstatus);
    gnome_config_set_int   ( "snmpload/up", prop->up);
    gnome_config_set_string( "snmpload/oidv1", prop->oidv1);
    gnome_config_set_string( "snmpload/oidv2", prop->oidv2);
    gnome_config_set_int   ( "snmpload/line", prop->line);
    gnome_config_sync();
    gnome_config_pop_prefix();
    gnome_config_drop_all();
}



void color1_changed_cb(GnomeColorPicker *widget)
{
    gchar tmp[24];
    guint8 r, g, b;

    gnome_color_picker_get_i8(widget, &r, &g, &b, NULL);

    sprintf(tmp, "#%02x%02x%02x", r, g, b);
    strcpy(new_props.color1, tmp);
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}          



void color2_changed_cb(GnomeColorPicker *widget)
{
    gchar tmp[24];
    guint8 r, g, b;

    gnome_color_picker_get_i8(widget, &r, &g, &b, NULL);

    sprintf(tmp, "#%02x%02x%02x", r, g, b);
    strcpy(new_props.color2, tmp);
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}          



void colorb_changed_cb(GnomeColorPicker *widget)
{
    gchar tmp[24];
    guint8 r, g, b;

    gnome_color_picker_get_i8(widget, &r, &g, &b, NULL);

    sprintf(tmp, "#%02x%02x%02x", r, g, b);
    strcpy(new_props.colorb, tmp);
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}          



void colora_changed_cb(GnomeColorPicker *widget)
{
    gchar tmp[24];
    guint8 r, g, b;

    gnome_color_picker_get_i8(widget, &r, &g, &b, NULL);

    sprintf(tmp, "#%02x%02x%02x", r, g, b);
    strcpy(new_props.colora, tmp);
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}          



void colorl_changed_cb(GnomeColorPicker *widget)
{
    gchar tmp[24];
    guint8 r, g, b;

    gnome_color_picker_get_i8(widget, &r, &g, &b, NULL);

    sprintf(tmp, "#%02x%02x%02x", r, g, b);
    strcpy(new_props.colorl, tmp);
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}          



void height_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.height = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



void width_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



void freq_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.speed = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void line_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.line = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



GtkWidget *create_general_frame(void)
{
    GtkWidget *label;
    GtkWidget *box, *labels1, *labels2, *values1, *values2;
    GtkWidget *height, *width, *freq, *line;
    GtkObject *height_a, *width_a, *freq_a, *line_a;
    GtkWidget *color1_gcs, *color2_gcs;
    GtkWidget *colorb_gcs, *colora_gcs, *colorl_gcs;
    int col1r, col1g, col1b;
    int col2r, col2g, col2b;
    int colbr, colbg, colbb;
    int colar, colag, colab;
    int collr, collg, collb;
    
    sscanf(props.color1, "#%02x%02x%02x", &col1r, &col1g, &col1b);
    sscanf(props.color2, "#%02x%02x%02x", &col2r, &col2g, &col2b);
    sscanf(props.colorb, "#%02x%02x%02x", &colbr, &colbg, &colbb);
    sscanf(props.colora, "#%02x%02x%02x", &colar, &colag, &colab);
    sscanf(props.colorl, "#%02x%02x%02x", &collr, &collg, &collb);
        
    box = gtk_hbox_new(5, TRUE);
    labels1 = gtk_vbox_new(5, TRUE);
    values1 = gtk_vbox_new(5, TRUE);
    labels2 = gtk_vbox_new(5, TRUE);
    values2 = gtk_vbox_new(5, TRUE);

    gtk_container_set_border_width(GTK_CONTAINER(box), 5);

    color1_gcs = gnome_color_picker_new();
    color2_gcs = gnome_color_picker_new();
    colorb_gcs = gnome_color_picker_new();
    colora_gcs = gnome_color_picker_new();
    colorl_gcs = gnome_color_picker_new();
    
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER (color1_gcs),
			      col1r, col1g, col1b, 255);
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER (color2_gcs),
			      col2r, col2g, col2b, 255);
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER (colorb_gcs),
			      colbr, colbg, colbb, 255);
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER (colora_gcs),
			      colar, colag, colab, 255);
    gnome_color_picker_set_i8(GNOME_COLOR_PICKER (colorl_gcs),
			      collr, collg, collb, 255);
    
    label = gtk_label_new(_("Traffic 1"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    gtk_box_pack_start_defaults(GTK_BOX(values1), color1_gcs);
    
    label = gtk_label_new(_("Traffic 2"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    gtk_box_pack_start_defaults(GTK_BOX(values1), color2_gcs);

    label = gtk_label_new(_("Offline"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    gtk_box_pack_start_defaults(GTK_BOX(values1), colorb_gcs);

    label = gtk_label_new(_("Online"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    gtk_box_pack_start_defaults(GTK_BOX(values1), colora_gcs);

    label = gtk_label_new(_("Lines"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    gtk_box_pack_start_defaults(GTK_BOX(values1), colorl_gcs);

    label = gtk_label_new(_("Height"));
    gtk_box_pack_start_defaults(GTK_BOX(labels2), label);
    height_a = gtk_adjustment_new(props.height, 20, 128, 1, 8, 8);
    height  = gtk_spin_button_new(GTK_ADJUSTMENT(height_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values2), height);
	
    label = gtk_label_new(_("Width"));
    gtk_box_pack_start_defaults(GTK_BOX(labels2), label);
    width_a = gtk_adjustment_new(props.width, 20, 200, 1, 8, 8);
    width  = gtk_spin_button_new(GTK_ADJUSTMENT(width_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values2), width);

    label = gtk_label_new(_("Speed (ms)"));
    gtk_box_pack_start_defaults(GTK_BOX(labels2), label);
    freq_a = gtk_adjustment_new(props.speed, 100, 60000, 100, 1000, 1000);
    freq  = gtk_spin_button_new(GTK_ADJUSTMENT(freq_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values2), freq);
	
    label = gtk_label_new(_("Line Spacing"));
    gtk_box_pack_start_defaults(GTK_BOX(labels2), label);
    line_a = gtk_adjustment_new(props.line, 0, 100000000, 1, 10, 10);
    line = gtk_spin_button_new(GTK_ADJUSTMENT(line_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values2), line);
	
    gtk_signal_connect(GTK_OBJECT(color1_gcs), "color_set",
		       GTK_SIGNAL_FUNC(color1_changed_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(color2_gcs), "color_set",
		       GTK_SIGNAL_FUNC(color2_changed_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(colorb_gcs), "color_set",
		       GTK_SIGNAL_FUNC(colorb_changed_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(colora_gcs), "color_set",
		       GTK_SIGNAL_FUNC(colora_changed_cb), NULL);
    gtk_signal_connect(GTK_OBJECT(colorl_gcs), "color_set",
		       GTK_SIGNAL_FUNC(colorl_changed_cb), NULL);
	
    gtk_signal_connect(GTK_OBJECT(height_a), "value_changed",
		       GTK_SIGNAL_FUNC(height_cb), height);
    gtk_signal_connect(GTK_OBJECT(height), "changed",
		       GTK_SIGNAL_FUNC(height_cb), height);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(height),
				      GTK_UPDATE_ALWAYS);

    gtk_signal_connect(GTK_OBJECT(width_a), "value_changed",
		       GTK_SIGNAL_FUNC(width_cb), width);
    gtk_signal_connect(GTK_OBJECT(width), "changed",
		       GTK_SIGNAL_FUNC(width_cb), width);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(width),
				      GTK_UPDATE_ALWAYS);

    gtk_signal_connect(GTK_OBJECT(freq_a),"value_changed",
		       GTK_SIGNAL_FUNC(freq_cb), freq);
    gtk_signal_connect(GTK_OBJECT(freq),"changed",
		       GTK_SIGNAL_FUNC(freq_cb), freq);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(freq),
				      GTK_UPDATE_ALWAYS);

    gtk_signal_connect(GTK_OBJECT(line_a),"value_changed",
		       GTK_SIGNAL_FUNC(line_cb), line);
    gtk_signal_connect(GTK_OBJECT(line),"changed",
		       GTK_SIGNAL_FUNC(line_cb), line);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(line),
				      GTK_UPDATE_ALWAYS);

    gtk_box_pack_start_defaults(GTK_BOX(box), labels1);
    gtk_box_pack_start_defaults(GTK_BOX(box), values1);
    gtk_box_pack_start_defaults(GTK_BOX(box), labels2);
    gtk_box_pack_start_defaults(GTK_BOX(box), values2);

    gtk_widget_show_all(box);

    return box;
}



void agent_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.agent = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void port_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.port = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



void community_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.community = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void retries_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.retries =
	gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



void timeout_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.timeout =
	gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



GtkWidget *create_snmp_frame(void)
{
    GtkWidget *label;
    GtkWidget *box, *labels1, *values1;
    GtkWidget *agent, *port, *community, *retries, *timeout;
    GtkObject *port_a, *retries_a, *timeout_a;
    
    box = gtk_hbox_new(5, TRUE);
    labels1 = gtk_vbox_new(5, TRUE);
    values1 = gtk_vbox_new(5, TRUE);

    gtk_container_set_border_width(GTK_CONTAINER(box), 5);

    label = gtk_label_new(_("SNMP Agent"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    agent = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(agent), props.agent);
    gtk_signal_connect(GTK_OBJECT(agent), "changed",
		       GTK_SIGNAL_FUNC(agent_cb), agent);
    gtk_box_pack_start_defaults(GTK_BOX(values1), agent);
    
    label = gtk_label_new(_("SNMP Port"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    port_a = gtk_adjustment_new(props.port, 1, 65535, 1, 8, 8);
    port = gtk_spin_button_new(GTK_ADJUSTMENT(port_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values1), port);
    gtk_signal_connect(GTK_OBJECT(port_a),"value_changed",
		       GTK_SIGNAL_FUNC(port_cb), port);
    gtk_signal_connect(GTK_OBJECT(port),"changed",
		       GTK_SIGNAL_FUNC(port_cb), port);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(port),
				      GTK_UPDATE_ALWAYS);

    label = gtk_label_new(_("SNMP Community"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    community = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(community), props.community);
    gtk_signal_connect(GTK_OBJECT(community), "changed",
		       GTK_SIGNAL_FUNC(community_cb), community);
    gtk_box_pack_start_defaults(GTK_BOX(values1), community);
    
    label = gtk_label_new(_("SNMP Retries"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    retries_a = gtk_adjustment_new(props.retries, 1, 5, 1, 8, 8);
    retries = gtk_spin_button_new(GTK_ADJUSTMENT(retries_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values1), retries);
    gtk_signal_connect(GTK_OBJECT(retries_a),"value_changed",
		       GTK_SIGNAL_FUNC(retries_cb), retries);
    gtk_signal_connect(GTK_OBJECT(retries),"changed",
		       GTK_SIGNAL_FUNC(retries_cb), retries);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(retries),
				      GTK_UPDATE_ALWAYS);

    label = gtk_label_new(_("SNMP Timeout (ms)"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    timeout_a = gtk_adjustment_new(props.timeout, 5, 3000, 1, 8, 8);
    timeout = gtk_spin_button_new(GTK_ADJUSTMENT(timeout_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values1), timeout);
    gtk_signal_connect(GTK_OBJECT(timeout_a),"value_changed",
		       GTK_SIGNAL_FUNC(timeout_cb), timeout);
    gtk_signal_connect(GTK_OBJECT(timeout),"changed",
		       GTK_SIGNAL_FUNC(timeout_cb), timeout);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(timeout),
				      GTK_UPDATE_ALWAYS);

    gtk_box_pack_start_defaults(GTK_BOX(box), labels1);
    gtk_box_pack_start_defaults(GTK_BOX(box), values1);

    gtk_widget_show_all(box);

    return box;
}



void oidstatus_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.oidstatus = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void up_cb(GtkWidget *widget, GtkWidget *spin)
{
    new_props.up = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}



void oidv1_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.oidv1 = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void oidv2_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.oidv2 = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



GtkWidget *create_source_frame(void)
{
    GtkWidget *label;
    GtkWidget *box, *labels1, *values1;
    GtkWidget *oidstatus, *oidv1, *oidv2, *up;
    GtkObject *up_a;
    
    box = gtk_hbox_new(5, TRUE);
    labels1 = gtk_vbox_new(5, TRUE);
    values1 = gtk_vbox_new(5, TRUE);

    gtk_container_set_border_width(GTK_CONTAINER(box), 5);

    label = gtk_label_new(_("Status OID"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    oidstatus = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(oidstatus), props.oidstatus);
    gtk_signal_connect(GTK_OBJECT(oidstatus), "changed",
		       GTK_SIGNAL_FUNC(oidstatus_cb), oidstatus);
    gtk_box_pack_start_defaults(GTK_BOX(values1), oidstatus);
    
    label = gtk_label_new(_("Status Up Value"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    up_a = gtk_adjustment_new(props.up, 0, 10, 1, 8, 8);
    up  = gtk_spin_button_new(GTK_ADJUSTMENT(up_a), 1, 0);
    gtk_box_pack_start_defaults(GTK_BOX(values1), up);

    label = gtk_label_new(_("Traffic 1 OID"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    oidv1 = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(oidv1), props.oidv1);
    gtk_signal_connect(GTK_OBJECT(oidv1), "changed",
		       GTK_SIGNAL_FUNC(oidv1_cb), oidv1);
    gtk_box_pack_start_defaults(GTK_BOX(values1), oidv1);
    
    label = gtk_label_new(_("Traffic 2 OID"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    oidv2 = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(oidv2), props.oidv2);
    gtk_signal_connect(GTK_OBJECT(oidv2), "changed",
		       GTK_SIGNAL_FUNC(oidv2_cb), oidv2);
    gtk_box_pack_start_defaults(GTK_BOX(values1), oidv2);
    
    gtk_signal_connect(GTK_OBJECT(up_a),"value_changed",
		       GTK_SIGNAL_FUNC(up_cb), up);
    gtk_signal_connect(GTK_OBJECT(up),"changed",
		       GTK_SIGNAL_FUNC(up_cb), up);
    gtk_spin_button_set_update_policy(GTK_SPIN_BUTTON(up),
				      GTK_UPDATE_ALWAYS);

    gtk_box_pack_start_defaults(GTK_BOX(box), labels1);
    gtk_box_pack_start_defaults(GTK_BOX(box), values1);

    gtk_widget_show_all(box);

    return box;
}



void commandup_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.commandup = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



void commanddown_cb(GtkWidget *widget, GtkWidget *value)
{
    new_props.commanddown = gtk_entry_get_text(GTK_ENTRY(value));
    gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
}	



GtkWidget *create_action_frame(void)
{
    GtkWidget *label;
    GtkWidget *box, *labels1, *values1;
    GtkWidget *commandup, *commanddown;
    
    box = gtk_hbox_new(5, TRUE);
    labels1 = gtk_vbox_new(5, TRUE);
    values1 = gtk_vbox_new(5, TRUE);

    gtk_container_set_border_width(GTK_CONTAINER(box), 5);

    label = gtk_label_new(_("Activation Command"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    commandup = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(commandup), props.commandup);
    gtk_signal_connect(GTK_OBJECT(commandup), "changed",
		       GTK_SIGNAL_FUNC(commandup_cb), commandup);
    gtk_box_pack_start_defaults(GTK_BOX(values1), commandup);
    
    label = gtk_label_new(_("Deactivation Command"));
    gtk_box_pack_start_defaults(GTK_BOX(labels1), label);
    commanddown = gtk_entry_new_with_max_length(80);
    gtk_entry_set_text(GTK_ENTRY(commanddown), props.commanddown);
    gtk_signal_connect(GTK_OBJECT(commanddown), "changed",
		       GTK_SIGNAL_FUNC(commanddown_cb), commanddown);
    gtk_box_pack_start_defaults(GTK_BOX(values1), commanddown);
    
    gtk_box_pack_start_defaults(GTK_BOX(box), labels1);
    gtk_box_pack_start_defaults(GTK_BOX(box), values1);

    gtk_widget_show_all(box);

    return box;
}



void apply_cb(GtkWidget *widget, void *data)
{
    memcpy(&props, &new_props, sizeof(snmpload_properties));
    props.oidstatus = strdup(new_props.oidstatus);
    props.oidv1 = strdup(new_props.oidv1);
    props.oidv2 = strdup(new_props.oidv2);
    props.agent = strdup(new_props.agent);
    props.community = strdup(new_props.community);
    props.commandup = strdup(new_props.commandup);
    props.commanddown = strdup(new_props.commanddown);
    setup_snmp();
    setup_colors();
    setup_size();
    start_timer();
    
    /* FIXME: Need to resize. */
}

void close_cb(GtkWidget *widget, void *data)
{
    propbox = NULL;
}

void properties(AppletWidget *applet, gpointer data)
{
    static GnomeHelpMenuEntry help_entry = { NULL, "properties" };
    GtkWidget *frame, *label;

    help_entry.name = gnome_app_id;

    if (propbox)
	return;

    memcpy(&new_props, &props, sizeof(snmpload_properties));
		
    if (!(propbox = gnome_property_box_new())) {
	fprintf(stderr,
		_("properties.c: gnome_property_box_new() failed.\n"));
	return;
    }

    gtk_window_set_title( 
	GTK_WINDOW(&GNOME_PROPERTY_BOX(propbox)->dialog.window), 
	_("SNMP Load Settings"));
    
    frame = create_general_frame();
    label = gtk_label_new(_("General"));
    gtk_widget_show(frame);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(propbox),
				   frame, label);

    frame = create_snmp_frame();
    label = gtk_label_new(_("SNMP"));
    gtk_widget_show(frame);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(propbox),
				   frame, label);
    
    frame = create_source_frame();
    label = gtk_label_new(_("Sources"));
    gtk_widget_show(frame);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(propbox),
				   frame, label);
    
    frame = create_action_frame();
    label = gtk_label_new(_("Actions"));
    gtk_widget_show(frame);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(propbox),
				   frame, label);
    
    gtk_signal_connect(GTK_OBJECT(propbox),
		       "apply", GTK_SIGNAL_FUNC(apply_cb), NULL);
    
    gtk_signal_connect(GTK_OBJECT(propbox),
		       "destroy", GTK_SIGNAL_FUNC(close_cb), NULL);
    
    gtk_signal_connect(GTK_OBJECT(propbox),
		       "help", GTK_SIGNAL_FUNC(gnome_help_pbox_display),
		       &help_entry);
    
    gtk_widget_show_all(propbox);
}
