#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <netinet/in.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include "ethernet_handler.h"

int ethernet_socket;
int ethernet_device_index;
int ethernet_state = 0;
int ethernet_type = 0;

int ethernet_init(char * device, int type) {
	struct ifreq ifr;

  if( ethernet_state != 0 ) { 
    return -1;
  }

  // Open the raw socket
	ethernet_socket = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
	if (ethernet_socket == -1) {
    perror("socket() failed: ");
    return -1;
	}

	strncpy(ifr.ifr_name, device, IFNAMSIZ);
	if (ioctl(ethernet_socket, SIOCGIFINDEX, &ifr) == -1) {
    perror("ioctl(SIOCGIFINDEX) failed: ");
    return -1;
	}
	ethernet_device_index = ifr.ifr_ifindex;

  ethernet_type = type;
  ethernet_state = 1;

  return 1;
}

int ethernet_send(char * packet, int length) {
  char buffer[1024];
	struct sockaddr_ll socket_address;
  int ret, h;

  if( ethernet_state != 1 ) {
    return -1;
  }  

  if( length > (1024 - 14) ) {
    return -1;
  }

  // Prepare the socket options
  socket_address.sll_family   = PF_PACKET;
  socket_address.sll_protocol = htons(ETH_P_IP);
  socket_address.sll_ifindex  = ethernet_device_index;
  socket_address.sll_hatype   = ARPHRD_ETHER;
  socket_address.sll_pkttype  = PACKET_OTHERHOST;
  socket_address.sll_halen    = ETH_ALEN;

  // And set the address to all zeros
  for(h=0; h<8; h++) {
    socket_address.sll_addr[h] = 0x00;
  } 

  // The same for the packet headers
  memset(buffer, 0, 12);

  // Set the packet type
  buffer[12] = (ethernet_type & 0xFF00) >> 8;
  buffer[13] = (ethernet_type & 0x00FF) >> 0;
  
  memcpy(&buffer[14], packet, length);

  // And finally send it
  ret = sendto(ethernet_socket, buffer, 14 + length, 0, (struct sockaddr*)&socket_address, sizeof(socket_address));
  if (ret == -1) {
    perror("sendto() failed: ");
    return -1;
  }

  return 1;
}

int ethernet_deinit() {
  if( ethernet_state != 1 ) {
    return -1;
  }

  close(ethernet_socket);

  ethernet_state = 0;

  return 1;
}
