#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include "udp_server.h"

// UDP Server Socket
int udp_socket_fd;

// Socket config
struct sockaddr_in udp_addr;

int udp_status;

int udp_init(char * host, int port) {
  udp_status = 0;
 
  udp_socket_fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if( udp_socket_fd < 0 ) {
    perror("UDP: ERROR socket");
    return -1;
  }

  // Listen on any address in port
  memset(&udp_addr, 0, sizeof(udp_addr));
  udp_addr.sin_family = AF_INET;
  udp_addr.sin_port = htons(port);
  if( inet_aton(host, &udp_addr.sin_addr) == 0 ) {
    printf("Error inet_aton \n");
    return -1;
  }

  udp_status = 1;

  return 1;
}

int udp_send(char * buffer, int buffer_length) {
  // Generic return value
  int ret;
    
  if( udp_status != 1 ) {
    return -1;
  }

  if( buffer_length < 1 ) {
    return 0;
  }

  ret = sendto(udp_socket_fd, buffer, buffer_length, 0,(struct sockaddr *) &udp_addr, sizeof(udp_addr));

  if (ret <= 0) {
    perror("UDP: ERROR sendto");
  } else if( ret != buffer_length ) {
    printf("UDP: Send incomplete data \n");
  } 

  return ret;
}

int udp_deinit() {
  close(udp_socket_fd);
  
  return 1;
}
