#include <termios.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>

#include "ginseng-slip.h"
#include "serial_handler.h"

#define MESSAGE_BUFFER_SIZE 512

#define SLIP_END      192
#define SLIP_ESC      219
#define SLIP_ESC_END  220
#define SLIP_ESC_ESC  221  

#define SLIP_TYPE_ACK   0
#define SLIP_TYPE_PRINT 1


int   serial_status;
int   serial_fd;
unsigned char    
      serial_buffer[512];
unsigned char    
      message_buffer[MESSAGE_BUFFER_SIZE];
unsigned char    
      ack_buffer[MESSAGE_BUFFER_SIZE];
int   message_buffer_pos;
int   slip_state;


enum {
  STATE_OK = 0,
  STATE_ESC = 1,
  STATE_NOK = 2,
};


void serial_sendChar(unsigned char c) {
  int             res;
  int h;

  if( serial_status != 1 ) {
    return;
  }

  for(h=0; h<10; h++) {
    res = write(serial_fd, &c, 1);
  }
  usleep(100000);

  if( res < 1 ) {
    printf("could not send\n");
  }
}

int serial_init(char * Device) {
  struct termios IOSettings;
  
  if( serial_status > 0 ) {
    return -1;
  }

  printf("[SER] initialising...\n");

  serial_fd = open(Device, O_RDWR | O_NOCTTY );
  if( serial_fd < 0 ) {
    printf("unable to open device %s\n", Device);
    return -1;
  } 
  
  // Reset serial port settings 
  bzero(&IOSettings, sizeof(IOSettings));
    
  // Set new serial parameters
  IOSettings.c_cflag = B921600 | CS8 | CLOCAL | CREAD;
  IOSettings.c_iflag = IGNPAR;
  IOSettings.c_lflag = ~(ICANON | ECHO | ECHOE | ISIG);
  IOSettings.c_oflag = ~OPOST;
 
  // Set speed and apply settings 
  tcflush(serial_fd, TCIFLUSH);
  tcsetattr(serial_fd, TCSANOW, &IOSettings);

  serial_status = 1;
  slip_state = STATE_NOK;

  memset(message_buffer, 0, MESSAGE_BUFFER_SIZE);
  message_buffer_pos = 0;

  slipInit();

  printf("[SER] Init ok\n");

  return 1;
}

int serial_service() {
  struct timeval  tv;
  fd_set          serial_fds;
  int             res;
  int             i;

  if( serial_status != 1 ) {
    return -1;
  }
  
  tv.tv_sec = 0;
  tv.tv_usec = 0;
 
  do {
    FD_ZERO(&serial_fds);
    FD_SET(serial_fd, &serial_fds);
    
    res = select(serial_fd + 1, &serial_fds, NULL, NULL, &tv);

    if( res > 0 ) {
      memset(serial_buffer, 0, 512);
      res = read(serial_fd, serial_buffer, 512);
  
      for(i=0; i<res; i++) {
        slipInputCharacter(serial_buffer[i]);
      }
    }
  } while( res > 0 );

  return 1;
}

int serial_deinit() {
  if( serial_status != 1 ) {
    return -1;
  }

  if( serial_fd >= 0 ) {
    close(serial_fd);
  }

  serial_status = 0;
 
  return 1;
}
