#ifndef __GINSENG_SLIP_H__
#define __GINSENG_SLIP_H__

// And now the SLIP characters
#define SLIP_END              192
#define SLIP_ESC              219
#define SLIP_ESC_END          220
#define SLIP_ESC_ESC          221  

// Define the packet buffer length
#define GINSENG_SLIP_BUFFER   140

// Messages from node to PC
#define SLIP_TYPE_SNIFFED 0x01
#define SLIP_TYPE_PRINTF  0x02
#define SLIP_TYPE_RSSI    0x03

// Messages in both directions
#define SLIP_TYPE_CHANNEL 0xF1
#define SLIP_TYPE_CHANNEL_SCAN_START 0xF2
#define SLIP_TYPE_CHANNEL_SCAN_STOP 0xF3

#define SLIP_TYPE_STOP    0xF5
#define SLIP_TYPE_START   0xF6

#define SLIP_TYPE_RSSI_START  0xF7
#define SLIP_TYPE_RSSI_STOP   0xF8

// PrintFs over slip
#define SLIP_PRINTF(...) ({ slipSendChar(SLIP_TYPE_PRINTF); printf(__VA_ARGS__); slipSendEnd(); })

// Public functions
void slip_hexdump(char * buffer, u8_t length);

void slipSendChar(unsigned char c);
void slipSendEnd();
void slipSendBuffer(unsigned char * buffer, u8_t length);
void slipSendShortMessage(u8_t type, u8_t payload);

int slipUartInterrupt(unsigned char c);
int slipWorkIrqBuffer();
int slipInputCharacter(unsigned char c);
int slipIncomingMessage(unsigned char * buffer, u8_t length);
void slipInit();

#endif /* __GINSENG_SLIP_H__ */
