/*
  PlayField.h

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/
#ifndef PLAYFIELD_H
#define PLAYFIELD_H

#include <qlist.h>

#include "NineSequence.h"

class PlayField
{
public:
  static const int	nField;
  static const int	nSquare;

  PlayField ();
  ~PlayField();

  bool  numberOk ( int p, int nr ) { return ( !getRow(p)->isset(nr) && !getColumn(p)->isset(nr) && !getSquare(p)->isset(nr) ); }

  int	getX ( int p ) { return p%nField; }
  int	getY ( int p ) { return p/nField; }
  int	getPos ( int x, int y ) { return y*nField+x; }

  void	setNum ( int p, int num ) { setNum ( getX(p), getY(p), num ); }
  void	setNum ( int x, int y, int num );
  int	getNum ( int p ) { return getNum ( getX(p), getY(p) ); }
  int	getNum ( int x, int y );

  void clear ();

  NineSequence *getRow ( int pos ) { return rows.at ( getX(pos) ); }
  NineSequence *getColumn ( int pos ) { return columns.at ( getY(pos) ); }
  NineSequence *getSquare ( int pos ) { return squares.at ( getX(pos)/nSquare + nSquare*(getY(pos)/nSquare) ); }
  NineSequence *getNthRow ( int n ) { return rows.at ( n ); }
  NineSequence *getNthColumn ( int n ) { return columns.at ( n ); }
  NineSequence *getNthSquare ( int n ) { return squares.at ( n ); }

private:
  QList<NineSequence>	rows;
  QList<NineSequence>	columns;
  QList<NineSequence>	squares;
  int			**field;
};

#endif
