/*
  PlayField.cpp

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/

#include "PlayField.h"

#include <stdlib.h>
//#include <qobject.h>


const int PlayField::nField = 9;
const int PlayField::nSquare = nField/3;


PlayField::PlayField ()
{
  field = new int* [nField];
  for ( int i = 0; i < nField; i++ )
  {
    field[i] = new int[nField];
    for ( int j = 0; j < nField; j++ )
      field[i][j] = 0;
  }

  rows.setAutoDelete ( TRUE );
  columns.setAutoDelete ( TRUE );
  squares.setAutoDelete ( TRUE );
  for ( int i = 0; i < nField; i++ )
  {
    rows.append ( new NineSequence );
    columns.append ( new NineSequence );
    squares.append ( new NineSequence );
  }

  clear ();
}

PlayField::~PlayField ()
{
  for ( int i = 0; i < nField; i++ )
    delete[] field[i];
  delete[] field;
}

void PlayField::clear ()
{
  // initialize field
  for ( int i = 0; i < nField; i++ )
    for ( int j = 0; j < nField; j++ )
      setNum ( i, j, 0 );
}


void PlayField::setNum ( int x, int y, int num )
{
  NineSequence	*ns_row, *ns_column, *ns_square;
  int		num_old, i;

  num_old = field[x][y];
  if ( num != num_old )
  {
    field[x][y] = num;

    ns_row = getNthRow ( x );
    ns_column = getNthColumn ( y );
    ns_square = getNthSquare ( x/3 + 3*(y/3) );

    ns_row->unset ( num_old );
    for ( i = 0; i < nField; i++ )
      if ( getNum(x, i) == num_old )
	ns_row->set ( num_old );

    ns_column->unset ( num_old );
    for ( i = 0; i < nField; i++ )
      if ( getNum(i, y) == num_old )
	ns_column->set ( num_old );

    ns_square->unset ( num_old );
    for ( i = 0; i < nField; i++ )
    {
      if ( getNum((x/3)*3 + i%3, (y/3)*3 + i/3) == num_old )
    	ns_square->set ( num_old );
    }

    if ( num > 0 )
    {
      ns_row->set ( num );
      ns_column->set ( num );
      ns_square->set ( num );
    }
  }
}

int PlayField::getNum ( int x, int y )
{
  return field[x][y];
}
