/*
  NumberWidget.cpp

  Program: ten

  September 2001 Axel Bger
*/

#include "NumberWidget.h"
#include "NineWindow.h"
#include <qpushbutton.h>


NumberWidget::NumberWidget ( QWidget *parent=0, const char *name=0 )
  : QHButtonGroup ( parent, name )
{
  int		i;
  QPushButton	*pb;
  QFont f ( "Times", 24, QFont::Bold );

  setExclusive ( TRUE );

  for ( i = 0; i < 10; i++ )
  {
    pb = new QPushButton ( this, "number button" );
    pb->setToggleButton ( TRUE );
    pb->setFixedSize ( 28, 28 );
    QPalette pal = pb->palette ();
    pal.setColor ( QColorGroup::Button, Qt::white );
    pb->setPalette ( pal );
    pb->setFont ( f );
    if ( i > 0 )
      pb->setText ( QString::number(i) );

    if ( i == 0 )
      setButton ( id(pb) );
  }
}

NumberWidget::~NumberWidget ()
{
}

void NumberWidget::setNumberButton ( int id )
{
  setButton ( id );
  emit clicked ( id );
}
