/*
  NineWindow.cpp

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/

#include "NineWindow.h"
#include "Field.h"
#include "NumberWidget.h"

#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qapplication.h>
#include <qevent.h>

#include <ctype.h>



NineWindow::NineWindow ()
  : QMainWindow ( 0, "mainWindow" )
{
  QVBox		*central;
  QHBox		*playtable;
  QWidget	*buttons;

  central = new QVBox ( this, "vertical layout" );

  playtable = new QHBox ( central, "horizontal layout" );

  field = new Field ( playtable, "playarea" );

  buttons = new QWidget ( playtable, "button area" );
  QVBoxLayout *buttons_layout = new QVBoxLayout ( buttons );

  QPushButton *new_b = new QPushButton ( "New", buttons );
  buttons_layout->addWidget ( new_b );
  connect ( new_b, SIGNAL(clicked()), this, SLOT(newGame()) );

  QPushButton *quit_b = new QPushButton ( "Quit", buttons );
  buttons_layout->addWidget ( quit_b );
  connect ( quit_b, SIGNAL(clicked()), qApp, SLOT(quit()) );

  QLabel *level_label = new QLabel ( "Level:", buttons );
  buttons_layout->addWidget ( level_label );

  static const char *level_list[] = { "easy", "medium", "hard", "heavy" };
  QComboBox *level_b = new QComboBox ( buttons );
  level_b->insertStrList ( level_list, 4 );
  buttons_layout->addWidget ( level_b );
  connect ( level_b, SIGNAL(activated(int)), SLOT(level(int)) );

//    QSpacerItem *spacer = new QSpacerItem ( 10, 10, QSizePolicy::Expanding,
//  					  QSizePolicy::Expanding );
//    buttons_layout->addItem ( spacer );
  buttons_layout->addStretch ( 1 );

  QPushButton *undo_b = new QPushButton ( "Undo", buttons );
  buttons_layout->addWidget ( undo_b );
  connect ( undo_b, SIGNAL(clicked()), field, SLOT(undo()) );

  QPushButton *hint_b = new QPushButton ( "Hint", buttons );
  buttons_layout->addWidget ( hint_b );
  connect ( hint_b, SIGNAL(clicked()), field, SLOT(hint()) );

  QPushButton *solve_b = new QPushButton ( "Solve", buttons );
  buttons_layout->addWidget ( solve_b );
  connect ( solve_b, SIGNAL(clicked()), field, SLOT(solve()) );

  numbers = new NumberWidget ( central, "numbers" );
  connect ( numbers, SIGNAL(clicked(int)), field, SLOT(number(int)) );
  connect ( this, SIGNAL(NumberPressed(int)), numbers, SLOT(setNumberButton(int)) );

  setCentralWidget( central );

  level ( 0 );
}

NineWindow::~NineWindow ()
{
}

void NineWindow::keyPressEvent ( QKeyEvent *e )
{
  int	c = e->ascii();

  if ( isdigit(c) )
    emit NumberPressed ( c - '0' );
  else
    e->ignore ();
}



void NineWindow::newGame ()
{
  QApplication::setOverrideCursor ( Qt::waitCursor );
  field->newGame ( difficulty );
  QApplication::restoreOverrideCursor();
}

void NineWindow::level ( int level )
{
  switch ( level )
  {
    case 0:
    default:
      difficulty = 50;	break;
    case 1:
      difficulty = 60;	break;
    case 2:
      difficulty = 66;	break;
    case 3:
      difficulty = 71;	break;
  }
}
