/*
  NineSequence.h

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/
#ifndef NINESEQUENCE_H
#define NINESEQUENCE_H

#include <qarray.h>
#include <ostream.h>


class NineSequence
{
public:
  static const int	nNumbers;

  NineSequence ();

  void set ( int i ) { if ( i > 0 && i <= nNumbers ) numbers[i-1] = TRUE; }
  void unset ( int i ) { if ( i > 0 && i <= nNumbers ) numbers[i-1] = FALSE; }
  bool isset ( int i ) { return (i > 0 && i <= nNumbers) ? numbers[i-1] : FALSE; }
  bool allSet ();
  int  countFree ();

  void add ( NineSequence *ns );
  void clear ();
  int getFreeRand ();

  friend ostream& operator<< ( ostream& s, NineSequence& ns );

private: 
  int getRand ( int max );

  QArray<bool>		numbers;
};

#endif
