/*
  NineSequence.cpp

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/

#include <stdlib.h>

#include "NineSequence.h"


const int NineSequence::nNumbers = 9;


NineSequence::NineSequence ()
{
  numbers.resize ( nNumbers );

  clear ();
}


bool NineSequence::allSet ()
{
  bool	all = TRUE;

  for ( int i = 1; i <= nNumbers && all; i++ )
    all = isset ( i );

  return all;
}


int NineSequence::countFree ()
{
  int	free = 0;

  for ( int i = 1; i <= nNumbers; i++ )
    if ( !isset(i) )
      free++;

  return free;
}


void NineSequence::add ( NineSequence *ns )
{
  for ( int i = 1; i <= nNumbers; i++ )
    if ( ns->isset(i) )
      set ( i );
}


void NineSequence::clear ()
{
  for ( int i = 1; i <= nNumbers; i++ )
    unset ( i );
}


int NineSequence::getFreeRand ()
{
  int f, i;

  f = countFree();
  if ( f > 0 )
  {
    f = getRand ( f );
    for ( i = 1; i <= nNumbers; i++ )
      if ( !isset(i) )
      {
	if ( f == 0 )
	  break;
        else
	  f--;
      }
    f = i;
  }

  return f;
}


int NineSequence::getRand ( int max )
{
  return (int) ((double)max * rand()/(RAND_MAX+1.0));
}


ostream& operator<< ( ostream& s, NineSequence& ns )
{
  s << '[';
  for ( int i = 1; i <= NineSequence::nNumbers; i++ )
    if ( ns.isset(i) )
      s << i;
    else
      s << ' ';
  s << ']';

  return s;
}
