/*
  NineField.h

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/
#ifndef NINEFIELD_H
#define NINEFIELD_H

#include <qlist.h>
#include <qpoint.h>

#include "PlayField.h"


class PositionMemo
{
public:
  PositionMemo( int nr, int pos) { number = nr; position = pos; }
  int getNr() { return number; }
  int getPos() { return position; }
private:
  int	number;
  int	position;

};


class NineField : public PlayField
{
public:
  bool  solved ();

  void setup ( int d );

  int guess ( int &number );

  friend ostream& operator<< ( ostream& s, NineField& tf );

private: 
  int getRand ( int min, int max );
  bool search ( int pos );
  int simpleGuess ( int &number );
  int advancedGuess ( int &number );
  int advancedGuessRow ( int &number );
  int advancedGuessColumn ( int &number );
  int advancedGuessSquare ( int &number );
  int advancedGuessCommon ( int free, QPoint free_p[], int free_arr[], int &number );
  int getFreeSequencePos ( NineSequence *ts );
  bool numberRemoveable ( int pos );
};

#endif
