/*
  NineField.cpp

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/

#include "NineField.h"

#include <stdlib.h>
#include <stdio.h>
#include <ostream.h>
#include <qstack.h>


bool NineField::solved ()
{
  int	i;
  bool	ok = TRUE;

  // 1. all rows must be set
  for ( i = 0; i < nField && ok; i++ )
    ok = getNthRow(i)->allSet();

  // 2. all columns must be set
  for ( i = 0; i < nField && ok; i++ )
    ok = getNthColumn(i)->allSet();

  // 3. all squares must be set
  for ( i = 0; i < nField && ok; i++ )
    ok = getNthSquare(i)->allSet();

  return ok;
}

void NineField::setup ( int d )
{
  int		i, j, pos, cnt, round;
  QArray<bool>	old_positions ( nField*nField );

  do
  {
    round = 0;
    cnt = nField*nField*d/100;

    clear ();

    search ( 0 );

    for ( i = 0; i < nField*nField; i++ )
      old_positions[i] = FALSE;

    do
    {
      round++;

      pos = getRand ( 0, nField*nField );
      j = 0;
      for ( i = 0; i < nField*nField; i++ )
	if ( !old_positions[i] )
	{
	  if ( j == pos )
	  {
	    old_positions[i] = TRUE;
	    pos = i;
	    break;
	  }
	  j++;
	}

      if ( getNum(pos) > 0 )
      {
	bool found = numberRemoveable(pos);
	if ( found )
	{
	  cnt--;
	  round = 0;
	  setNum ( pos, 0 );
	}
      }
    }
    while ( cnt > 0 && round <= 100 );
  }
  while ( round > 100 );
}


int NineField::getRand ( int min, int max )
{
  return min + (int) ((double)(max-min)*(double)rand()/(RAND_MAX+1.0));
}


bool NineField::search ( int pos )
{
  bool		found;
  NineSequence	ns;

  ns.add ( getRow(pos) );
  ns.add ( getColumn(pos) );
  ns.add ( getSquare(pos) );

  do
  {
    int number = ns.getFreeRand ();
    found = ( number > 0 );
    if ( found )
    {
      ns.set ( number );
      setNum ( pos, number );

      if ( pos < nField*nField-1 )
      {
	if ( search(pos+1) )
	  break;
      }
      else
	break;
    }
  }
  while ( found );

  if ( !found )
    setNum ( pos, 0 );

  return found;
}



int NineField::guess ( int &number )
{
  int		pos;

  pos = simpleGuess ( number );
  if ( pos < 0 )
    pos = advancedGuess ( number );

  return pos;
}


ostream& operator<< ( ostream& s, NineField& tf )
{
  int	i;

  s << "  Field:         Rows:          Columns:         Squares:     \n";
  for ( i = 0; i < tf.nField; i++ )
  {
    s << i+1 << " [";
    for ( int j = 0; j < tf.nField; j++ )
    {
      int n = tf.getNum(i, j);
      if ( n > 0 )
	s << n;
      else
	s << ' ';
    }
    s << "]    ";
    if ( !tf.getNthRow(i)->allSet() )
      s << tf.getNthRow(i) << "    ";
    else
      s << "               ";

    if ( !tf.getNthColumn(i)->allSet() )
      s << " " << tf.getNthColumn(i) << "    ";
    else
      s << "                ";

    if ( !tf.getNthSquare(i)->allSet() )
      s << " " << tf.getNthSquare(i);

    s << '\n';
  }

  return s;
}


int NineField::simpleGuess ( int &number )
{
  int		pos = -1;
  int		i;

  for ( i = 0; i < nField*nField && pos < 0; i++ )
  {
    if ( getNum(i) < 1 )
    {
      pos = getFreeSequencePos ( getRow(i) );
      if ( pos >= 0 )
      {
	number = pos;
	pos = i;
      }

      if ( pos < 0 )
      {
	pos = getFreeSequencePos ( getColumn(i) );
	if ( pos >= 0 )
	{
	  number = pos;
	  pos = i;
	}
      }

      if ( pos < 0 )
      {
	pos = getFreeSequencePos ( getSquare(i) );
	if ( pos >= 0 )
	{
	  number = pos;
	  pos = i;
	}
      }
    }
  }

  return pos;
}


int NineField::advancedGuess ( int &number )
{
  int	pos;

  pos = advancedGuessRow ( number );
  if ( pos < 0 )
    pos = advancedGuessColumn ( number );
  if ( pos < 0 )
    pos = advancedGuessSquare ( number );

  return pos;
}


int NineField::advancedGuessRow ( int &number )
{
  int		pos = -1;
  int		j, free, s, n;
  NineSequence	*ts;

  for ( s = 0; s < nField && pos < 0; s++ )
  {
    ts = getNthRow ( s );
    free = ts->countFree();
    if ( free > 1 )
    {
      int	free_arr[free];
      QPoint	free_p[free];

      n = 0;
      for ( j = 1; j <= nField; j++ )
	if ( !ts->isset(j) )
	  free_arr[n++] = j;

      n = 0;
      for ( j = 0; j < nField; j++ )
	if ( getNum(s, j) < 1 )
	{
	  free_p[n].setX ( s );
	  free_p[n++].setY ( j );
	}

      pos = advancedGuessCommon ( free, free_p, free_arr, number );
    }
  }

  return pos;
}


int NineField::advancedGuessColumn ( int &number )
{
  int		pos = -1;
  int		j, free, s, n;
  NineSequence	*ts;

  for ( s = 0; s < nField && pos < 0; s++ )
  {
    ts = getNthColumn ( s );
    free = ts->countFree();
    if ( free > 1 )
    {
      int	free_arr[free];
      QPoint	free_p[free];

      n = 0;
      for ( j = 1; j <= nField; j++ )
	if ( !ts->isset(j) )
	  free_arr[n++] = j;

      n = 0;
      for ( j = 0; j < nField; j++ )
	if ( getNum(j, s) < 1 )
	{
	  free_p[n].setX ( j );
	  free_p[n++].setY ( s );
	}

      pos = advancedGuessCommon ( free, free_p, free_arr, number );
    }
  }

  return pos;
}


int NineField::advancedGuessSquare ( int &number )
{
  int		pos = -1;
  int		j, free, s, n;
  NineSequence	*ts;

  for ( s = 0; s < nField && pos < 0; s++ )
  {
    ts = getNthSquare ( s );
    free = ts->countFree();
    if ( free > 1 )
    {
      int	free_arr[free];
      QPoint	free_p[free];

      n = 0;
      for ( j = 1; j <= nField; j++ )
	if ( !ts->isset(j) )
	  free_arr[n++] = j;

      int xx = ( s % nSquare ) * nSquare;
      int yy = ( s / nSquare ) * nSquare;
      n = 0;
      for ( int x = xx; x < xx + nSquare; x++ )
	for ( int y = yy; y < yy + nSquare; y++ )
	  if ( getNum(x, y) < 1 )
	  {
	    free_p[n].setX ( x );
	    free_p[n++].setY ( y );
	  }

      pos = advancedGuessCommon ( free, free_p, free_arr, number );
    }
  }

  return pos;
}


int NineField::advancedGuessCommon ( int free, QPoint free_p[],
				    int free_arr[], int &number )
{
  int	k, n, avail;
  QPoint p;
  int	pos = -1;
  bool	free_matrix[free][free];

  for ( k = 0; k < free; k++ )
    for ( n = 0; n < free; n++ )
      free_matrix[n][k] = numberOk ( getPos(free_p[k].x(), free_p[k].y()), free_arr[n] );

  for ( k = 0; k < free && pos < 0; k++ )
  {
    avail = 0;
    for ( n = 0; n < free; n++ )
    {
      if ( free_matrix[k][n] )
      {
	p = free_p[n];
	avail++;
      }
    }
    if ( avail == 1 )
    {
      pos = getPos ( p.x(), p.y() );
      number = free_arr[k];
    }
    else
    {
      int tmp_number = 0;
      avail = 0;
      for ( n = 0; n < free; n++ )
      {
	if ( free_matrix[n][k] )
	{
	  p = free_p[k];
	  tmp_number = free_arr[n];
	  avail++;
	}
      }
      if ( avail == 1 )
      {
	pos = getPos ( p.x(), p.y() );
	number = tmp_number;
      }
    }
  }

  return pos;
}



int NineField::getFreeSequencePos ( NineSequence *ns )
{
  int	pos = -1;

  if ( ns->countFree() == 1 )
  {
    for ( int i = 1; i <= nField && pos < 0; i++ )
      if ( !ns->isset(i) )
      {
	pos = i;
      }
  }

  return pos;
}


bool NineField::numberRemoveable ( int pos )
{
  bool	removeable = FALSE;
  int	number;
  int	position, nr;

  number = getNum ( pos );
  if ( number > 0 )
  {
    setNum ( pos, 0 );

    QStack<PositionMemo> stack;

    do
    {
      position = guess ( nr );
      removeable = (pos == position);
      if ( !removeable && position >= 0 )
      {
	setNum ( position, nr );
	stack.push ( new PositionMemo(nr, position) );
      }
    }
    while ( position >= 0 && !removeable );

    while ( !stack.isEmpty() )
    {
      PositionMemo *pm = stack.pop();
      setNum ( pm->getPos(), 0 );
      delete pm;
    }

    setNum ( pos, number );
  }

  return removeable;
}
