/*
  Field.h

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/
#ifndef FIELD_H
#define FIELD_H

#include <qvector.h>
#include <qlist.h>
#include <qwidget.h>

#include "NineField.h"


class FieldButton;


class Field : public QWidget
{
  Q_OBJECT
public:
  Field ( QWidget *parent=0, const char *name=0 );
  ~Field();
  void newGame ( int difficulty );

signals:
  void        finished();                     // game finished

public slots:
  void        number(int);
  void	      undo (); 
  void	      solve ();
  void	      hint ();

private slots:
  void        buttonClicked();

private: 
  void	      updateButtons();
  void	      buttonSelected ( int pos, int number );

  int			actNumber;
  QVector<FieldButton>	*buttons;
  NineField		tf;
  QList<PositionMemo>	undo_list;
};

#endif
