/*
  Field.cpp

  Program: qnine

  September 2001 Axel Bger

  Changes:
  28. Nov.	program renamed to 'qnine'
*/

#include "Field.h"

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>

#include <qpushbutton.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qpen.h>
#include <qdatetime.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qgrid.h>
#include <qpalette.h>


class FieldButton : public QPushButton
{
public:
  FieldButton ( QWidget *parent );

  int value() const { return v; }
  void setValue ( int value );

  enum Type { Valid, Invalid, Win, Fixed, Hint };
  Type type() const { return t; }
  void setType ( Type t );

#if QT_VERSION < 300
protected:
  void drawButton( QPainter *paint );
#endif

private:
  int			v;
  Type			t;

#if QT_VERSION < 300
  static int		drawSelf;
#endif
};


#if QT_VERSION < 300
int FieldButton::drawSelf = -1;
#endif


FieldButton::FieldButton ( QWidget *parent )
  : QPushButton( parent )
{
  setType ( Valid );
  setValue ( -1 );

  QPalette pal = palette ();
  pal.setColor ( QColorGroup::Button, Qt::white );
  setPalette ( pal );
  setFlat ( TRUE );
  setFixedSize ( 28, 28 );

#if QT_VERSION < 300
  if ( drawSelf < 0 )
  {
    char  version_str[20];
    char  *c, *c2;
    int   v1, v2;

    strncpy ( version_str, qVersion(), 20 );
    version_str[19] = '\0';
    c = strchr ( version_str, '.' );
    *c = '\0';
    v1 = atoi ( version_str );
    c2 = c+1;
    c = strchr ( c2, '.' );
    if ( c != 0 )
      *c = '\0';
    v2 = atoi ( c2 );

    drawSelf = ( v1 < 2 || (v1 == 2 && v2 < 3) );
  }
#endif
}

void FieldButton::setType ( Type t )
{
  static QFont	validfont ( "Times", 24, QFont::Bold );
  static QFont	fixedfont ( "TypeWriter", 24, QFont::Normal );

  this->t = t;

  if ( t == Valid || t == Invalid || t == Win || t == Hint )
    setFont ( validfont );
  else
    setFont ( fixedfont );

  QPalette pal = palette ();
  if ( t == Valid )
    pal.setColor ( QColorGroup::ButtonText, Qt::black );
  else if ( t == Fixed )
    pal.setColor ( QColorGroup::ButtonText, Qt::darkBlue );
  else if ( t == Invalid )
    pal.setColor ( QColorGroup::ButtonText, Qt::red );
  else if ( t == Hint )
    pal.setColor ( QColorGroup::ButtonText, Qt::gray );
  else
    pal.setColor ( QColorGroup::ButtonText, Qt::green );
  setPalette ( pal );
}

void FieldButton::setValue ( int value )
{
  v = value;
  setType ( type() );
  if ( value > 0 )
    setText ( QString::number(v) );
  else
    setText ( " " );

}

#if QT_VERSION < 300
void FieldButton::drawButton( QPainter *paint )
{
  if ( !drawSelf )
    QPushButton::drawButton ( paint );
  else
  {
    int diw = 0;
    if ( isDefault() || autoDefault() )
    {
      diw = style().buttonDefaultIndicatorWidth();
      if ( diw > 0 )
      {
	if ( parentWidget() && parentWidget()->backgroundPixmap() )
	{
	  // pseudo tranparency
	  paint->drawTiledPixmap( 0, 0, width(), diw,
				  *parentWidget()->backgroundPixmap(),
				  x(), y() );
	  paint->drawTiledPixmap( 0, 0, diw, height(),
				  *parentWidget()->backgroundPixmap(),
				  x(), y() );
	  paint->drawTiledPixmap( 0, height()-diw, width(), diw,
				  *parentWidget()->backgroundPixmap(),
				  x(), y() );
	  paint->drawTiledPixmap( width()-diw, 0, diw, height(),
				  *parentWidget()->backgroundPixmap(),
				  x(), y() );
	}
	else
	{
	  paint->fillRect( 0, 0, width(), diw,
			   colorGroup().brush(QColorGroup::Background) );
	  paint->fillRect( 0, 0, diw, height(),
			   colorGroup().brush(QColorGroup::Background) );
	  paint->fillRect( 0, height()-diw, width(), diw,
			   colorGroup().brush(QColorGroup::Background) );
	  paint->fillRect( width()-diw, 0, diw, height(),
			   colorGroup().brush(QColorGroup::Background) );
	}
      }
    }
    drawButtonLabel( paint );
    int x1, y1, x2, y2;
    style().pushButtonContentsRect( this ).coords( &x1, &y1, &x2, &y2 );// get coordinates
    if ( hasFocus() )
    {
      QRect r(x1+2, y1+2, x2-x1-3, y2-y1-3);
      style().drawFocusRect( paint, r , colorGroup(), &colorGroup().button() );
    }
  }
}
#endif


Field::Field ( QWidget *parent=0, const char *name=0 )
  : QWidget ( parent, name )
{
  int	i;
  int	x, y, xs, ys;

  actNumber = 0;

  QTime t = QTime::currentTime();             // set random seed
  unsigned int seed = t.hour()*12+t.minute()*60+t.second()*60;
//    seed = 1920;
//    cout << "Seed= " << seed << '\n';
  srand( seed );
  //srand( 1 );

  tf.clear ();

  undo_list.setAutoDelete ( TRUE );

  buttons = new QVector<FieldButton> ( tf.nField * tf.nField );

  QGridLayout *grid = new QGridLayout ( this, tf.nSquare, tf.nSquare, 5 );

  i = 0;
  for ( xs = 0; xs < tf.nSquare; xs++ )
    for ( ys = 0; ys < tf.nSquare; ys++ )
    {
      QGrid *grid_square = new QGrid( tf.nSquare, this );
      grid_square->setSpacing ( 3 );

      grid->addWidget ( grid_square, xs, ys );

      for ( x = 0; x < tf.nSquare; x++ )
	for ( y = 0; y < tf.nSquare; y++ )
	{
	  FieldButton *fb = new FieldButton( grid_square );
	  connect( fb, SIGNAL(clicked()), SLOT(buttonClicked()) );
	  fb->setValue ( tf.getNum(xs*tf.nSquare+x, ys*tf.nSquare+y) );
	  buttons->insert( xs*tf.nSquare+x + (ys*tf.nSquare+y)*tf.nField, fb );
	}
    }
}


Field::~Field ()
{
  delete buttons;
}

void Field::newGame ( int difficulty )
{
  tf.setup ( difficulty );

  for ( int i = 0; i < tf.nField*tf.nField; i++ )
  {
    if ( tf.getNum(i) > 0 )
      buttons->at(i)->setType ( FieldButton::Fixed );
    else
      buttons->at(i)->setType ( FieldButton::Valid );
  }
  updateButtons();

  undo_list.clear ();
}

void Field::buttonClicked()
{
  int pos = buttons->findRef( (FieldButton*)sender() );

  if ( buttons->at(pos)->type() == FieldButton::Fixed )
    qApp->beep();
  else
    buttonSelected ( pos, actNumber );
}

void Field::buttonSelected ( int pos, int number )
{
  bool	isHint = (number < 0);

  if ( isHint )
    number += 10;

  if ( tf.getNum(pos) != number )
  {
    undo_list.append ( new PositionMemo(tf.getNum(pos), pos) );

    if ( tf.numberOk(pos, number) )
    {
      if ( isHint )
	buttons->at(pos)->setType ( FieldButton::Hint );
      else
	buttons->at(pos)->setType ( FieldButton::Valid );
    }
    else
      buttons->at(pos)->setType ( FieldButton::Invalid );

    tf.setNum ( pos, number );

    if ( tf.solved() )
    {
      undo_list.clear ();

      for ( int i = 0; i < tf.nField*tf.nField; i++ )
	buttons->at(i)->setType ( FieldButton::Win );
    }

    updateButtons();
  }
}


void Field::undo ()
{
  if ( undo_list.isEmpty() )
    qApp->beep();
  else
  {
    PositionMemo *pm;

    pm = undo_list.getLast();
    tf.setNum ( pm->getPos(), pm->getNr() );
    updateButtons ();

    undo_list.removeLast ();
  }
}


void Field::solve ()
{
  int	pos, number;

  pos = tf.guess ( number );
  while ( pos >= 0 )
  {
    undo_list.append ( new PositionMemo(tf.getNum(pos), pos) );

    buttons->at(pos)->setType ( FieldButton::Valid );

    tf.setNum ( pos, number );

    pos = tf.guess ( number );
  }

  if ( tf.solved() )
  {
    undo_list.clear ();

    for ( int i = 0; i < tf.nField*tf.nField; i++ )
      buttons->at(i)->setType ( FieldButton::Win );
  }

  updateButtons();
}


void Field::hint ()
{
  int	pos, number;

  pos = tf.guess ( number );
  if ( pos >= 0 )
    buttonSelected ( pos, number-10 );
  else
    qApp->beep();
}


void Field::updateButtons()
{
  for ( int i=0; i<tf.nField*tf.nField; i++ )
  {
    if ( buttons->at(i)->value() != tf.getNum(i) ||
	 buttons->at(i)->type() != FieldButton::Valid )
      buttons->at(i)->setValue( tf.getNum(i) );
  }
}

void Field::number ( int n )
{
  actNumber = n;
}
