/*
 * Created on 20.08.2004
 *
 */
package mapper.GUIComponents;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.JTextField;

/**
 * Der FieldGenerator stellt bestimmt Funktionen für JTextFielder zur Verfügung
 * wie zum Beispiel das Markieren des Textes, sobald man auf ein Textfeld kommt.  
 * 
 * @author Emanuel Eden
 *
 */
public class TextFieldGenerator implements FocusListener{
	
	private JTextField _textField;
	
	/**
	 * Initialisiert das neue Textfeld mit einem FocusListener
	 * @param textField
	 */
	public TextFieldGenerator(String textField) {
		_textField = new JTextField(textField);
		
        _textField.addFocusListener(this);
	}
	
	/**
	 * Liefert das aufgerufene Textfeld zurück
	 * 
	 * @return JTextField liefert das Textfeld zurück
	 */
	public JTextField getTextField() {
		return _textField;
	}
	
	/**
	 * Liefert die Texteingabe dieses Textfeldes zurück
	 * 
	 * @return String Inhalt des Textfeldes
	 */
	public String getText() {
		return _textField.getText();
	}
	
	/**
	 * Markiert das Textfeld vom Anfang bis zum Ende des zur Verfügung 
	 * stehenden Textes
	 */
	public void focusGained(FocusEvent e)
	{ 
		try {
			_textField.setSelectionStart(0);
	        _textField.setSelectionEnd(_textField.getText().length());
	    } catch (Exception ex) { 
	        ex.printStackTrace(System.err);
	    } 
	  }
	
	/**
	 * Löscht die Markierung des Textfeldes sobald man das Textfeld wieder
	 * verlässt.
	 */
	 public void focusLost(FocusEvent e)
	  {
	    try { 
	    	_textField.setSelectionStart(0);
	    	_textField.setSelectionEnd(0);
	    
	    } catch (Exception ex) {
	      ex.printStackTrace(System.err);
	    }
	  } 
}
