/*
 * Created on 17.08.2004
 *
 */
package mapper.GUIComponents;

import javax.swing.ImageIcon;

/**
 * Enthält den Aufbau des NS-Mapper Menüs und der IconBar, sowie dem 
 * Iconverzeichnis.
 * 
 * @author Emanuel Eden
 *
 */
public class Menu {
	
	private static final String _GRAPHICS_DIR = "icons/";

	// Inhalte der Menü Punkte
    public String menuBar[][][] = {	
    		{
    			{"File"}, 
				{"New", "", "There is an active Map in the paintingArea!\nDo you want to overwrite the map?"}, 
				{"Open", "", "There is an active Map in the paintingArea!\nDo you want to overwrite the map?"}, 
				{"Save", "Error:\nThere is nothing to Save.\nYou have to create a map first!", ""}, 
				{"Save as", "Error:\nThere is nothing to Save.\nYou have to create a map first!", ""}, 
				{"Export", "Error:\nThere is nothing to Export.\nYou have to create a map first!", ""}, 
				{"Exit", "", "There is an active Map in the paintingArea!\nDo you realy want to exit the session?",}
			},{
				{"Edit"},
				{"Undo", "", ""},
				{"Copy", "", ""},
				{"Paste", "", ""},
				{"Delete", "", ""},
			},{
				{"Options"},
				{"Node", "Error:\nTo create a node,\nYou have to create a rectangle first!", ""},
				{"Make Path", "Error:\nTo create a path\nYou have to create a node first!", ""},
				{"Add Movementfield", "Error:\nTo create a movementfield with Polygons,\nYou have to create a map first!",""},
				{"Add Rectangle", "Error:\nTo create a rectangle,\nYou have to create a map first!",""},
				{"Sort Nodelist", "Error:\nThere arn't any nodes yet", ""},
			},{
				{"Map"},
				{"Load Picture", "Error:\nYou have to create a map first!",""},
				{"Hide Picture", "Error:\nYou have to load a picture first!", ""},
				{"Zoom in", "Error:\nYou have to create a map first!", ""},
				{"Zoom out", "Error:\nYou have to create a map first!", ""},
			},{
				{"Help"},
				{"Help Contents"},
				{"About"}
    		}};
    
    // Inhalt der Toolbor
    public String iconBar[][]= { 
    		{"New", "New", "Creates a new Map"}, 
			{"Open", "Open", "Open an existing file"},
			{"Save", "Save", "Save a file"},
			{"SaveAs", "Save as", "Save a file with a new name" },
			{"", "", ""},
			{"Cursor", "Cursor", "Set the normal cursor"},
			{"Node", "Node", "Creates a node"},
			{"Movementfield", "Add Movementfield", "Creates a Movementfield with Polygons"},
			{"Rectangle", "Add Rectangle", "Creates a Movementfield with a Rectangle"},
			{"Path", "Make Path", "Creates a path for a node or a MovementField"},
			{"Delete", "Delete", "Removes a node or a rectangle"},
			{"", "", ""},
			{"Map", "Load Picture", "Loads a picture into the map"},
			{"Unvisible", "Hide Picture", "Unvisible the map"}, 
			{"ZoomIn", "Zoom in", "Zoom into a Map"},
			{"ZoomOut", "Zoom out", "Zoom out a Map"},
			{"", "", ""},
			{"Exit", "Exit", "Exit the Programm"}
			};
    
    /**
     * Liefert den Pfad zurück, indem sich die Icons befinden
     * 
     * @return String Name des Icon Directory's
     */
    public String getGraphicsDir(){
    	return _GRAPHICS_DIR;
    }
    
    /**
     * Läd ein ImageIcon als Ressource in die Umgebung hinein. Dies wird verwendet,
     * da es bei dem Export von Java Klassen in ein Jar-File ein Problem mit dem
     * anzeigen von Icons und Bildern hat. Auf diese Weise wird der Fehler umgangen. 
     * 
     * @param i Das Bild das gelanden werden soll.
     * @return ImageIcon Das Icon, das an den Aufrufer der Methode zurückgegeben 
     * werden soll
     */
    public ImageIcon getImage(int i) {
        ImageIcon icon = new ImageIcon(Menu.class.getResource(
                "/" + _GRAPHICS_DIR + iconBar[i][0] +".png"));
        return icon;
    }
}
