/*
 * Created on 12.08.2004
 *
 *
 * TODO Implement the possibility to make a choice and editing from the choicetree
 * TODO Enable the export to NS2 files
 * TODO Implement the save and load options
 * TODO Implement the BitchPoints
 * 
 * TODO - Implement the exceptionhandling of textfields 
 * TODO - Choicetree auf TreeNode umstellen.
 * TODO - Path Wege im ChoiceTree anzeigen.
 * 
 * 
 * 
 */
package mapper.GUIComponents;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ImageIcon;
import javax.swing.JButton;

import java.awt.Container;
import java.awt.BorderLayout;
import java.awt.Cursor;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseEvent;

import java.util.HashSet;

import mapper.DataStrukture.Node;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.ValueTable;
import mapper.DataStrukture.PathLine;
import mapper.DataStrukture.TimeSlot;

/**
 * Diese Klasse enthält den Basisaufbau der GUI wie die MenüLeiste, Icon Bar,
 * Choicetree und der PaintingArea. In dieser Klasse werden auch die Action
 * EventHandler und Mouse Handler abgearbeitet.
 * 
 * @author Emanuel Eden
 * @version 0.1
 */

public class GUIMain extends JFrame implements ActionListener, MouseListener,
        MouseMotionListener {

    // Datenstruktur in dem die Daten für die Nodes und MovementField liegen
    private ValueTable _valueTable = new ValueTable();

    // ChoiceTree für die Lagerung des Verzeichnisses
    private ChoiceTree _choiceTree = new ChoiceTree();

    private Position _constantMouse = new Position(0, 0);

    // Temporärdaten
    private MovementField _movementField;

    private Node _node;

    private PathLine _pline;

    private Object _copyAndPaste;

    // Strukturen für GUI Elemente
    private DeclarationDialogs _dialog;

    private PaintingArea _workbench;

    private JScrollPane _jScrollPane1;

    private JScrollPane _jScrollPane2;

    // Abfragen für Zustände wärend des Ablaufs
    private boolean _mapInWorkbench = false;

    private boolean _pictureInWorkbench = false;

    private boolean _createRectangle = false;

    private int _createMovementField = -1;

    private int _createNode = -1;

    private int _createPath = -1;

    // Initialisierung des Zooms mit 1
    private double _currentZoom = 1.0F;

    /**
     * Initialisierung der GUI, wie oben angegeben.
     *  
     */
    public GUIMain() {

        super("NS-Mapper");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        // GUI Elemente
        Container cp = getContentPane();
        Menu menu = new Menu();
        JToolBar toolBar = new JToolBar();
        JMenuBar menuBar = new JMenuBar();
        _workbench = new PaintingArea();

        _jScrollPane2 = new JScrollPane(_workbench);
        _jScrollPane1 = new JScrollPane(_choiceTree.getTree());

        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                _jScrollPane1, _jScrollPane2);

        // ... auf den Container legen
        cp.add(menuBar, BorderLayout.BEFORE_FIRST_LINE);
        cp.add(toolBar, BorderLayout.NORTH);
        cp.add(splitPane, BorderLayout.CENTER);

        // Erstellen der Menüstruktur
        makeMenu(menuBar, menu);
        makeToolBar(toolBar, menu);
    }

    /**
     * Erstellt die Menübar.
     * 
     * @param menuBar
     *            enthält das Container-Objekt JMenuBar
     * @param menu
     *            enthält die Menüeinträge.
     */
    private void makeMenu(JMenuBar menuBar, Menu menu) {

        for (int i = 0; i < menu.menuBar.length; i++) {
            JMenu menuBarItem = new JMenu(menu.menuBar[i][0][0]);
            menuBar.add(menuBarItem);

            for (int j = 1; j < menu.menuBar[i].length; j++) {
                JMenuItem menuItem = new JMenuItem(menu.menuBar[i][j][0]);
                menuItem.addActionListener(this);
                menuBarItem.add(menuItem);
            }
        }
        setJMenuBar(menuBar);
    }

    /**
     * Erstellt die IconToolBar.
     * 
     * @param toolBar
     *            enthält das Container-Objekt JToolBar
     * @param menu
     *            enthält die Toolbar Einträge
     */
    private void makeToolBar(JToolBar toolBar, Menu menu) {

        Class c = this.getClass();
        for (int i = 0; i < menu.iconBar.length; i++) {
            if (!menu.iconBar[i][0].equals("")) {
                /* TODO Dies ist ein Eclipe oder Java BUG, ich weiss es nicht.
                 * 
                 **** Die kommende Zeile benutzen, wenn man ein JAR-File vom 
                 **** NS-Mapper generieren möchte. Für die normale Ausführung
                 **** die übernächte Zeile verwenden.
                 *
                */
                //JButton btn = new JButton(menu.getImage(i));
                JButton btn = new JButton(new ImageIcon(menu.getGraphicsDir()
                        + menu.iconBar[i][0] + ".png"));
                btn.setActionCommand(menu.iconBar[i][1]);
                btn.setToolTipText(menu.iconBar[i][2]);
                btn.addActionListener(this);
                toolBar.add(btn);
            } else
                toolBar.addSeparator();
        }
    }

    /**
     * ActionEventHandler für die Menü und IconToolBar.
     *  
     */
    public void actionPerformed(ActionEvent ae) {

        String quelle = ae.getActionCommand();
        //System.out.println("ActionEvent : " + quelle);

        if (!_mapInWorkbench) {
            if (quelle.equals("New"))
                menuItem_New();
            if (quelle.equals("Exit"))
                System.exit(0);
            if (quelle.equals("About"))
                OptionPaneDialog(4, "About",
                        "NS-Mapper\nAutor : Emanuel Eden\nVersion 0.1");
            return;
        }

        if (quelle.equals("New"))
            menuItem_New();
        if (quelle.equals("Exit"))
            System.exit(0);
        if (quelle.equals("Copy"))
            menuItem_Copy();
        if (quelle.equals("Paste"))
            menuItem_Paste();
        if (quelle.equals("Delete"))
            menuItem_Delete();
        if (quelle.equals("Node"))
            menuItem_AddNode();
        if (quelle.equals("Add Movementfield"))
            menuItem_AddMovementField();
        if (quelle.equals("Add Rectangle"))
            menuItem_AddRectangle();
        if (quelle.equals("Make Path"))
            menuItem_MakePath();
        if (quelle.equals("Load Picture"))
            menuItem_LoadPicture();
        if (quelle.equals("Hide Picture"))
            menuItem_HidePicture();
        if (quelle.equals("Zoom in"))
            menuItem_ZoomIn();
        if (quelle.equals("Zoom out"))
            menuItem_ZoomOut();
        if (quelle.equals("Cursor"))
            menuItem_Cursor();
        if (quelle.equals("About"))
            OptionPaneDialog(4, "About",
                    "NS-Mapper\nAutor : Emanuel Eden\nVersion 0.1");
    }

    /**
     * Übergabe an ein OptionPaneDialog, es verwaltet z.B Error, Information und
     * Warning Messages. Dabei sind die dialog Nummern, 0=Error, 1 = Information
     * 2 = Warning, 3 = Question, 4= Plane Message.
     * 
     * @param dialogNum
     *            Dialog Nummer.
     * @param windowText
     *            Der Window Text der ausgegeben wird
     * @param descriptionText
     *            Der Erklärungstext
     */
    private void OptionPaneDialog(int dialogNum, String windowText,
            String descriptionText) {

        _dialog = new DeclarationDialogs(this, dialogNum, windowText,
                descriptionText);
        _dialog.setVisible(true);
        _dialog.dispose();
    }

    /**
     * Erstellt ein neues Szenario, das in einem <code>ValueNew</code> Objekt
     * abgespeichert wird.
     *  
     */
    private void menuItem_New() {

        setAllValuesToDefault();

        _dialog = new DeclarationDialogs(this, "New");
        _dialog.setLocationRelativeTo(null);
        _dialog.setVisible(true);

        // Falls nicht Cancel gedrückt wurde, Senaridaten bearbeiten
        if (!_dialog.isCanceled()) {

            // ValueNew vom DeclarationDialog holen
            _valueTable.setValueNew(_dialog.getValue_New());
            _mapInWorkbench = true;
            _workbench.setDimension(_dialog.getValue_New());

            // Die Daten in den JTree einfügen
            _choiceTree = new ChoiceTree(_valueTable.getValueNew()
                    .getSzenarioName(), _valueTable.getValueNew()
                    .getSimulationTime());
            _choiceTree.getTree().addMouseListener(this);
            _jScrollPane1.setViewportView(_choiceTree.getTree());
        }
    }

    /**
     * Bei Cursor werden die momentane Auswahl wieder auf default Werte gelegt.
     * Dazu zählen z.B, das Abbrechen zum erstellen eines Node, Polygon oder
     * Rectangle objektes, sowie der Beendigung einer Markierung.
     *  
     */
    private void menuItem_Cursor() {

        if (_createMovementField > 2) {

            _movementField = _valueTable.setElement(_movementField);
            _choiceTree.add(_movementField);
            _workbench.setValueTable(_valueTable);
        }

        _jScrollPane1.setViewportView(_choiceTree.getTree());

        _createRectangle = false;
        setMovementFieldToDefault(false);
        setNodesToDefault(false);
        setMarkedToDefault(true);
    }

    /**
     * Kopieren eines Objektes. z.B eines Nodes oder MovementFields
     *  
     */
    private void menuItem_Copy() {

        // Wenn sich ein markiertes Objekt in der Workbench befinden, kopieren
        // erlauben
        if (_valueTable.isMarked() != 1)
            _copyAndPaste = _valueTable.getCopy();
    }

    /**
     * Einfügen eines kopierten Objektes.
     *  
     */
    private void menuItem_Paste() {

        if (_copyAndPaste instanceof Node) {
            // _copyAndPast Element in _valueTable einfügen und zurückgeben
            _copyAndPaste = _valueTable.setElement((Node) _copyAndPaste);
            // copyAndPastElement an den ChoiceTree geben
            _choiceTree.add((HashSet) _copyAndPaste);
            // _valueTable an die PainingArea geben
            _workbench.setValueTable(_valueTable);
            // ChoiceTree und PaintingArea auffrischen
            _jScrollPane1.setViewportView(_choiceTree.getTree());
            _jScrollPane2.setViewportView(_workbench);
            // Cursordaten auf default setzen
            menuItem_Cursor();
        }
        if (_copyAndPaste instanceof MovementField) {
            _copyAndPaste = _valueTable
                    .setElement((MovementField) _copyAndPaste);
            _choiceTree.add((MovementField) _copyAndPaste);
            _workbench.setValueTable(_valueTable);
            _jScrollPane1.setViewportView(_choiceTree.getTree());
            _jScrollPane2.setViewportView(_workbench);
            menuItem_Cursor();
        }
        // Alle anderen Daten auf Default setzen
        _copyAndPaste = null;
        _valueTable.setMarkedToDefault();
    }

    /**
     * Fügt einem <code>MovementField</code> ein neues Node Objekt hinzu.
     *  
     */
    private void menuItem_AddNode() {

        // Cursorwerte auf Defualt setzen
        menuItem_Cursor();

        // Den Dialog für Node erstellen
        _dialog = new DeclarationDialogs(this, "Node", computeZRX(),
                computeZRY());
        _dialog.setLocationRelativeTo(null);
        _dialog.setValueTable(_valueTable);
        _dialog.setVisible(true);

        // Wenn nicht der canceled Button gedrückt wurde....
        if (!_dialog.isCanceled()) {
            // HashSet an Nodes holen
            HashSet _nodes = _dialog.getNodeList();

            // Wenn die Nodes direkt auf der PaintingArea gesetzt werden sollen.
            if (_dialog.getSet() == true) {
                // Die Anzahl der zu setzenden Nodes ermitteln
                _createNode = _dialog.getNumberOfNodes();
                // Das Musternode mit den Relevanten Daten setzen
                _node = (Node) _nodes.iterator().next();
                _workbench.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
                return;
            }

            /*
             * Falls die Nodes deklariert oder als zufallsbasiert erstellt
             * werden sollen, ins _valueTable einfügen und an ChoiceTree und
             * PaintingArea geben.
             */
            _nodes = _valueTable.setElement(_nodes);
            _choiceTree.add(_nodes);
            _workbench.setValueTable(_valueTable);

            _jScrollPane1.setViewportView(_choiceTree.getTree());
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Bereitet die AuswahlWerte vor, um ein neues <code>MovementField</code>
     * Objekt zu erstellen.
     */
    private void menuItem_AddMovementField() {

        menuItem_Cursor();

        _workbench.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
        _createMovementField = 0;
    }

    /**
     * Erstellen eines <code>MovementField</code> mithilfe eines Rectangles.
     *  
     */
    private void menuItem_AddRectangle() {

        menuItem_Cursor();
        _workbench.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
        _createRectangle = true;
    }

    /**
     * Erstellt den Bewegungspfad eines <code>Node</code> oder
     * <code>MovementField</code>.
     */
    private void menuItem_MakePath() {

        // ist ein Node oder MovementField markiert?...
        if (_valueTable.isMarked() != -1) {
            // Handelt es sich um ein Node
            if (_valueTable.getMarked() instanceof Node) {
                // Dürfen noch Bewegungselemente dem Node zugefügt werden?
                if (((Node) _valueTable.getMarked()).getTimeScheduler()
                        .isElementsAnymore())
                    return;
                // Ermittelt die Position des Nodes und generiert einen
                // Startpunkt für die
                // PaintingArea
                _pline = new PathLine(((Node) _valueTable.getMarked())
                        .getTimeSlotPosition(), computeZRX(), computeZRY());
            }
            if (_valueTable.getMarked() instanceof MovementField) {
                if (((MovementField) _valueTable.getMarked())
                        .getTimeScheduler().isElementsAnymore())
                    return;
                _pline = new PathLine(((MovementField) _valueTable.getMarked())
                        .getTimeSlotPosition(), computeZRX(), computeZRY());
            }
            // Wenn kein Objekt markiert wurde ...
            _createPath = 0;
        }
    }

    /**
     * Läd eine Karte in das Szenario
     */
    private void menuItem_LoadPicture() {

        _dialog = new DeclarationDialogs(this, 5, "File Chooser");
        _dialog.setVisible(true);
        _dialog.dispose();

        if (!_dialog.isCanceled()) {
            // Bild wurde ausgewählt
            _pictureInWorkbench = true;
            // Bildname an valueTable geben
            _valueTable.getValueNew().setImageFile(_dialog.getImageFile());
            // Bildname an PaintingArea geben
            _workbench.setImageFile(_dialog.getImageFile());
            // Das verhältnis zwischen Karte und Szenario Festlegen
            _valueTable.getValueNew().setRelationship(
                    _workbench.getRelationship());
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Löschte ein Objekt der Form <code>Node</code> oder
     * <code>MovementField</code> aus dem Szenario.
     */
    private void menuItem_Delete() {

        if (!(_valueTable.getKey() == null)) {
            menuItem_Cursor();
            // Element aus dem ChoiceTree löschen während es aus dem ValueTable
            // gelöscht wird
            _choiceTree.remove((_valueTable.remove(_valueTable.getKey())));
            // valueTable der PaintingArea auffrischen
            _workbench.setValueTable(_valueTable);

            _jScrollPane1.setViewportView(_choiceTree.getTree());
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Versteckt die Karte der PaintingArea.
     */
    private void menuItem_HidePicture() {

        if (_pictureInWorkbench) {
            _workbench.hideImage();
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Zoomfaktor um 0.1 Prozent erhöhen.
     *  
     */
    private void menuItem_ZoomIn() {

        zoom(0.1F);
    }

    /**
     * Zoomfaktor um 0.1 Prozent verkleinern.
     *  
     */
    private void menuItem_ZoomOut() {

        if (_currentZoom > 0.5F)
            zoom(-0.1F);
    }

    /**
     * Setzt alle momentan aktivierten Aktionen, wie z.B das Erstellen eines
     * Vierecks oder der Positionierung eines Node-Objekts, zurück auf den
     * Defaultwert, damit eine neue Aktion problemlos, ohne bereits bestehende
     * Werte, bearbeitet werden kann.
     *  
     */
    private void setAllValuesToDefault() {

        setNodesToDefault(false);
        setMovementFieldToDefault(false);
        setMarkedToDefault(false);

        _mapInWorkbench = false;
        _currentZoom = 1.0F;

        _valueTable = new ValueTable();
        _workbench = new PaintingArea();
        _workbench.addMouseListener(this);
        _workbench.addMouseMotionListener(this);

        _jScrollPane1.setViewportView(_choiceTree.getTree());
        _jScrollPane2.setViewportView(_workbench);
    }

    /**
     * Setzt die Node und path Auswahl auf default
     * 
     * @param viewport
     *            Boolean, ob die PaintingArea aufgefrischt werden soll
     */
    private void setNodesToDefault(boolean viewport) {

        _createNode = -1;
        _createPath = -1;

        _workbench.finishPath();
        _workbench.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        if (viewport)
            _jScrollPane2.setViewportView(_workbench);
    }

    /**
     * Setzt die MovementField Auswahl auf Default
     * 
     * @param viewport
     *            Boolean, ob die PaintingArea aufgefrischt werden soll
     */
    private void setMovementFieldToDefault(boolean viewport) {

        _createMovementField = -1;
        _workbench.setMovementField(null);
        _movementField = new MovementField(_valueTable.getValueNew()
                .getSimulationTime());

        if (viewport) {
            _workbench.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Setzt die Markierung auf die Default Werte.
     * 
     * @param viewport
     */
    private void setMarkedToDefault(boolean viewport) {

        _workbench.setMovementField(null);
        _workbench.setNode(null);
        _workbench.setMarked(false);
        _valueTable.unmark();
        _constantMouse.setX(0);
        _constantMouse.setY(0);

        if (viewport) {
            _workbench.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    /**
     * Setzt den Zoomfaktor auf der Paintinarea fest
     * 
     * @param size
     *            fload von Zoomfaktor, kann negative und positive Werte
     *            annehmen
     */
    private void zoom(float size) {

        _currentZoom += size;
        _workbench.zoom(_currentZoom);
        _jScrollPane2.setViewportView(_workbench);
    }

    /**
     * Berechet die Grössenverhältnisse zwichen Zoomfaktor und realem Szenario.
     * 
     * @return Zoomfaktorkorrektur der X-Koordinate
     */
    private double computeZRX() {

        return _currentZoom
                * _valueTable.getValueNew().getRelationship().getX();
    }

    /**
     * Berechet die Grössenverhältnisse zwichen Zoomfaktor und realem Szenario.
     * 
     * @return Zoomfaktorkorrektur der X-Koordinate
     */
    private double computeZRY() {

        return _currentZoom
                * _valueTable.getValueNew().getRelationship().getY();
    }

    /**
     * Wird abgearbeitet, wenn der Mouse Button runtergedrückt wurde. Gilt für
     * den Aufbau eines Rectangles, das im gedrückten Zustand bearbeitet wird.
     */
    public void mousePressed(MouseEvent event) {

        //System.out.println("MouseEvent: " + event);
        // Wenn gerade ein Pfad generiert wird, nicht abarbeiten
        if (_createPath != -1)
            return;
        if (event.getSource().getClass().getName().equals("javax.swing.JTree")) {

        }
        if (event.getSource().getClass().getName().equals(
                "mapper.GUIComponents.PaintingArea")) {
            // Erstellen eines Ractangles
            if (_createRectangle) {
                _valueTable.initialRectangle(new Position(event.getX(), event
                        .getY()));
                return;
            }
            // Beim Verschieben eines Objektes, die Markierung beibehalten
            _valueTable.identify(new Position(event.getX() / computeZRX(),
                    event.getY() / computeZRY()), computeZRX(), computeZRY());
        }
    }

    /**
     * Objekt bearbeiten bei gedrückter Maustaste.
     */
    public void mouseDragged(MouseEvent event) {

        //System.out.println("MouseEvent: " + event);
        // Wenn gerade ein Pfad generiert wird, nicht abarbeiten
        if (_createPath != -1)
            return;
        if (event.getSource().getClass().getName().equals("javax.swing.JTree")) {

        }
        if (event.getSource().getClass().getName().equals(
                "mapper.GUIComponents.PaintingArea")) {
            // Rectangle Grössenverschiebung bearbeiten
            if (_createRectangle) {
                _workbench.setRectangle(_valueTable.getInitialRectangle(),
                        new Position(event.getX(), event.getY()));
                _jScrollPane2.setViewportView(_workbench);
                return;
            }
            // Markiertes Objekt verschieben, Node oder MovementField
            if (_valueTable.isMarked() > -1) {
                //if(!(_valueTable.getMarked() instanceof Node)) {
                if (_valueTable.getMarked() instanceof MovementField) {
                    _valueTable.movePolygonNode(new Position(event.getX()
                            / computeZRX(), event.getY() / computeZRY()));
                    _workbench.setValueTable(_valueTable);
                    _jScrollPane2.setViewportView(_workbench);
                    return;
                }
                if (_valueTable.getMarked() instanceof Node) {
                    _valueTable.moveNode(new Position(event.getX()
                            / computeZRX(), event.getY() / computeZRY()));
                    _workbench.setValueTable(_valueTable);
                    _jScrollPane2.setViewportView(_workbench);
                    return;
                }
            }
            // Konstantes Verscheiben eines MovementFields
            if (_valueTable.isMarked() == -2) {
                if ((_constantMouse.getX() == 0)
                        && (_constantMouse.getY() == 0)) {
                    _constantMouse.setX(event.getX() / computeZRX());
                    _constantMouse.setY(event.getY() / computeZRY());
                }
                _valueTable.moveMovementField(new Position(event.getX()
                        / computeZRX() - _constantMouse.getX(), event.getY()
                        / computeZRY() - _constantMouse.getY()));

                _workbench.setValueTable(_valueTable);
                _jScrollPane2.setViewportView(_workbench);
                _constantMouse.setX(event.getX() / computeZRX());
                _constantMouse.setY(event.getY() / computeZRY());
            }
        }
    }

    /**
     * Wenn der gedrückte MouseButton losgelassen wird.
     */
    public void mouseReleased(MouseEvent event) {

        //System.out.println("MouseEvent: " + event);
        // Wenn gerade ein Pfad generiert wird, nicht abarbeiten
        if (_createPath != -1)
            return;
        if (event.getSource().getClass().getName().equals("javax.swing.JTree")) {

        }
        if (event.getSource().getClass().getName().equals(
                "mapper.GUIComponents.PaintingArea")) {
            // Rectangle Generierung abschließen
            if (_createRectangle) {
                _choiceTree.add(_valueTable.finishRectangle(new Position(event
                        .getX(), event.getY()), computeZRX(), computeZRY()));
                _workbench.finishRectangle();
                _workbench.setValueTable(_valueTable);
                _valueTable.setMarkedToDefault();
                menuItem_Cursor();
                return;
            }
            // Veränderte Werte des Nodes oder MovementFields in den Choicetree
            // und die PaintingArea eintragen.
            if (_valueTable.isMarked() > -1) {
                if (!(_valueTable.getMarked() instanceof Node)) {
                    _choiceTree.set(_valueTable.getMarked());
                    _jScrollPane1.setViewportView(_choiceTree.getTree());
                    _valueTable.unmark();
                } else {
                    _choiceTree.set(_valueTable.getMarked());
                    _jScrollPane1.setViewportView(_choiceTree.getTree());
                    _valueTable.unmark();
                }
            }
            // Veränderte Werte des Pfades in den ChoiceTree eintragen
            if (_valueTable.isMarked() == -2) {
                _choiceTree.set(_valueTable.getMarked());
                _jScrollPane1.setViewportView(_choiceTree.getTree());
                _valueTable.unmark();
            }
            setMarkedToDefault(false);
        }
    }

    /**
     * Maus Button wurde gedrückt
     */
    public void mouseClicked(MouseEvent event) {

        // Event für das Beenden der Teilpfadbewegung eines Objektes
        if (_createPath != -1) {
            createPathFinish(event);
            return;
        }
        // Event für den ChoiceTree
        if (event.getSource().getClass().getName().equals("javax.swing.JTree")) {
            return;
        }
        // Events für die Generierung von Node, MovementField und der Markierung
        // von Objekten.
        if (event.getSource().getClass().getName().equals(
                "mapper.GUIComponents.PaintingArea")) {
            if (_createMovementField > -1) {
                paintingArea_createPolygon(event);
                return;
            }
            if (_createNode > -1) {
                paintingArea_createNode(event);
                return;
            }
            if ((_createMovementField == -1) && (_createNode == -1)) {
                paintingArea_marked(event);
                return;
            }
        }
    }

    /**
     * Mouse Moved Events für die Path Generierung. Erneuert die Linie zwischen
     * Pathabschnittspunkt und Mousecursor
     */
    public void mouseMoved(MouseEvent event) {

        if (_createPath != -1) {
            //Dem _plink den MouseCursor das Ende der Line mitteilen
            _pline.setSink(new Position(event.getX(), event.getY()),
                    computeZRX(), computeZRY());
            // Temporären _plink der PaintingArea geben
            _workbench.setPath(_pline);
            _jScrollPane2.setViewportView(_workbench);
        }
    }

    public void mouseEntered(MouseEvent event) {

    }

    public void mouseExited(MouseEvent event) {

    }

    /**
     * Erstellt ein neuen Polygonpunkt im MovementField
     * 
     * @param event
     *            MouseEvent
     */
    private void paintingArea_createPolygon(MouseEvent event) {

        // Neuen Knoten in das MovementField einfügen
        _movementField.setNode(new Position(event.getX() / computeZRX(), event
                .getY()
                / computeZRY()));
        //Knoten in die Painting Area zeichenen
        _workbench.setMovementField(_movementField);
        // Anzahl der Knoten zählen
        _createMovementField++;
        _jScrollPane2.setViewportView(_workbench);
    }

    /**
     * Fügt einem MovementField eine deklarierte Anzahl von Nodes hinzu.
     * 
     * @param event
     *            MouseEvent
     */
    private void paintingArea_createNode(MouseEvent event) {

        // Neues Node erstellen
        Node node = new Node(_node, _valueTable.getValueNew()
                .getSimulationTime());
        // Positionsdaten des MouseEvents auf den Zoomfaktor umrechenen
        node.setPosition(new Position(event.getX() / computeZRX(), event.getY()
                / computeZRY()));
        // Fehler ausgeben, wenn das Node sich nicht in einem MovementField
        // befindet
        if (!_valueTable.isInMovementList(node.getPosition())) {
            _dialog = new DeclarationDialogs(this, 0, "Error",
                    "Error:\nThe Node has to placed on a MovementField!");
            return;
        }
        // Neues Node in den _valueTable und ChoiceTree eintragen.
        _choiceTree.add(_valueTable.setElement(node));
        // Node in die PaintingArea Eintragen
        _workbench.setValueTable(_valueTable);

        _jScrollPane1.setViewportView(_choiceTree.getTree());
        _jScrollPane2.setViewportView(_workbench);
        // Anzahl der Nodes runterzählen
        _createNode--;
        // Wenn die deklarierte Node Anzahl abgearbeitet ist, wird die
        // Nodedeklaration beendet.
        if (_createNode == 0) {
            _createNode = -1;
            _workbench.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        }
    }

    /**
     * Diese Methode ist zum feststellen, ob sich unter dem Cursor beim Clicken
     * ein Objekt befindet, wenn ja, wird es markiert.
     * 
     * @param event
     *            MouseEvent
     */
    private void paintingArea_marked(MouseEvent event) {

        // Sete alle vormals markierten Werte auf defualt
        setMarkedToDefault(false);
        // Ist ein Element an der angegebenen Position und kopiere es in das
        // Objekt für markierte Zustände
        if (_valueTable.isElementAt(new Position(event.getX() / computeZRX(),
                event.getY() / computeZRY()))) {
            // Handelt es sich dabei um ein Node
            if (_valueTable.getMarked() instanceof Node) {
                // zeige markiertes Objekt in der PaintingArea an
                _workbench.setNode((Node) _valueTable.getMarked());
                // setze PaintingArea Markierung auf true
                _workbench.setMarked(true);

                _valueTable.identify(new Position(event.getX() / computeZRX(),
                        event.getY() / computeZRY()), computeZRX(),
                        computeZRY());

                _jScrollPane2.setViewportView(_workbench);
                return;
            }
            // Handelt es sich bei dem Objekt um ein MovementField
            if (_valueTable.getMarked() instanceof MovementField) {
                _workbench.setMovementField((MovementField) _valueTable
                        .getMarked());
                _workbench.setMarked(true);

                _valueTable.identify(new Position(event.getX() / computeZRX(),
                        event.getY() / computeZRY()), computeZRX(),
                        computeZRY());

                _jScrollPane2.setViewportView(_workbench);
                return;
            }
        }
        // Setze die Markierungen auf den Defaultwert, wenn kein Objekt
        // identifiziert wurde
        _valueTable.setMarkedToDefault();
        _jScrollPane2.setViewportView(_workbench);
    }

    /**
     * Beendet die Bewegungdeklaration für Objekte wie Node oder MovementField
     * 
     * @param event
     *            MouseEvent
     */
    private void createPathFinish(MouseEvent event) {

        TimeSlot timeSlot;
        // Handelt es sich bei dem Objekt um ein MovementField oder Node
        // Kopiert den entsprechenden Timslot des Objekts nach timeSlot
        if (_valueTable.getMarked() instanceof Node)
            timeSlot = ((Node) _valueTable.getMarked()).getTimeSlot();
        else
            timeSlot = ((MovementField) _valueTable.getMarked()).getTimeSlot();

        // Gebe dem Timeslot die Cursorposition mit der korrektur des
        // Zoomfaktors
        timeSlot.setStopPosition(new Position(event.getX() / computeZRX(),
                event.getY() / computeZRY()));

        // Öffne ein Deklarationsdialog um den Zeitschlitz näher zu definieren
        _dialog = new DeclarationDialogs(this, "TimeScheduler", timeSlot);
        _dialog.setLocationRelativeTo(null);
        _dialog.setVisible(true);
        _dialog.dispose();
        // Wenn nicht CANCEL gedrückt wurde:
        if (!_dialog.isCanceled()) {
            timeSlot = _dialog.getTimeSlot();
            // Ist der TimeSchlitz von einem Node, liefer den Timeslot an dieses
            // Node
            if (_valueTable.getMarked() instanceof Node) {
                // Falls der TimeScheduler gravierende Fehler im TimeSlot
                // festgestellt hat ...
                if (!((Node) _valueTable.getMarked()).getTimeScheduler()
                        .setTimeSlot(timeSlot)) {
                    // ...TimeSlot nicht aufnehmen und weitermachen
                    _createPath = -1;
                    return;
                }
                // Fortführen der Pathgenerierung
                _pline = new PathLine(timeSlot.getStopPosition(), computeZRX(),
                        computeZRY());
                _workbench.setValueTable(_valueTable);
                _jScrollPane2.setViewportView(_workbench);
                // Falls keine TimeSlots mehr in den TimeScheduler aufgenommen
                // werden dürfen
                if (((Node) _valueTable.getMarked()).getTimeScheduler()
                        .isElementsAnymore())
                    _createPath = -1;
                return;
            } else {
                // Selbe Verfahrensweise wie oben
                if (!((MovementField) _valueTable.getMarked())
                        .getTimeScheduler().setTimeSlot(timeSlot)) {
                    _createPath = -1;
                    return;
                }
                _pline = new PathLine(timeSlot.getStopPosition(), computeZRX(),
                        computeZRY());
                _workbench.setValueTable(_valueTable);
                _jScrollPane2.setViewportView(_workbench);
                ((MovementField) _valueTable.getMarked())
                        .setStaticStatus(false);
                if (((MovementField) _valueTable.getMarked())
                        .getTimeScheduler().isElementsAnymore())
                    _createPath = -1;
                return;
            }
        }
    }
}