/*
 * Created on 12.08.2004
 *
 */
package mapper.GUIComponents;

import javax.swing.JFrame;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JFileChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.JTabbedPane;

import java.awt.GridLayout;
import java.awt.BorderLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Locale;

import mapper.DataStrukture.ImageFilter;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.ValueNew;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.ValueTable;
import mapper.DataStrukture.TimeSlot;

/**
 * @author Emanuel Eden
 * 
 * TODO Dieser Klasse sollte man die JOptionPane entfernen und in eine eigene Klasse setzen 
 */
public class DeclarationDialogs extends JDialog {

	private TextFieldGenerator _textField[];
	private JComboBox _comboBox[];
	
	private ValueTable _valueTable = new ValueTable();
	private ValueNew _valueNew = new ValueNew();
	private HashSet _nodeList = new HashSet();
	private Node _node = new Node(-1);
	
	private TimeSlot _timeSlot;
	private File _imageFile; 
	private boolean _canceled = true;
	private boolean _setNodes = false;
	private int _numberOfNodes = -1;
	private double _zrx, _zry;
	
	/**
	 * Instanzieren mit einem JFrame als Parent und den String der bestimmt welcher
	 * Dialog angesteuert werden soll. 
	 * 
	 * @param parent Parent des Dialogs
	 * @param str Übergabestring, welcherDialog angesteuert wird.
	 */
	public DeclarationDialogs(JFrame parent, String str) {
		super(parent, str, true);
		
		if(str.equals("New")) 
			menuItem_New();	
	}
	
	/**
	 * Dialog für die Definition eines neuen TimeSlots.
	 * 
	 * @param parent Parent des Dialogs
	 * @param str Name des Ausgewählten Dialogs
	 * @param timeSlot neuer TimeSlot
	 */
	public DeclarationDialogs(JFrame parent, String str, TimeSlot timeSlot) {
		super(parent, str, true);
		
		if(str.equals("TimeScheduler")) {
			_timeSlot = timeSlot;
			menuItem_TimeScheduler();
		}
	}
	
	/**
	 * Für die Erstellung eines neuen Nodes. 
	 * 
	 * @param parent Parent des Dialogs
	 * @param str Name des Dialogs
	 * @param zrx X-Koordinate des Zoomfaktor der PaintingArea 
	 * @param zry Y-Koordinate des Zoomfaktor der PaintingArea
	 */
	public DeclarationDialogs(JFrame parent, String str, double zrx, double zry) {
		super(parent, str, true);
		_zrx = zrx;
		_zry = zry;
		
		if(str.equals("Node"))
			menuItem_Node();
	}
	
	/**
	 * Erstellt eine JOptionPane. Eine JOptionPane ist ein vordefinierter Dialog,
	 * Mit 0 = ErrorMessage, 1 = InformationMessage, 2 = WarningMessage, 
	 * 3 = QuestionMessage, 4 = PlainMessage.
	 * 
	 * @param parent Parent des Dialogs
	 * @param event Event, welche OptionPane angewählt werden soll.
	 * @param str Inhalt des Textes der JOptionPane.
	 */
	public DeclarationDialogs(JFrame parent, int event, String str) {
		
		String WindowText = "NS-Mapper";
		witchContentPane(parent, event, str, WindowText);
	}
	
	/**
	 * Erstellt eine JOptionPane. Eine JOptionPane ist ein vordefinierter Dialog,
	 * Mit 0 = ErrorMessage, 1 = InformationMessage, 2 = WarningMessage, 
	 * 3 = QuestionMessage, 4 = PlainMessage.
	 * 
	 * @param parent Parent des Dialogs
	 * @param event Event, welche OptionPane angewählt werden soll.
	 * @param str Inhalt des Textes der JOptionPane.
	 * @param WindowText Der Text der im Rahmenfenster des Windows angezeigt werden soll.
	 */
	public DeclarationDialogs(JFrame parent, int event, String str, String WindowText) {

		witchContentPane(parent, event, str, WindowText);
	}	
	
	/**
	 * Erstellt eine JOptionPane. Eine JOptionPane ist ein vordefinierter Dialog,
	 * Mit 0 = ErrorMessage, 1 = InformationMessage, 2 = WarningMessage, 
	 * 3 = QuestionMessage, 4 = PlainMessage.
	 * 
	 * @param parent Parent des Dialogs
	 * @param event Event, welche OptionPane angewählt werden soll.
	 * @param str Inhalt des Textes der JOptionPane.
	 * @param WindowText Der Text der im Rahmenfenster des Windows angezeigt werden soll.
	 */
	private void witchContentPane(JFrame parent, int event, String WindowText, String str) {
		
		switch (event) {
		case 0:
			JOptionPane.showMessageDialog(
					parent, str,
					WindowText, JOptionPane.ERROR_MESSAGE);
			break;
		case 1:
			JOptionPane.showMessageDialog(
					getContentPane(), str,
					WindowText, JOptionPane.INFORMATION_MESSAGE);
			break;
		case 2:
			JOptionPane.showMessageDialog(
					getContentPane(), str,
					WindowText, JOptionPane.WARNING_MESSAGE);
			break;
		case 3:
			JOptionPane.showMessageDialog(
					getContentPane(), str,
					WindowText, JOptionPane.QUESTION_MESSAGE);
			break;
		case 4:
			JOptionPane.showMessageDialog(
					getContentPane(), str,
					WindowText, JOptionPane.PLAIN_MESSAGE);
			break;
		case 5:
			JFileChooser fc = new JFileChooser();
			fc.setFileFilter(new ImageFilter());
			fc.showOpenDialog(parent);
			_imageFile = fc.getSelectedFile();
			if(!(_imageFile == null))
				_canceled = false;
			break;
		}
	}
	
	/**
	 * Fenster für die Definition einer neuen Karte.
	 *
	 */
	private void menuItem_New() {
		
		_textField = new TextFieldGenerator[4];
		
		JPanel jPanel1 = new JPanel();
		JPanel jPanel2 = new JPanel();
		       
        JLabel dialogDescription = new JLabel("Create a new map:");
        JLabel szenarioName = new JLabel("Szenario Name");
        JLabel xDimText1 = new JLabel("Width");
        JLabel meter1 = new JLabel("Meter");   
        JLabel yDimText1 = new JLabel("Height");
        JLabel meter2 = new JLabel("Meter");
        JLabel szenarioTime1 = new JLabel("Szenario Time");
        JLabel szenarioTime2 = new JLabel("Milliseconds");
          
        _textField[0] = new TextFieldGenerator("DefaultSzenario"); 
        _textField[1] = new TextFieldGenerator("500");
        _textField[2] = new TextFieldGenerator("500");
        _textField[3] = new TextFieldGenerator("120.0");
        
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
        
        dialogDescription.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(dialogDescription, BorderLayout.NORTH);
        jPanel2.setLayout(new GridLayout(4, 0, 1, 1));
               
        jPanel2.add(szenarioName);       
        jPanel2.add(_textField[0].getTextField());
        jPanel2.add(new JLabel());
        
        jPanel2.add(xDimText1);
        jPanel2.add(_textField[1].getTextField());
        jPanel2.add(meter1);
        
        jPanel2.add(yDimText1);
        jPanel2.add(_textField[2].getTextField());
        jPanel2.add(meter2);
        
        jPanel2.add(szenarioTime1);      
        jPanel2.add(_textField[3].getTextField());
        jPanel2.add(szenarioTime2);
        
        
        getContentPane().add(jPanel2, BorderLayout.CENTER);
        
        // OK and Cancel Button + ihre ActionEvents
        jPanel1.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		_valueNew.setSzenarioName(_textField[0].getText());
        		_valueNew.setDimension(new Position(
        				Double.parseDouble(_textField[1].getText()),
						Double.parseDouble(_textField[2].getText())));
        		_valueNew.setSimulationTime(
        				Double.parseDouble(_textField[3].getText()));
                _canceled = false;
                dispose();
                }
        	}
        );
        jPanel1.add(buttonOK);
        
        buttonCancel.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		_canceled = true;
        		dispose();
        		}
        	}
        );
        jPanel1.add(buttonCancel);
        getContentPane().add(jPanel1, BorderLayout.SOUTH);
        
        pack();
        }
	
	/**
	 * Erstellt ein neues Node oder einen Satz neuer Nodes.
	 */
	private void menuItem_Node() {
			
		JLabel dialogDescription = new JLabel("Creating Nodes");
		_textField = new TextFieldGenerator[4];
	
		JTabbedPane jtp = new JTabbedPane();		
		
		JPanel panel1 = new JPanel();
		JPanel panel2 = new JPanel();
		JPanel panel3 = new JPanel();
		
		JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
			
		dialogDescription.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(dialogDescription, BorderLayout.NORTH);
        
        panel1_Node(panel1);
        panel2_Node(panel2);
        
		jtp.add("Node", panel1);
		jtp.add("Group of Nodes", panel2);
		//jtp.add("Preferences", pln3);
		getContentPane().add(jtp);
		
        panel3.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		
        		_numberOfNodes = Integer.parseInt(_textField[2].getText());
        		if(_comboBox[0].getSelectedItem().equals("Declare")) {
        			boolean isInMovementField = false;
        			Position position = new Position(
            				Double.parseDouble(_textField[0].getText())/_zrx,
    						Double.parseDouble(_textField[1].getText())/_zrx);
        			_node.setPosition(position);
        			if(!_valueTable.isInMovementList(position)) {
        				witchContentPane(new JFrame(), 0, "Error", 
							"Error:\nThe Node has to placed on a MovementField!");
        				return;
        			}
        		}
        		if(_comboBox[0].getSelectedItem().equals("Random"))
        			_node.setRandomStartPoint(true);        	
        		if(_comboBox[0].getSelectedItem().equals("Set"))
        			_setNodes = true;
        		if(_comboBox[1].getSelectedItem().equals("Random"))
        			_node.setRandomMovement(true);
        		
        		for(int i = 0; i< _numberOfNodes; i++) {
        			_node = new Node(_node, _valueTable.getValueNew().getSimulationTime());
        			_nodeList.add(_node);
        		}
                _canceled = false;
                dispose();
                }
        	}
        );
        panel3.add(buttonOK);
        
        buttonCancel.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		_canceled = true;
        		dispose();
        		}
        	}
        );
        panel3.add(buttonCancel);
        getContentPane().add(panel3, BorderLayout.SOUTH);
        
        pack();		
	}
	
	/**
	 * Definiert die Path Variablen eines TimeSchedulers.
	 */
	public void menuItem_TimeScheduler () {
		
		_textField = new TextFieldGenerator[5];
		
		JPanel jPanel1 = new JPanel();
		JPanel jPanel2 = new JPanel();
		
		JLabel dialogDescription = new JLabel("Create a path:");
		
		JLabel startPos = new JLabel("Startposition :");
		JLabel startPosition = new JLabel("" + _timeSlot.getStartPosition());
		
		JLabel stopPosX = new JLabel("Start Position x ");
		JLabel stopPosY = new JLabel("Stop  Position y ");
		JLabel startTIME = new JLabel("Start Time");
		JLabel startTIMELabel = new JLabel("" + _timeSlot.getStartTime());
		JLabel startTime = new JLabel("Start Time");
		JLabel stopTime = new JLabel("Stop  Time");
		JLabel speed = new JLabel("Speed");
		
		JLabel meter1 = new JLabel("Meter");
		JLabel meter2 = new JLabel("Meter");
		JLabel meter3 = new JLabel("Meter");
		JLabel time1 = new JLabel("Seconds");
		JLabel time2 = new JLabel("Seconds");
		JLabel time3 = new JLabel("Seconds");
		JLabel speedV = new JLabel("km/h");

		_textField[0] = new TextFieldGenerator("" +
				format(_timeSlot.getStopPosition().getX()));
		_textField[1] = new TextFieldGenerator("" +
				format(_timeSlot.getStopPosition().getY()));
		_textField[2] = new TextFieldGenerator("" +
				_timeSlot.getStartTime());
		_textField[3] = new TextFieldGenerator("" +
				_timeSlot.getStopTime());
		_textField[4] = new TextFieldGenerator("" +
				_timeSlot.getSpeed());
		
		dialogDescription.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(dialogDescription, BorderLayout.NORTH);
        jPanel2.setLayout(new GridLayout(7, 3, 1, 1));
        
        jPanel2.add(startPos);
        jPanel2.add(startPosition);
        jPanel2.add(meter1);
        
        jPanel2.add(stopPosX);
        jPanel2.add(_textField[0].getTextField());
        jPanel2.add(meter2);
        
        jPanel2.add(stopPosY);
        jPanel2.add(_textField[1].getTextField());
        jPanel2.add(meter3);
        
        jPanel2.add(startTIME);
        jPanel2.add(startTIMELabel);
        jPanel2.add(time1);
        
        jPanel2.add(startTime);
        jPanel2.add(_textField[2].getTextField());
        jPanel2.add(time2);
        
        jPanel2.add(stopTime);
        jPanel2.add(_textField[3].getTextField());
        jPanel2.add(time3);
        
        jPanel2.add(speed);
        jPanel2.add(_textField[4].getTextField());
        jPanel2.add(speedV);
        
        getContentPane().add(jPanel2, BorderLayout.CENTER);
		
		JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
		
		
//		 OK and Cancel Button + ihre ActionEvents
        jPanel1.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		if(Double.parseDouble(_textField[4].getText()) == 0.0) {
        			_timeSlot = new TimeSlot(
        					Double.parseDouble(_textField[2].getText()),
        					Double.parseDouble(_textField[3].getText()),
        					_timeSlot.getStartPosition(),
        					new Position(
        							Double.parseDouble(_textField[0].getText()),
        							Double.parseDouble(_textField[1].getText())));
        		} else {
        			_timeSlot = new TimeSlot(
        					Double.parseDouble(_textField[4].getText()),
        					_timeSlot.getStartPosition(),
        					new Position(
        							Double.parseDouble(_textField[0].getText()),
        							Double.parseDouble(_textField[1].getText())),
									Double.parseDouble(_textField[2].getText()));
        		}
                _canceled = false;
                dispose();
                }
        	}
        );
        jPanel1.add(buttonOK);
        
        buttonCancel.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		_canceled = true;
        		dispose();
        		}
        	}
        );
        jPanel1.add(buttonCancel);
        getContentPane().add(jPanel1, BorderLayout.SOUTH);
        
        pack();
	}
	
	/**
	 * Erster Panel der Node Deklaration. Setzt die Werte für ein Node fest.
	 * 
	 * @param panel Panel auf den der Dialog gesetzt werden soll
	 */
	private void panel1_Node(JPanel panel) {
				
		_comboBox = new JComboBox[2];
		JLabel startPoint = new JLabel("Start Point: ");
		JLabel xDimText1 = new JLabel("Width");
        JLabel meter1 = new JLabel("Meter");   
        JLabel yDimText1 = new JLabel("Height");
        JLabel meter2 = new JLabel("Meter");
        JLabel movement = new JLabel("Movement");
        JLabel groupNodes = new JLabel("Number of Nodes");
        
        _textField[0] = new TextFieldGenerator("50");
        _textField[1] = new TextFieldGenerator("50");
        _textField[2] = new TextFieldGenerator("1");
				
        _comboBox[0] = new JComboBox(new String[] {
        		"Set",
        		"Declare",
				"Random"});
		_comboBox[1] = new JComboBox(new String[] {
        		"Set",
				"Random"});
		
		panel.setLayout(new GridLayout(5, 3, 1, 1));
        panel.add(startPoint);
        panel.add(_comboBox[0]);
        _comboBox[0].addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		if(_comboBox[0].getSelectedItem().equals("Declare")) {
        			_textField[0].getTextField().setEditable(true);
        			_textField[1].getTextField().setEditable(true);
        			return;
        		}
        		_textField[0].getTextField().setEditable(false);
        		_textField[1].getTextField().setEditable(false);
        		
        		}
        	}
        );
        panel.add(new JLabel());
        panel.add(xDimText1);
        _textField[0].getTextField().setEditable(false);
        panel.add(_textField[0].getTextField());
        panel.add(meter1);       
        panel.add(yDimText1);
        _textField[1].getTextField().setEditable(false);
        panel.add(_textField[1].getTextField());
        panel.add(meter2);
        
        panel.add(movement);
        panel.add(_comboBox[1]);
        panel.add(new JLabel());
        
        panel.add(groupNodes);
        panel.add(_textField[2].getTextField());
        panel.add(new JLabel());
	}
	
	/**
	 * Zweites Panel der Node Deklaration. Setzt die Werte für ein Node fest.
	 * 
	 * @param panel Panel auf den der Dialog gesetzt werden soll
	 */
	private void panel2_Node(JPanel panel) {
		
	}
	
	/**
	 * Liefert die Daten des neu zu erstellenden Nodes in einem HashSet zurück.
	 * 
	 * @return HashSet mit Nodes.
	 */
	public HashSet getNodeList() {
		return _nodeList;
	}
	
	/**
	 * Liefert die komplette Anzahl aller erstellten Nodes.
	 * 
	 * @return int Anzahl der Nodes die in dem letzten Dialog definiert wurden.
	 */
	public int getNumberOfNodes() {
		return _numberOfNodes;
	}
	
	/**
	 * Liefert zurück, ob die Nodes, die im Dialog erstellt wurden direkt auf die 
	 * PaintingArea gesetzt werden sollen oder ob sie im Vorhinein deklariert wurden
	 * oder ob sie in einem zufallsbasierten Verfahren in der PaintingArea gesetzt 
	 * werden. 
	 * 
	 * @return boolean Liefert zurück ob die Nodes direkt auf die PaintingArea
	 * gesetzt werden sollen.
	 */
	public boolean getSet() {
		return _setNodes;
	}
	
	/**
	 * Liefert ein neues ValueTable für die DialogInformationen.
	 * 
	 * @param valueTable Setzt ein neues ValueTable.
	 */
	public void setValueTable(ValueTable valueTable) {
		_valueTable = valueTable;
	}
	
	/**
	 * Liefert das neu erstellte ValueTable zurück. 
	 * 
	 * @return Liefert das Neue ValueTable zurück.
	 */
	public ValueNew getValue_New(){
		return _valueNew;
	}
	
	/**
	 * Liefert einen neuen TimeSlot an den Dialog.
	 * 
	 * @param timeSlot Neuer TimeSlot.
	 */
	public void setTimeSlot(TimeSlot timeSlot) {
		_timeSlot = new TimeSlot(timeSlot);
	}
	
	/**
	 * Liefert den neuen TimeSlot zurück
	 * 
	 * @return TimeSlot Liefert den TimeSlot zurück.
	 */
	public TimeSlot getTimeSlot(){
		return _timeSlot;
	}
	
	/**
	 * Liefert den Ort und den Namen eines neuen Files für die PaintingArea zurück. 
	 * 
	 * @return Location und Name des Karten-Images
	 */
	public File getImageFile() {
		return _imageFile;
	}
	
	/**
	 * Liefert zurück, ob bei einem Dialog der Canceld Button. Falls <code>isCanceled</code>
	 * ein <code>true</code> zurückliefert, werden keine Daten aus den Dialogen
	 * zurückgegeben.
	 * 
	 * @return Liefert in einem Boolean Wert zurück, ob der Cancel Button gedrückt wurde.
	 */
	public boolean isCanceled() {
		return _canceled;
	}
	
	/**
	 * Bereitet die Ausgabe für alle double Werte auf, die eine zu lange Ausgabe 
	 * produzieren würden.
	 *  
	 * @param value double Wert der für eine Ausgabe aufbereitet werden soll.
	 * @return  String Gibt den aufbereiteten Double Wert in einem String zurück. 
	 */
	private String format(double value) {
		DecimalFormat dec = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
		dec.applyPattern("######0.00");
		return dec.format(value);
	}
}
