/*
 * Created on 20.08.2004
 *
 */
package mapper.GUIComponents;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

import java.util.Iterator;
import java.util.HashSet;

import mapper.DataStrukture.Node;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Position;

/**
 * Diese Klasse beinhaltet die Bearbeitung des JTrees. Es erstellt den Auswahlbaum 
 * mit allen MovementFields und Nodes, sowie alle zusätzlichen Informationen
 * zum gerade zu bearbeitenden Szenario.
 *  
 * @author Emanuel Eden
 */
public class ChoiceTree {
	
    // Die drei Basisknoten
	private DefaultMutableTreeNode _treeRoot = new DefaultMutableTreeNode("Maps");
	private DefaultMutableTreeNode _treeMovementField = new DefaultMutableTreeNode("Movement Fields");
	private DefaultMutableTreeNode _treeNode = new DefaultMutableTreeNode("Nodes");
	
	private JTree _tree;
	private DefaultTreeModel model;
	
	/**
	 * Initialisiet den Baum, wenn noch kein Szenario ausgewählt oder bestimmt
	 * wurde. Damit der Platz des ChoiceTrees von Anfang eine angenehme Position-
	 * ierungsgrösse besitzt, werden bereits die Fächer für MovementField und Nodes
	 * angezeigt, ohne daß sie einen Nutzen haben.
	 *
	 */
	public ChoiceTree() {
		
		_treeRoot.add(_treeMovementField);
    	_treeRoot.add(_treeNode);
		_tree = new JTree(_treeRoot);
	}
	
	/**
	 * In dieser Instanzierung werden nun der Szenarioname und die Szenario Zeit
	 * im ChoiceTree angezeigt.
	 * 
	 * @param szenarioName Name des Szenarios
	 * @param simulationTime Laufzeit des Szenarios
	 */
	public ChoiceTree(String szenarioName, double simulationTime) {
		
		_treeRoot = new DefaultMutableTreeNode(szenarioName);
		_treeRoot.add(new DefaultMutableTreeNode("SimTime: " + simulationTime));
		_treeRoot.add(_treeMovementField);
    	_treeRoot.add(_treeNode);
    	_tree = new JTree(_treeRoot);
	}
	
	/**
	 * Liefert den momentanen Baum des ChoiceTrees zurück.
	 * 
	 * @return JTree der zurückgelieferte ChoiceTree
	 */
	public JTree getTree() {
		
		return _tree;
	}
	
	/**
	 * Hiermit wird ein neues MovementField dem ChoiceTree hinzugefügt.
	 * 
	 * @param movementField Liefert ein neues MovementField an den ChoiceTree
	 */
	public void add(MovementField movementField) {
		
		DefaultMutableTreeNode movementFieldValues = 
			new DefaultMutableTreeNode("Field(" + movementField.getName() + ")");
		DefaultMutableTreeNode movementFieldNodes =
			new DefaultMutableTreeNode("Dimension");
		
		movementFieldValues.add(new DefaultMutableTreeNode("Static: " 
				+ movementField.getStaticStatus()));
		
		Iterator iter = movementField.getNodes().iterator();
		
		while(iter.hasNext()) {
			Object element = iter.next();
			movementFieldNodes.add(new DefaultMutableTreeNode(((Position) element)));
		}
		
		movementFieldValues.add(movementFieldNodes);
		_treeMovementField.add(movementFieldValues);
		_tree = new JTree(new DefaultTreeModel(_treeRoot));
	}
	
	/**
	 * Liefert ein HashSet an neuen Nodes an den ChoiceTree und fügt alle in den
	 * JTree ein.
	 * 
	 * @param nodes HashSet an Nodes die in den ChoiceTree eingefügt werden sollen.
	 */
	public void add(HashSet nodes) {
		Iterator iter = nodes.iterator();
		while(iter.hasNext()) {
			
			Node node = (Node) iter.next();
			DefaultMutableTreeNode nodeValues = 
				new DefaultMutableTreeNode("Node(" + node.getName() + ")");
			
			
			nodeValues.add(new DefaultMutableTreeNode("Random Startpoint: " 
					+ node.isRandomStartPoint()));
			nodeValues.add(new DefaultMutableTreeNode("Random Movement: " 
					+ node.getRandomMovement()));
			nodeValues.add(new DefaultMutableTreeNode("Position: " + node.getPosition()));
			
			_treeNode.add(nodeValues);
			_tree = new JTree(new DefaultTreeModel(_treeRoot));
		}
	}
	
	/**
	 * Löscht entweder ein Node oder ein Movementfield Objekt aus dem ChoiceTree 
	 * raus. Dieses Objekt beinhaltet entweder ein <code>Node</code> oder ein
	 * <code>MovementField</code> in einem Objekt.
	 * 
	 * @param element Element das aus dem ChoiceTree entfernt werden soll
	 */
	public void remove(Object element) {
		//System.out.println("Childs"+ _treeMovementField.getChildCount());
		String str1, str2;
		TreeNode tree;
		Object _element;
		if(element instanceof Node) {
			for(int i = 0; i<_treeNode.getChildCount(); i++) {
				TreeNode node = _treeNode.getChildAt(i);
				if(node.toString().equals("Node(" + ((Node) element).getName() + ")")) {
					_treeNode.remove(i);
					_tree = new JTree(new DefaultTreeModel(_treeRoot));
				}
			}			
		} else {
			for(int i = 0; i<_treeMovementField.getChildCount(); i++) {
				TreeNode node = _treeMovementField.getChildAt(i);
				if(node.toString().equals("Field(" + ((MovementField) element).getName() + ")")) {
					_treeMovementField.remove(i);
					_tree = new JTree(new DefaultTreeModel(_treeRoot));
				}
			}			
		}
	}
	
	/**
	 * Kann ein einzelnes Element in den ChoiceTree einfügen. Das übergebene 
	 * Objekt ist entweder von der Form <code>Node</code> oder von der Form 
	 * <code>MovementField</code>.
	 * 
	 * @param element Objekt von der Form Node oder MovementField
	 */
	public void set(Object element) {
		String str1, str2;
		TreeNode tree;
		Object _element;
		if(element instanceof Node) {
			for(int i = 0; i<_treeNode.getChildCount(); i++) {
				TreeNode node = _treeNode.getChildAt(i);
				if(node.toString().equals("Node(" + ((Node) element).getName() + ")")) {
					_treeNode.remove(i);
					HashSet nodes = new HashSet();
					nodes.add(element);
					add(nodes);
					_tree = new JTree(new DefaultTreeModel(_treeRoot));
				}
			}
		}
		if(element instanceof MovementField) {
			for(int i = 0; i<_treeMovementField.getChildCount(); i++) {
				TreeNode node = _treeMovementField.getChildAt(i);
				if(node.toString().equals("Field(" + ((MovementField) element).getName() + ")")) {
					_treeMovementField.remove(i);
					add((MovementField) element);
					_tree = new JTree(new DefaultTreeModel(_treeRoot));
				}
			}			
		}
	}
}
