/*
 * Created on 20.08.2004
 *
 */
package mapper.GUIComponents;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
//import javax.swing.tree.TreeNode;

//import java.util.HashMap;
import java.util.Iterator;
//import java.util.HashSet;
import java.util.Map;

import mapper.DataStrukture.Node;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.ValueTable;

/**
 * @author Emanuel Eden
 *
 */
public class ChoiceTre extends JTree{

	private DefaultMutableTreeNode _root = new DefaultMutableTreeNode("Map");
	private DefaultMutableTreeNode _movementField = new DefaultMutableTreeNode("MovementField");
	private DefaultMutableTreeNode _node = new DefaultMutableTreeNode("Node");
	
	private ValueTable _valueTable = new ValueTable();
	
	public ChoiceTre() {
		_root.add(_movementField);
		_root.add(_node);
		this.setModel(new DefaultTreeModel(_root));
	}
	
	public ChoiceTre(ValueTable valueTable) {
		
		_root = new DefaultMutableTreeNode(
				valueTable.getValueNew().getSzenarioName());
		_root.add(new DefaultMutableTreeNode("SimTime: " + 
				valueTable.getValueNew().getSimulationTime()));
		_root.add(_movementField);
    	_root.add(_node);
    	this.setModel(new DefaultTreeModel(_root));
	}
	
	public void add(ValueTable valueTable) {
		
		_root = new DefaultMutableTreeNode(
				valueTable.getValueNew().getSzenarioName());
		_root.add(new DefaultMutableTreeNode("SimTime: " + 
				valueTable.getValueNew().getSimulationTime()));
		_root.add(_movementField);
    	_root.add(_node);
    	
		// MovementFields
		Iterator iter = valueTable.getMovementFieldList().entrySet().iterator();
		
		while(iter.hasNext()) {
			//System.out.println(iter.next());
			MovementField movementField = (MovementField) ((Map.Entry) iter.next()).getValue();
			System.out.println(movementField);
			DefaultMutableTreeNode movementFieldValues = 
				new DefaultMutableTreeNode("Field(" + movementField.getName() + ")");
			DefaultMutableTreeNode movementFieldNodes =
				new DefaultMutableTreeNode("Dimension");
			movementFieldValues.add(new DefaultMutableTreeNode("Static: " 
					+ movementField.getStaticStatus()));
			
			Iterator iterator = movementField.getNodes().iterator();
			
			while(iterator.hasNext()) {
				Object element = iterator.next();
				movementFieldNodes.add(new DefaultMutableTreeNode(((Position) element)));
			}
			
			movementFieldValues.add(movementFieldNodes);
			_movementField.add(movementFieldValues);
			//this.add(_root);
		}
		
		iter = valueTable.getNodes().iterator();
		System.out.println(iter);
		while(iter.hasNext()) {
			
			Node node = (Node) iter.next();
			DefaultMutableTreeNode nodeValues = 
				new DefaultMutableTreeNode("Node(" + node.getName() + ")");
			
			
			nodeValues.add(new DefaultMutableTreeNode("Random Startpoint: " 
					+ node.isRandomStartPoint()));
			nodeValues.add(new DefaultMutableTreeNode("Random Movement: " 
					+ node.getRandomMovement()));
			nodeValues.add(new DefaultMutableTreeNode("Position: " + node.getPosition()));
			
			//_treeNode.add(nodeValues);
		}
		_root.add(_movementField);
		_root.add(_node);
		
		this.setModel(new DefaultTreeModel(_root));
	}
}
