/*
 * Created on 17.08.2004
 *
 */
package mapper.DataStrukture;


/**
 * Diese Klasse beinhaltet die Basiks zum erstellen eines Szenarios. Hier wird die 
 * Simulationszeit, der Simulationsname, das Hintergrundbild, die Dimensionen des 
 * Simulationsfeldes festgelegt, sowie das Größenverhältnis zwischen den Dimensionen
 * eines Szenarios und dessen Hintergrundmap.
 * 
 * @author Emanuel Eden
 *
 **/
public class ValueNew {
	
	// Name des Szenarios
	private String _szenarioName;
	// Hintergrundkarte des Szenarios
	private java.io.File _imageFile;
	// Dimensionen des Szenarios
	private Position _dimension = new Position();
	// Ausmaßenunterschiede zwischen Szenario und Hintergrundkarte
	private Position _relationship = new Position(1,1);
	// Simulationszeitraum von 0 bis _simulationTime
	private double _simulationTime;
	
	/**
	 * Erstellt ein ValueNew Objekt mit Namen "Default Szenario" und einem Simulations
	 * Zeitraum von 1000 Sekunden.
	 */
	public ValueNew () {
		_szenarioName = "Default Simulation";
		_simulationTime = 1000;
	}
	
	/**
	 * Initialisierung eines neuen Szenarios. Mit dem Szenarionamen, den Dimensionen
	 * des Szenariofeldes, sowie dem Simulationszeitraum, mittels eines ValueNew 
	 * Objektes.
	 * 
	 * @param valueNew Initialisierung mit einem valueNew Objekt.
	 */
	public ValueNew (ValueNew valueNew) {
		_szenarioName = valueNew.getSzenarioName();
		_dimension = valueNew.getDimension();
		_simulationTime = valueNew.getSimulationTime();
	}
	
	/**
	 * Setzen eines neuen Szenarionamens
	 * 
	 * @param szenarioName Name des Szenarios
	 */
	public void setSzenarioName(String szenarioName) {
		_szenarioName = szenarioName;
	}
	
	/**
	 * Liefert den Szenarionamen.
	 * 
	 * @return String SLiefert den Szenarionamen in einm String
	 */
	public String getSzenarioName() {
		return _szenarioName;
	}
	
	/**
	 * Ausmaße oder Dimensionen des Szenariofeldes. Die Dimension wird mittels eines 
	 * einzigen <code>Position</code> Objektes geliefert, da die Szenariodimension immer
	 * bei (0,0) im Ursprung beginnt.
	 * 
	 * @param dimension Setzt die Dimension des Szenarios mittels <code>Position</code>
	 */
	public void setDimension(Position dimension) {
		_dimension = new Position(dimension);
	}
	
	/**
	 * Liefert die Dimension des Szenarios mittels eines <code>Position</code> Objektes
	 * zurück.
	 * @return Position Dimension des Szenaios
	 */
	public Position getDimension() {
		return _dimension;
	}
	
	/**
	 * Setzt die Simulationszeit fest, in Sekunden.
	 * 
	 * @param simulationTime Die Simulationszeit wird mit einem Doublewert in Sekunden 
	 * angegeben.
	 */
	public void setSimulationTime(double simulationTime) {
		_simulationTime = simulationTime;
	}
	
	/** 
	 * Liefert die Simulationszeit zurück in Sekunden.
	 * 
	 * @return double Simulationszeit in Sekunden
	 */
	public double getSimulationTime() {
		return _simulationTime;
	}
	
	/**
	 * Liefert die Dimensionsdifferenz zwischen Szenariogrösse und Kartenausmaßen 
	 * als <code>Position</code> zurück, da die Szenariogrösse dem Bild angepasst
	 * werden muss.
	 * 
	 * @return Position Differenz zwischen Szenario und Karte
	 */
	public Position getRelationship(){
		return _relationship;
	}
	
	/**
	 * Setzt eine neue Relation zwischen SzenarioDimensionen und Kartendimensionen.
	 * 
	 * @param relationship Setzt Differenz zwischen Karte und Szenariodimensionen.
	 */
	public void setRelationship(Position relationship) {
		_relationship = relationship;
	}
	
	/**
	 * Setzt den Namen der Szenariokarte.
	 * 
	 * @param imagefile Name der Szenariokarte.
	 */
	public void setImageFile(java.io.File imagefile) {
		_imageFile = imagefile;
	}
	
	/**
	 * Liefert den Namen der gerade verwendeten Szenariokarte.
	 * 
	 * @return File Name der Szenariokarte.
	 */
	public java.io.File getImageFile() {
		return _imageFile;
	}
}
