/*
 * Created on 31.08.2004
 *
 *
 */
package mapper.DataStrukture;

import java.util.ArrayList;
/**
 * Diese Klasse enthält und verarbeitet die TimeSlots und überprüft, ob diese richtig vom 
 * Anwender gesetzt worden sind. Einige einträge in dieser Klasse scheinen nicht sinnvoll
 * zu sein, jedoch habe ich statt einer Arraylist, anfangs ein HashMap verwendet, das sich 
 * jedoch, als nicht praktikabel herausstellte, um einer komplette Neuimplementierung der 
 * auf diese Klasse zugreifenden Methoden zu unterbinden, habe ich die Datenstruktur, den
 * alten Gegebenheiten angepasst. 
 * 
 * @author Emanuel Eden
 *
 */
public class TimeScheduler {
	
	// ArrayList der TimeSlots
	ArrayList _timeSlotList = null;
	// Position des Ersten Elements
	int _firstElement = -1;
	// Position des letzten Elements
	int _lastElement = -1;
	// Simulationszeit
	double _simulationTime;
	
	// Wenn keine Elemente mehr in die ArrayList eingefügt werden dürfen
	boolean _noElementsAnymore = false;
	
	/**
	 * Initialisierung eines neuen TimeSchedulers mit der komplette Laufzeit der Simulation
	 * 
	 * @param simulationTime Simulationszeit in Sekunden.
	 */
	public TimeScheduler(double simulationTime) {
		_simulationTime = simulationTime;
		_timeSlotList = new ArrayList();
	}
	
	/**
	 * Liefert die Simulationszeit des TimeSchedulers. Eigentlich könnte die Simulationslauf-
	 * zeit auch durch die<code>ValueNew</code> Struktur ermittelt werden. Zum bessern 
	 * Verständnis gibt jedes TimeScheduler Objekt seine Laufzeit zurück, obgleich sie immer 
	 * den selben Wert hat
	 * 
	 * @return double Simulationslaufzeit
	 */
	public double getSimTime() {
		return _simulationTime;
	}
	
	/**
	 * Fügt einen Neuen TimeSlot in den TimeScheduler ein. Dieses TimeSlot Element kann nur 
	 * an das Ende der Liste abgefügt werden. Ein Hinzufügen von TimeSlot Elementen ist dann 
	 * nicht mehr möglich, wenn die Laufzeit des TimeSchedulers überschritten wurde. 
	 * 
	 * @param timeSlot Hinzuzufügendes TimeSlot Element
	 * @return boolean Wert, ob der TimeSlot auch hinzugefügt wurde, oder ob ein Hinzufügen untersagt wurde.
	 */
	public boolean setTimeSlot(TimeSlot timeSlot) {
		// Darf man noch keine Elemente mehr hinzufügen? Wenn nein ..
		if(_noElementsAnymore)
			return false;
		// Existiert bereits ein TimeSlot im TimeScheduler? Wenn ja ..
		if(_lastElement != -1) {
			TimeSlot slot = (TimeSlot) _timeSlotList.get(_lastElement);
			// Wenn die Stoppzeit grösser ist als die aktuelle Startzeit, dann Startzeit 
			// anpassen.
			if(slot.getStopTime() > timeSlot.getStartTime())
				timeSlot.setStartTime(slot.getStopTime());
		}
		// Erstes Element auf 0 setzen wenn eine TimeSlot eingefügt wird.
		if(_firstElement == -1)
			_firstElement++;
		// Schauen, ob die Stoptzeit nicht die Simulationszeit übersteigt 
		if(timeSlot.getStartTime() >= _simulationTime){
			_noElementsAnymore = true;
			timeSlot.setStopPosition(timeSlot.getStartPosition());
			timeSlot.setStartTime(_simulationTime); 
			timeSlot.setStopTime(_simulationTime);
		}
		// Schauen, ob die Stoptzeit nicht die Simulationszeit übersteigt 
		if(timeSlot.getStopTime() >= _simulationTime){
			_noElementsAnymore = true;
			timeSlot.setStopPosition(timeSlot.getStartPosition());
			timeSlot.setStopTime(_simulationTime);		
		}
		_timeSlotList.add(timeSlot);
		_lastElement++;
		return true;
	}
	
	/**
	 * Liefert die Position des ersten TimeSlots im TimeScheduler.
	 *  
	 * @return int PositionsKey des ersten Elementes
	 */
	public int getFirstKey() {
		return _firstElement;
	}
	
	/**
	 * Liefert den ersten TimeSlot im TimeScheduler zurück
	 * 
	 * @return TimeSlot Erstes Element im TimeScheduler
	 */
	public TimeSlot getFirstTimeSlot() {
		return (TimeSlot) _timeSlotList.get(_firstElement);
	}
	
	/**
	 * Liefert den Positions Key des letzten TimeSlots zurück
	 * 
	 * @return int PositionsKey des letzen TimeSlots im TimeScheduler
	 */
	public int getLastKey() {
		return _lastElement;
	}
	
	/**
	 * Liefert den letzten TimeSlot im TimeScheduler zurück
	 * 
	 * @return TimeSlot Letzes Element im TimeScheduler
	 */
	public TimeSlot getLastTimeSlot() {
		return (TimeSlot) _timeSlotList.get(_lastElement);
	}
	
	/**
	 * Liefert den TimeSlot an der angegebenen Position zurück.
	 * 
	 * @param key Integer Wert des TimeSlots
	 * @return TimeSlot an der angegebenen Position
	 */
	public TimeSlot getTimeSlot(int key) {
		return (TimeSlot) _timeSlotList.get(key);
	}
	
	/**
	 * Liefert den Nachfolger eines TimeSlots
	 * 
	 * @param key Integerwert des verfügbaren Timeslots
	 * @return int TimeSlot Positionskey des Nachfolgers
	 */
	public int getSuccessor(int key) {
		if(key >= _lastElement) 
			return -1;
		else
			return key+1; 
	}
	
	/**
	 * Liefert die Grösse der TimeScheduler Liste zurück
	 * 
	 * @return int Grösse des TimeScheduler Liste.
	 */
	public int Size() {
		return _lastElement+1;
	}
	
	/**
	 * Erfragt, ob noch Elemente zum TimeScheduler hinzugefügt werden dürfen.
	 * 
	 * @return boolean <code>false</code> falls noch Elemente hinzugefügt werden dürfen.
	 */
	public boolean isElementsAnymore() {
		return _noElementsAnymore;
	}
	
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("TimeScheduler[");
		buffer.append("_timeSlotList = ").append(_timeSlotList);
		buffer.append(", _firstElement = ").append(_firstElement);
		buffer.append(", _lastElement = ").append(_lastElement);
		buffer.append(", _simulationTime = ").append(_simulationTime);
		buffer.append(", _noElementsAnymore = ").append(_noElementsAnymore);
		buffer.append("]");
		return buffer.toString();
	}
}
