/*
 * Created on 21.08.2004
 *
 */
package mapper.DataStrukture;

/**
 * Die Klasse PositionArray implementiert eine dynamische Grösse eines Arrays. Der Grund 
 * weswegen ich keine Vektoren oder ArrayList verwende ist, daß das Löschen von Polygonen 
 * nicht unterstützt wird und die Zeit da ist, das Array nur im die Grösse Eins zu erhöhen. 
 * 
 * @author Emanuel Eden
 *
 */
public class PositionArray {
	
	// Array aller X-Koordinaten des Polygons
	int _pointsX[];
	// Array aller Y-Koordinaten des Polygons
	int _pointsY[];
	// Temporärarray aller X-Koordinaten des Polygons
	int _tmpX[];
	// Temporärarray aller Y-Koordinaten des Polygons
	int _tmpY[];
	// Zoomfaktoren 
	double _zrx;
	double _zry;
	
	/**
	 * Initialisierung des Polygons mit der Knotenanzahl Eins.
	 * 
	 * @param zrx Zoomfaktor der X-Koordinate
	 * @param zry Zoomfaktor der Y-Koordinate
	 */
	public PositionArray(double zrx, double zry) {
		_pointsX = new int[1];
		_pointsY = new int[1];
		_zrx = zrx;
		_zry = zry;
	}
	
	/**
	 * Hinzufügen einer X und Y Koordinate mittels eines <code>Position</code> Objektes.
	 * 
	 * @param position Positionsangabe hinzufügen
	 */
	public void setPosition(Position position) {
		_tmpX = new int[_pointsX.length+1];
		_tmpY = new int[_pointsY.length+1];
		for(int i = 0; i<_pointsX.length; i++) {
			_tmpX[i] = _pointsX[i];
			_tmpY[i] = _pointsY[i];
		}
		
		_tmpX[_tmpX.length-2] = (int) (position.getX()*_zrx);
		_tmpY[_tmpY.length-2] = (int) (position.getY()*_zry);
		_pointsX = _tmpX;
		_pointsY = _tmpY;
	}
	
	/**
	 * Liefert die X-Koordinaten des Polygons. Damit das Polygon ordungsgemäß geschlossen 
	 * wird, wird das erste Polygon nochmals an das Ende der Polygonliste eingefügt.
	 * 
	 * @return int[] Array mit den X-Koordinaten des Polygons 
	 */
	public int[] getPointsX() {
		
		_pointsX[_pointsX.length-1] = _pointsX[0];
		return _pointsX;
	}
	
	/**
	 * Liefert die X-Koordinate des Polygon an der vorgegebenen Stelle des Arrays.
	 * 
	 * @param position Integerwert der Position im Array.
	 * @return Rückgabe des Positionswertes der X-Koordinate
	 */
	public int getX(int position) {
		return _pointsX[position];
	}
	
	/**
	 * Liefert die Y-Koordinaten des Polygons. Damit das Polygon ordungsgemäß geschlossen 
	 * wird, wird das erste Polygon nochmals an das Ende der Polygonliste eingefügt.
	 * 
	 * @return int[] Array mit den Y-Koordinaten des Polygons 
	 */
	public int[] getPointsY() {
		
		_pointsY[_pointsY.length-1] = _pointsY[0];
		return _pointsY;
	}
	
	/**
	 * Liefert die Y-Koordinate des Polygon an der vorgegebenen Stelle des Arrays.
	 * 
	 * @param position Integerwert der Position im Array.
	 * @return Rückgabe des Positionswertes der Y-Koordinate
	 */
	public int getY(int position) {
		return _pointsY[position];
	}
	
	/**
	 * Liefert die Länge des Arrays zurück, in diesem Fall werden die Anzahl der X- und Y-
	 * Koordinaten nicht verglichen, da X und Y Koordinaten in gleicher Anzahl vorhanden sind.
	 *  
	 * @return int Länge des Arrays
	 */
	public int getLength() {
		return _pointsX.length;
	}
}
