/*
 * Created on 14.08.2004
 *
 */
package mapper.DataStrukture;

import java.text.DecimalFormat;
import java.util.Locale;

/**
 * Diese Klasse enthält alle nötigen Informationen zu Positionsangaben die im NSMapper 
 * verwendet werden.
 * 
 * @author Emanuel Eden
 *
 */
public class Position {
	
	// X-Koordinate
	private double _x;
	// Y-Koordinate
	private double _y;
	
	/**
	 * Initialisiert die Position ohne Werte. Die Darstellung der Position wird mit x=-1
	 * und y=-1 dargestellt.
	 *
	 */
	public Position() {
		_x = -1;
		_y = -1;
	}
	
	/**
	 * Initialisiert die Positionsdaten mit einem anderen Positionsobjekt. Dies ist wichtig 
	 * für die Tiefenkopie, wenn ein Node oder MovementField Objekt kopiert werden soll, ohne
	 * das eine gehashte Datenstruktur das selbe Objekt bekommnt. 
	 * 
	 * @param position Positionsdaten die Kopiert werden sollen
	 */
	public Position(Position position) {
		_x = position.getX();
		_y = position.getY();
	}
	
	/**
	 * Initialisierung der Position mit X- und Y-Koordinaten.
	 * 
	 * @param x Koordinate
	 * @param y Koordinate
	 */
	public Position(double x, double y) {
		_x = x;
		_y = y;
	}
	
	/**
	 * Liefert die X-Koordinate zurück.
	 * 
	 * @return double X-Koordinate
	 */
	public double getX() {
		return _x;
	}
	
	/**
	 * Liefert die Y-Koordinate zurück.
	 * 
	 * @return double Y-Koordinate
	 */
	public double getY() {
		return _y;
	}
	
	/**
	 * Setzt eine neue X-Koordinate
	 * 
	 * @param x double X-Koordinate
	 */
	public void setX(double x) {
		_x = x;
	}
	
	/**
	 * Setzt eine neue Y-Koordinate
	 * 
	 * @param y double Y-Koordinate
	 */
	public void setY(double y) {
		_y = y;
	}
	
	/**
	 * Vergleicht 2 Positionen miteinander
	 * 
	 * @param position Position des anderen Objektes
	 * @return <code>true</code> falls die Positionen gleich sind
	 */
	public boolean equals(Position position) {
		if(_x != position.getX()) 
			return false;
		if(_y != position.getY()) 
			return false;
		return true;
	}
	
	/**
	 * Dies toString Methode liefert die Positionsangaben in geeigneter Form zurück, damit
	 * sie im ChoiceTree mit nur 2 Nachkommastellen angezeigt werden können.
	 */
	public String toString() {
		DecimalFormat dec = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
		dec.applyPattern("######0.00");
		return "( " + dec.format(_x) +  ", " + dec.format(_y) + " )";
	}
}
