package mapper.DataStrukture;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
 * Diese Klasse erlaubt es eine spezielle Auswahl der Grafikformate für das Öffnen der 
 * Karte zu erstellen. Hierbei beinhaltet der FileFilter: png, jpeg, jpg, gif, tiff, tif 
 * Dateien anzuzeigen und zu laden.
 *   
 * @author Emanuel Eden
 *
 */
public class ImageFilter extends FileFilter {
    
	private final static String _png = "png";
    private final static String _jpeg = "jpeg";
    private final static String _jpg = "jpg";
    private final static String _gif = "gif";
    private final static String _tiff = "tiff";
    private final static String _tif = "tif";
    
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String extension = getExtension(f);
	if (extension != null) {
            if (extension.equals(_tiff) ||
                extension.equals(_tif) ||
                extension.equals(_gif) ||
                extension.equals(_jpeg) ||
                extension.equals(_jpg) ||
            	extension.equals(_png)) {
                    return true;
            } else {
                return false;
            }
    	}

        return false;
    }
    
    private static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');

        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }
    
    public String getDescription() {
        return "gif, jpg, png";
    }
}
