/*
 * Decompiled with CFR 0.152.
 */
package mapper.GUIComponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.PathLine;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.PositionArray;
import mapper.DataStrukture.ValueNew;
import mapper.DataStrukture.ValueTable;

public class PaintingArea
extends JComponent {
    protected BufferedImage _image;
    protected BufferedImage _transImage;
    private ValueTable _valueTable = new ValueTable();
    private MovementField _movementField = null;
    private Node _node = null;
    private PathLine _pline;
    private boolean _paintingAreaIsDefind = false;
    private boolean _mapInPaintingArea = false;
    private boolean _hidePictureInPaintingArea = false;
    private boolean _marked = false;
    private boolean _paintRectangle = false;
    private boolean _paintPath = false;
    private double _currentZoom = 1.0;
    private double _zoom = 1.0;
    Color blue = new Color(118, 129, 196);
    Color dblue = new Color(154, 167, 255);
    Color red = new Color(255, 0, 0);
    Color black = new Color(0, 0, 0);
    Color white = new Color(255, 255, 255);

    public PaintingArea() {
        this.setBorder(new TitledBorder("No Map specified"));
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public void setDimension(ValueNew valueNew) {
        this.setBorder(null);
        this._valueTable.setValueNew(new ValueNew(valueNew));
        this._paintingAreaIsDefind = true;
    }

    public void setImageFile(File file) {
        ValueNew valueNew = new ValueNew(this._valueTable.getValueNew());
        Position relationship = new Position();
        this.setImageToPaintingArea(file);
        this._mapInPaintingArea = true;
        this.paintComponent(this.getGraphics());
        relationship.setX((double)this._image.getWidth() / this._valueTable.getValueNew().getDimension().getX());
        relationship.setY((double)this._image.getHeight() / this._valueTable.getValueNew().getDimension().getY());
        this._valueTable.getValueNew().setRelationship(relationship);
    }

    public void zoom(double zoom) {
        this._currentZoom = zoom;
        if (this._mapInPaintingArea) {
            PaintingArea.flush(this._transImage);
            this._transImage = null;
            this._transImage = this.resize(this._image, zoom);
            this.invalidate();
        }
    }

    public void hideImage() {
        this._hidePictureInPaintingArea = !this._hidePictureInPaintingArea;
    }

    public void setMovementField(MovementField movementField) {
        this._movementField = movementField;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public void setMarked(boolean marked) {
        this._marked = marked;
    }

    public Dimension getPreferredSize() {
        if (this._paintingAreaIsDefind) {
            if (this._mapInPaintingArea) {
                return new Dimension(this._transImage.getWidth(), this._transImage.getHeight());
            }
            return new Dimension((int)(this._valueTable.getValueNew().getDimension().getX() * this.computeZRX()), (int)(this._valueTable.getValueNew().getDimension().getY() * this.computeZRY()));
        }
        return new Dimension(100, 100);
    }

    public void setValueTable(ValueTable valueTable) {
        this._valueTable = valueTable;
    }

    public Position getRelationship() {
        return this._valueTable.getValueNew().getRelationship();
    }

    public void setPath(PathLine pline) {
        this._paintPath = true;
        this._pline = pline;
    }

    public void finishPath() {
        this._paintPath = false;
        this._pline = new PathLine(null, null);
    }

    public void setRectangle(Position position1, Position position2) {
        this._paintRectangle = true;
        this._pline = new PathLine(position1, position2);
    }

    public void finishRectangle() {
        this._paintRectangle = false;
        this._pline = new PathLine(null, null);
    }

    private BufferedImage loadImage(File image) {
        try {
            BufferedImage im = ImageIO.read(image);
            System.out.println("-----> Image : Width: " + im.getWidth() + ", Height: " + im.getHeight());
            BufferedImage copy = this.resize(im, 1.0);
            PaintingArea.flush(im);
            return copy;
        }
        catch (IOException e) {
            System.out.println("Load Image error for " + image + ":\n" + e);
            return null;
        }
    }

    private BufferedImage resize(BufferedImage src, double zoom) {
        if (src == null) {
            return null;
        }
        int transparency = src.getColorModel().getTransparency();
        int width = (int)((double)src.getWidth() * zoom);
        int height = (int)((double)src.getHeight() * zoom);
        GraphicsConfiguration gc = PaintingArea.getDefaultConfiguration();
        BufferedImage dest = gc.createCompatibleImage(width, height, transparency);
        Graphics2D g2d = dest.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        AffineTransform xform = zoom == 1.0 ? null : AffineTransform.getScaleInstance(zoom, zoom);
        g2d.drawRenderedImage(src, xform);
        g2d.dispose();
        return dest;
    }

    private void setImageToPaintingArea(File file) {
        try {
            this._transImage = this._image = this.loadImage(file);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this._mapInPaintingArea = true;
    }

    private static void flush(Image image) {
        try {
            if (image != null) {
                image.flush();
            }
        }
        catch (NullPointerException e) {
            System.err.println("Error with the image:flush");
            e.printStackTrace();
        }
    }

    protected void paintComponent(Graphics g) {
        if (this._paintingAreaIsDefind) {
            this.drawPaintingArea(g);
        }
        this.drawMovementField(g);
        if (this._movementField != null && this._marked) {
            this.drawMarkedPolygon(g);
        }
        this.drawNodes(g);
        if (this._node != null && this._marked) {
            this.drawMarkedNode(g);
        }
        if (this._movementField != null && !this._marked) {
            this.drawMovementFieldCreation(g);
        }
        if (this._paintRectangle) {
            this.drawRectangle(g);
        }
        if (this._paintPath) {
            this.drawPath(g);
        }
    }

    private void drawPaintingArea(Graphics g) {
        if (this._mapInPaintingArea && !this._hidePictureInPaintingArea) {
            ((Graphics2D)g).drawRenderedImage(this._transImage, null);
        } else {
            g.setColor(this.white);
            g.fillRect(0, 0, (int)(this._valueTable.getValueNew().getDimension().getX() * this.computeZRX()), (int)(this._valueTable.getValueNew().getDimension().getY() * this.computeZRY()));
        }
    }

    private void drawPath(Graphics g) {
        g.setColor(this.black);
        g.drawLine((int)this._pline.getSource().getX(), (int)this._pline.getSource().getY(), (int)this._pline.getSink().getX(), (int)this._pline.getSink().getY());
    }

    private void drawRectangle(Graphics g) {
        g.setColor(this.black);
        g.drawLine((int)this._pline.getSource().getX(), (int)this._pline.getSource().getY(), (int)this._pline.getSource().getX(), (int)this._pline.getSink().getY());
        g.drawLine((int)this._pline.getSource().getX(), (int)this._pline.getSource().getY(), (int)this._pline.getSink().getX(), (int)this._pline.getSource().getY());
        g.drawLine((int)this._pline.getSource().getX(), (int)this._pline.getSink().getY(), (int)this._pline.getSink().getX(), (int)this._pline.getSink().getY());
        g.drawLine((int)this._pline.getSink().getX(), (int)this._pline.getSource().getY(), (int)this._pline.getSink().getX(), (int)this._pline.getSink().getY());
    }

    private void drawNodes(Graphics g) {
        Iterator iter = this._valueTable.getNodes().iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.isRandomStartPoint()) continue;
            Position position = node.getPosition();
            g.setColor(this.black);
            g.drawOval((int)(position.getX() * this.computeZRX() - 3.0), (int)(position.getY() * this.computeZRY()) - 3, 6, 6);
            g.setColor(this.blue);
            g.drawOval((int)(position.getX() * this.computeZRX() - 4.0), (int)(position.getY() * this.computeZRY()) - 4, 8, 8);
            g.setColor(this.black);
            g.drawOval((int)(position.getX() * this.computeZRX() - 5.0), (int)(position.getY() * this.computeZRY()) - 5, 10, 10);
            int key = node.getTimeScheduler().getFirstKey();
            while (key != -1) {
                Position p1 = node.getTimeScheduler().getTimeSlot(key).getStartPosition();
                Position p2 = node.getTimeScheduler().getTimeSlot(key).getStopPosition();
                g.drawLine((int)(p1.getX() * this.computeZRX()), (int)(p1.getY() * this.computeZRY()), (int)(p2.getX() * this.computeZRX()), (int)(p2.getY() * this.computeZRY()));
                key = node.getTimeScheduler().getSuccessor(key);
            }
        }
    }

    private void drawMovementField(Graphics g) {
        HashMap movementFieldList = new HashMap(this._valueTable.getMovementFieldList());
        Set set = movementFieldList.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            PositionArray points = new PositionArray(this.computeZRX(), this.computeZRY());
            Map.Entry element = iter.next();
            MovementField movementField = (MovementField)element.getValue();
            if (movementField.getStaticStatus()) {
                g.setColor(this.blue);
            } else {
                g.setColor(this.dblue);
            }
            Iterator iterator = movementField.getNodes().iterator();
            while (iterator.hasNext()) {
                points.setPosition((Position)iterator.next());
            }
            g.fillPolygon(points.getPointsX(), points.getPointsY(), points.getLength());
            int key = movementField.getTimeScheduler().getFirstKey();
            g.setColor(this.black);
            while (key != -1) {
                Position p1 = movementField.getTimeScheduler().getTimeSlot(key).getStartPosition();
                Position p2 = movementField.getTimeScheduler().getTimeSlot(key).getStopPosition();
                g.drawLine((int)(p1.getX() * this.computeZRX()), (int)(p1.getY() * this.computeZRY()), (int)(p2.getX() * this.computeZRX()), (int)(p2.getY() * this.computeZRY()));
                key = movementField.getTimeScheduler().getSuccessor(key);
            }
        }
    }

    private void drawMovementFieldCreation(Graphics g) {
        Position tmp = new Position();
        Iterator iter = this._movementField.getNodes().iterator();
        while (iter.hasNext()) {
            g.setColor(this.red);
            Position position = (Position)iter.next();
            g.drawOval((int)(position.getX() * this.computeZRX()) - 3, (int)(position.getY() * this.computeZRY()) - 3, 6, 6);
            if (tmp.getX() != -1.0 && tmp.getY() != -1.0) {
                g.setColor(this.black);
                g.drawLine((int)(tmp.getX() * this.computeZRX()), (int)(tmp.getY() * this.computeZRY()), (int)(position.getX() * this.computeZRX()), (int)(position.getY() * this.computeZRY()));
            }
            tmp = position;
        }
    }

    private void drawMarkedPolygon(Graphics g) {
        g.setColor(this.red);
        PositionArray points = new PositionArray(this.computeZRX(), this.computeZRY());
        Iterator iterator = this._movementField.getNodes().iterator();
        while (iterator.hasNext()) {
            points.setPosition((Position)iterator.next());
        }
        g.fillPolygon(points.getPointsX(), points.getPointsY(), points.getLength());
        g.setColor(this.black);
        int i = 0;
        while (i < points.getLength()) {
            g.drawOval(points.getX(i) - 3, points.getY(i) - 3, 6, 6);
            ++i;
        }
    }

    private void drawMarkedNode(Graphics g) {
        g.setColor(this.red);
        Position position = this._node.getPosition();
        g.drawOval((int)(position.getX() * this.computeZRX() - 3.0), (int)(position.getY() * this.computeZRY()) - 3, 6, 6);
        g.drawOval((int)(position.getX() * this.computeZRX() - 4.0), (int)(position.getY() * this.computeZRY()) - 4, 8, 8);
        g.drawOval((int)(position.getX() * this.computeZRX() - 5.0), (int)(position.getY() * this.computeZRY()) - 5, 10, 10);
    }

    private double computeZRX() {
        return this._currentZoom * this._valueTable.getValueNew().getRelationship().getX();
    }

    private double computeZRY() {
        return this._currentZoom * this._valueTable.getValueNew().getRelationship().getY();
    }
}

