/*
 * Decompiled with CFR 0.152.
 */
package mapper.GUIComponents;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.PathLine;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.TimeSlot;
import mapper.DataStrukture.ValueTable;
import mapper.GUIComponents.ChoiceTree;
import mapper.GUIComponents.DeclarationDialogs;
import mapper.GUIComponents.Menu;
import mapper.GUIComponents.PaintingArea;

public class GUIMain
extends JFrame
implements ActionListener,
MouseListener,
MouseMotionListener {
    private ValueTable _valueTable = new ValueTable();
    private ChoiceTree _choiceTree = new ChoiceTree();
    private Position _constantMouse = new Position(0.0, 0.0);
    private MovementField _movementField;
    private Node _node;
    private PathLine _pline;
    private Object _copyAndPaste;
    private DeclarationDialogs _dialog;
    private PaintingArea _workbench;
    private JScrollPane _jScrollPane1;
    private JScrollPane _jScrollPane2;
    private boolean _mapInWorkbench = false;
    private boolean _pictureInWorkbench = false;
    private boolean _createRectangle = false;
    private int _createMovementField = -1;
    private int _createNode = -1;
    private int _createPath = -1;
    private double _currentZoom = 1.0;

    public GUIMain() {
        super("NS-Mapper");
        this.setDefaultCloseOperation(3);
        Container cp = this.getContentPane();
        Menu menu = new Menu();
        JToolBar toolBar = new JToolBar();
        JMenuBar menuBar = new JMenuBar();
        this._workbench = new PaintingArea();
        this._jScrollPane2 = new JScrollPane(this._workbench);
        this._jScrollPane1 = new JScrollPane(this._choiceTree.getTree());
        JSplitPane splitPane = new JSplitPane(1, this._jScrollPane1, this._jScrollPane2);
        cp.add((Component)menuBar, "First");
        cp.add((Component)toolBar, "North");
        cp.add((Component)splitPane, "Center");
        this.makeMenu(menuBar, menu);
        this.makeToolBar(toolBar, menu);
    }

    private void makeMenu(JMenuBar menuBar, Menu menu) {
        int i = 0;
        while (i < menu.menuBar.length) {
            JMenu menuBarItem = new JMenu(menu.menuBar[i][0][0]);
            menuBar.add(menuBarItem);
            int j = 1;
            while (j < menu.menuBar[i].length) {
                JMenuItem menuItem = new JMenuItem(menu.menuBar[i][j][0]);
                menuItem.addActionListener(this);
                menuBarItem.add(menuItem);
                ++j;
            }
            ++i;
        }
        this.setJMenuBar(menuBar);
    }

    private void makeToolBar(JToolBar toolBar, Menu menu) {
        Class<?> c = this.getClass();
        int i = 0;
        while (i < menu.iconBar.length) {
            if (!menu.iconBar[i][0].equals("")) {
                JButton btn = new JButton(menu.getImage(i));
                btn.setActionCommand(menu.iconBar[i][1]);
                btn.setToolTipText(menu.iconBar[i][2]);
                btn.addActionListener(this);
                toolBar.add(btn);
            } else {
                toolBar.addSeparator();
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String quelle = ae.getActionCommand();
        if (!this._mapInWorkbench) {
            if (quelle.equals("New")) {
                this.menuItem_New();
            }
            if (quelle.equals("Exit")) {
                System.exit(0);
            }
            if (quelle.equals("About")) {
                this.OptionPaneDialog(4, "About", "NS-Mapper\nAutor : Emanuel Eden\nVersion 0.1");
            }
            return;
        }
        if (quelle.equals("New")) {
            this.menuItem_New();
        }
        if (quelle.equals("Exit")) {
            System.exit(0);
        }
        if (quelle.equals("Copy")) {
            this.menuItem_Copy();
        }
        if (quelle.equals("Paste")) {
            this.menuItem_Paste();
        }
        if (quelle.equals("Delete")) {
            this.menuItem_Delete();
        }
        if (quelle.equals("Node")) {
            this.menuItem_AddNode();
        }
        if (quelle.equals("Add Movementfield")) {
            this.menuItem_AddMovementField();
        }
        if (quelle.equals("Add Rectangle")) {
            this.menuItem_AddRectangle();
        }
        if (quelle.equals("Make Path")) {
            this.menuItem_MakePath();
        }
        if (quelle.equals("Load Picture")) {
            this.menuItem_LoadPicture();
        }
        if (quelle.equals("Hide Picture")) {
            this.menuItem_HidePicture();
        }
        if (quelle.equals("Zoom in")) {
            this.menuItem_ZoomIn();
        }
        if (quelle.equals("Zoom out")) {
            this.menuItem_ZoomOut();
        }
        if (quelle.equals("Cursor")) {
            this.menuItem_Cursor();
        }
        if (quelle.equals("About")) {
            this.OptionPaneDialog(4, "About", "NS-Mapper\nAutor : Emanuel Eden\nVersion 0.1");
        }
    }

    private void OptionPaneDialog(int dialogNum, String windowText, String descriptionText) {
        this._dialog = new DeclarationDialogs((JFrame)this, dialogNum, windowText, descriptionText);
        this._dialog.setVisible(true);
        this._dialog.dispose();
    }

    private void menuItem_New() {
        this.setAllValuesToDefault();
        this._dialog = new DeclarationDialogs(this, "New");
        this._dialog.setLocationRelativeTo(null);
        this._dialog.setVisible(true);
        if (!this._dialog.isCanceled()) {
            this._valueTable.setValueNew(this._dialog.getValue_New());
            this._mapInWorkbench = true;
            this._workbench.setDimension(this._dialog.getValue_New());
            this._choiceTree = new ChoiceTree(this._valueTable.getValueNew().getSzenarioName(), this._valueTable.getValueNew().getSimulationTime());
            this._choiceTree.getTree().addMouseListener(this);
            this._jScrollPane1.setViewportView(this._choiceTree.getTree());
        }
    }

    private void menuItem_Cursor() {
        if (this._createMovementField > 2) {
            this._movementField = this._valueTable.setElement(this._movementField);
            this._choiceTree.add(this._movementField);
            this._workbench.setValueTable(this._valueTable);
        }
        this._jScrollPane1.setViewportView(this._choiceTree.getTree());
        this._createRectangle = false;
        this.setMovementFieldToDefault(false);
        this.setNodesToDefault(false);
        this.setMarkedToDefault(true);
    }

    private void menuItem_Copy() {
        if (this._valueTable.isMarked() != 1) {
            this._copyAndPaste = this._valueTable.getCopy();
        }
    }

    private void menuItem_Paste() {
        if (this._copyAndPaste instanceof Node) {
            this._copyAndPaste = this._valueTable.setElement((Node)this._copyAndPaste);
            this._choiceTree.add((HashSet)this._copyAndPaste);
            this._workbench.setValueTable(this._valueTable);
            this._jScrollPane1.setViewportView(this._choiceTree.getTree());
            this._jScrollPane2.setViewportView(this._workbench);
            this.menuItem_Cursor();
        }
        if (this._copyAndPaste instanceof MovementField) {
            this._copyAndPaste = this._valueTable.setElement((MovementField)this._copyAndPaste);
            this._choiceTree.add((MovementField)this._copyAndPaste);
            this._workbench.setValueTable(this._valueTable);
            this._jScrollPane1.setViewportView(this._choiceTree.getTree());
            this._jScrollPane2.setViewportView(this._workbench);
            this.menuItem_Cursor();
        }
        this._copyAndPaste = null;
        this._valueTable.setMarkedToDefault();
    }

    private void menuItem_AddNode() {
        this.menuItem_Cursor();
        this._dialog = new DeclarationDialogs((JFrame)this, "Node", this.computeZRX(), this.computeZRY());
        this._dialog.setLocationRelativeTo(null);
        this._dialog.setValueTable(this._valueTable);
        this._dialog.setVisible(true);
        if (!this._dialog.isCanceled()) {
            HashSet _nodes = this._dialog.getNodeList();
            if (this._dialog.getSet()) {
                this._createNode = this._dialog.getNumberOfNodes();
                this._node = (Node)_nodes.iterator().next();
                this._workbench.setCursor(new Cursor(1));
                return;
            }
            _nodes = this._valueTable.setElement(_nodes);
            this._choiceTree.add(_nodes);
            this._workbench.setValueTable(this._valueTable);
            this._jScrollPane1.setViewportView(this._choiceTree.getTree());
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void menuItem_AddMovementField() {
        this.menuItem_Cursor();
        this._workbench.setCursor(new Cursor(1));
        this._createMovementField = 0;
    }

    private void menuItem_AddRectangle() {
        this.menuItem_Cursor();
        this._workbench.setCursor(new Cursor(1));
        this._createRectangle = true;
    }

    private void menuItem_MakePath() {
        if (this._valueTable.isMarked() != -1) {
            if (this._valueTable.getMarked() instanceof Node) {
                if (((Node)this._valueTable.getMarked()).getTimeScheduler().isElementsAnymore()) {
                    return;
                }
                this._pline = new PathLine(((Node)this._valueTable.getMarked()).getTimeSlotPosition(), this.computeZRX(), this.computeZRY());
            }
            if (this._valueTable.getMarked() instanceof MovementField) {
                if (((MovementField)this._valueTable.getMarked()).getTimeScheduler().isElementsAnymore()) {
                    return;
                }
                this._pline = new PathLine(((MovementField)this._valueTable.getMarked()).getTimeSlotPosition(), this.computeZRX(), this.computeZRY());
            }
            this._createPath = 0;
        }
    }

    private void menuItem_LoadPicture() {
        this._dialog = new DeclarationDialogs((JFrame)this, 5, "File Chooser");
        this._dialog.setVisible(true);
        this._dialog.dispose();
        if (!this._dialog.isCanceled()) {
            this._pictureInWorkbench = true;
            this._valueTable.getValueNew().setImageFile(this._dialog.getImageFile());
            this._workbench.setImageFile(this._dialog.getImageFile());
            this._valueTable.getValueNew().setRelationship(this._workbench.getRelationship());
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void menuItem_Delete() {
        if (this._valueTable.getKey() != null) {
            this.menuItem_Cursor();
            this._choiceTree.remove(this._valueTable.remove(this._valueTable.getKey()));
            this._workbench.setValueTable(this._valueTable);
            this._jScrollPane1.setViewportView(this._choiceTree.getTree());
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void menuItem_HidePicture() {
        if (this._pictureInWorkbench) {
            this._workbench.hideImage();
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void menuItem_ZoomIn() {
        this.zoom(0.1f);
    }

    private void menuItem_ZoomOut() {
        if (this._currentZoom > 0.5) {
            this.zoom(-0.1f);
        }
    }

    private void setAllValuesToDefault() {
        this.setNodesToDefault(false);
        this.setMovementFieldToDefault(false);
        this.setMarkedToDefault(false);
        this._mapInWorkbench = false;
        this._currentZoom = 1.0;
        this._valueTable = new ValueTable();
        this._workbench = new PaintingArea();
        this._workbench.addMouseListener(this);
        this._workbench.addMouseMotionListener(this);
        this._jScrollPane1.setViewportView(this._choiceTree.getTree());
        this._jScrollPane2.setViewportView(this._workbench);
    }

    private void setNodesToDefault(boolean viewport) {
        this._createNode = -1;
        this._createPath = -1;
        this._workbench.finishPath();
        this._workbench.setCursor(new Cursor(0));
        if (viewport) {
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void setMovementFieldToDefault(boolean viewport) {
        this._createMovementField = -1;
        this._workbench.setMovementField(null);
        this._movementField = new MovementField(this._valueTable.getValueNew().getSimulationTime());
        if (viewport) {
            this._workbench.setCursor(new Cursor(0));
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void setMarkedToDefault(boolean viewport) {
        this._workbench.setMovementField(null);
        this._workbench.setNode(null);
        this._workbench.setMarked(false);
        this._valueTable.unmark();
        this._constantMouse.setX(0.0);
        this._constantMouse.setY(0.0);
        if (viewport) {
            this._workbench.setCursor(new Cursor(0));
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    private void zoom(float size) {
        this._currentZoom += (double)size;
        this._workbench.zoom(this._currentZoom);
        this._jScrollPane2.setViewportView(this._workbench);
    }

    private double computeZRX() {
        return this._currentZoom * this._valueTable.getValueNew().getRelationship().getX();
    }

    private double computeZRY() {
        return this._currentZoom * this._valueTable.getValueNew().getRelationship().getY();
    }

    public void mousePressed(MouseEvent event) {
        if (this._createPath != -1) {
            return;
        }
        event.getSource().getClass().getName().equals("javax.swing.JTree");
        if (event.getSource().getClass().getName().equals("mapper.GUIComponents.PaintingArea")) {
            if (this._createRectangle) {
                this._valueTable.initialRectangle(new Position(event.getX(), event.getY()));
                return;
            }
            this._valueTable.identify(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()), this.computeZRX(), this.computeZRY());
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this._createPath != -1) {
            return;
        }
        event.getSource().getClass().getName().equals("javax.swing.JTree");
        if (event.getSource().getClass().getName().equals("mapper.GUIComponents.PaintingArea")) {
            if (this._createRectangle) {
                this._workbench.setRectangle(this._valueTable.getInitialRectangle(), new Position(event.getX(), event.getY()));
                this._jScrollPane2.setViewportView(this._workbench);
                return;
            }
            if (this._valueTable.isMarked() > -1) {
                if (this._valueTable.getMarked() instanceof MovementField) {
                    this._valueTable.movePolygonNode(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()));
                    this._workbench.setValueTable(this._valueTable);
                    this._jScrollPane2.setViewportView(this._workbench);
                    return;
                }
                if (this._valueTable.getMarked() instanceof Node) {
                    this._valueTable.moveNode(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()));
                    this._workbench.setValueTable(this._valueTable);
                    this._jScrollPane2.setViewportView(this._workbench);
                    return;
                }
            }
            if (this._valueTable.isMarked() == -2) {
                if (this._constantMouse.getX() == 0.0 && this._constantMouse.getY() == 0.0) {
                    this._constantMouse.setX((double)event.getX() / this.computeZRX());
                    this._constantMouse.setY((double)event.getY() / this.computeZRY());
                }
                this._valueTable.moveMovementField(new Position((double)event.getX() / this.computeZRX() - this._constantMouse.getX(), (double)event.getY() / this.computeZRY() - this._constantMouse.getY()));
                this._workbench.setValueTable(this._valueTable);
                this._jScrollPane2.setViewportView(this._workbench);
                this._constantMouse.setX((double)event.getX() / this.computeZRX());
                this._constantMouse.setY((double)event.getY() / this.computeZRY());
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this._createPath != -1) {
            return;
        }
        event.getSource().getClass().getName().equals("javax.swing.JTree");
        if (event.getSource().getClass().getName().equals("mapper.GUIComponents.PaintingArea")) {
            if (this._createRectangle) {
                this._choiceTree.add(this._valueTable.finishRectangle(new Position(event.getX(), event.getY()), this.computeZRX(), this.computeZRY()));
                this._workbench.finishRectangle();
                this._workbench.setValueTable(this._valueTable);
                this._valueTable.setMarkedToDefault();
                this.menuItem_Cursor();
                return;
            }
            if (this._valueTable.isMarked() > -1) {
                if (!(this._valueTable.getMarked() instanceof Node)) {
                    this._choiceTree.set(this._valueTable.getMarked());
                    this._jScrollPane1.setViewportView(this._choiceTree.getTree());
                    this._valueTable.unmark();
                } else {
                    this._choiceTree.set(this._valueTable.getMarked());
                    this._jScrollPane1.setViewportView(this._choiceTree.getTree());
                    this._valueTable.unmark();
                }
            }
            if (this._valueTable.isMarked() == -2) {
                this._choiceTree.set(this._valueTable.getMarked());
                this._jScrollPane1.setViewportView(this._choiceTree.getTree());
                this._valueTable.unmark();
            }
            this.setMarkedToDefault(false);
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (this._createPath != -1) {
            this.createPathFinish(event);
            return;
        }
        if (event.getSource().getClass().getName().equals("javax.swing.JTree")) {
            return;
        }
        if (event.getSource().getClass().getName().equals("mapper.GUIComponents.PaintingArea")) {
            if (this._createMovementField > -1) {
                this.paintingArea_createPolygon(event);
                return;
            }
            if (this._createNode > -1) {
                this.paintingArea_createNode(event);
                return;
            }
            if (this._createMovementField == -1 && this._createNode == -1) {
                this.paintingArea_marked(event);
                return;
            }
        }
    }

    public void mouseMoved(MouseEvent event) {
        if (this._createPath != -1) {
            this._pline.setSink(new Position(event.getX(), event.getY()), this.computeZRX(), this.computeZRY());
            this._workbench.setPath(this._pline);
            this._jScrollPane2.setViewportView(this._workbench);
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    private void paintingArea_createPolygon(MouseEvent event) {
        this._movementField.setNode(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()));
        this._workbench.setMovementField(this._movementField);
        ++this._createMovementField;
        this._jScrollPane2.setViewportView(this._workbench);
    }

    private void paintingArea_createNode(MouseEvent event) {
        Node node = new Node(this._node, this._valueTable.getValueNew().getSimulationTime());
        node.setPosition(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()));
        if (!this._valueTable.isInMovementList(node.getPosition())) {
            this._dialog = new DeclarationDialogs((JFrame)this, 0, "Error", "Error:\nThe Node has to placed on a MovementField!");
            return;
        }
        this._choiceTree.add(this._valueTable.setElement(node));
        this._workbench.setValueTable(this._valueTable);
        this._jScrollPane1.setViewportView(this._choiceTree.getTree());
        this._jScrollPane2.setViewportView(this._workbench);
        --this._createNode;
        if (this._createNode == 0) {
            this._createNode = -1;
            this._workbench.setCursor(new Cursor(0));
        }
    }

    private void paintingArea_marked(MouseEvent event) {
        this.setMarkedToDefault(false);
        if (this._valueTable.isElementAt(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()))) {
            if (this._valueTable.getMarked() instanceof Node) {
                this._workbench.setNode((Node)this._valueTable.getMarked());
                this._workbench.setMarked(true);
                this._valueTable.identify(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()), this.computeZRX(), this.computeZRY());
                this._jScrollPane2.setViewportView(this._workbench);
                return;
            }
            if (this._valueTable.getMarked() instanceof MovementField) {
                this._workbench.setMovementField((MovementField)this._valueTable.getMarked());
                this._workbench.setMarked(true);
                this._valueTable.identify(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()), this.computeZRX(), this.computeZRY());
                this._jScrollPane2.setViewportView(this._workbench);
                return;
            }
        }
        this._valueTable.setMarkedToDefault();
        this._jScrollPane2.setViewportView(this._workbench);
    }

    private void createPathFinish(MouseEvent event) {
        TimeSlot timeSlot = this._valueTable.getMarked() instanceof Node ? ((Node)this._valueTable.getMarked()).getTimeSlot() : ((MovementField)this._valueTable.getMarked()).getTimeSlot();
        timeSlot.setStopPosition(new Position((double)event.getX() / this.computeZRX(), (double)event.getY() / this.computeZRY()));
        this._dialog = new DeclarationDialogs((JFrame)this, "TimeScheduler", timeSlot);
        this._dialog.setLocationRelativeTo(null);
        this._dialog.setVisible(true);
        this._dialog.dispose();
        if (!this._dialog.isCanceled()) {
            timeSlot = this._dialog.getTimeSlot();
            if (this._valueTable.getMarked() instanceof Node) {
                if (!((Node)this._valueTable.getMarked()).getTimeScheduler().setTimeSlot(timeSlot)) {
                    this._createPath = -1;
                    return;
                }
                this._pline = new PathLine(timeSlot.getStopPosition(), this.computeZRX(), this.computeZRY());
                this._workbench.setValueTable(this._valueTable);
                this._jScrollPane2.setViewportView(this._workbench);
                if (((Node)this._valueTable.getMarked()).getTimeScheduler().isElementsAnymore()) {
                    this._createPath = -1;
                }
                return;
            }
            if (!((MovementField)this._valueTable.getMarked()).getTimeScheduler().setTimeSlot(timeSlot)) {
                this._createPath = -1;
                return;
            }
            this._pline = new PathLine(timeSlot.getStopPosition(), this.computeZRX(), this.computeZRY());
            this._workbench.setValueTable(this._valueTable);
            this._jScrollPane2.setViewportView(this._workbench);
            ((MovementField)this._valueTable.getMarked()).setStaticStatus(false);
            if (((MovementField)this._valueTable.getMarked()).getTimeScheduler().isElementsAnymore()) {
                this._createPath = -1;
            }
            return;
        }
    }
}

