/*
 * Decompiled with CFR 0.152.
 */
package mapper.GUIComponents;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mapper.DataStrukture.ImageFilter;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.TimeSlot;
import mapper.DataStrukture.ValueNew;
import mapper.DataStrukture.ValueTable;
import mapper.GUIComponents.TextFieldGenerator;

public class DeclarationDialogs
extends JDialog {
    private TextFieldGenerator[] _textField;
    private JComboBox[] _comboBox;
    private ValueTable _valueTable = new ValueTable();
    private ValueNew _valueNew = new ValueNew();
    private HashSet _nodeList = new HashSet();
    private Node _node = new Node(-1.0);
    private TimeSlot _timeSlot;
    private File _imageFile;
    private boolean _canceled = true;
    private boolean _setNodes = false;
    private int _numberOfNodes = -1;
    private double _zrx;
    private double _zry;

    public DeclarationDialogs(JFrame parent, String str) {
        super(parent, str, true);
        if (str.equals("New")) {
            this.menuItem_New();
        }
    }

    public DeclarationDialogs(JFrame parent, String str, TimeSlot timeSlot) {
        super(parent, str, true);
        if (str.equals("TimeScheduler")) {
            this._timeSlot = timeSlot;
            this.menuItem_TimeScheduler();
        }
    }

    public DeclarationDialogs(JFrame parent, String str, double zrx, double zry) {
        super(parent, str, true);
        this._zrx = zrx;
        this._zry = zry;
        if (str.equals("Node")) {
            this.menuItem_Node();
        }
    }

    public DeclarationDialogs(JFrame parent, int event, String str) {
        String WindowText = "NS-Mapper";
        this.witchContentPane(parent, event, str, WindowText);
    }

    public DeclarationDialogs(JFrame parent, int event, String str, String WindowText) {
        this.witchContentPane(parent, event, str, WindowText);
    }

    private void witchContentPane(JFrame parent, int event, String WindowText, String str) {
        switch (event) {
            case 0: {
                JOptionPane.showMessageDialog(parent, str, WindowText, 0);
                break;
            }
            case 1: {
                JOptionPane.showMessageDialog(this.getContentPane(), str, WindowText, 1);
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this.getContentPane(), str, WindowText, 2);
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.getContentPane(), str, WindowText, 3);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.getContentPane(), str, WindowText, -1);
                break;
            }
            case 5: {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new ImageFilter());
                fc.showOpenDialog(parent);
                this._imageFile = fc.getSelectedFile();
                if (this._imageFile == null) break;
                this._canceled = false;
            }
        }
    }

    private void menuItem_New() {
        this._textField = new TextFieldGenerator[4];
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel dialogDescription = new JLabel("Create a new map:");
        JLabel szenarioName = new JLabel("Szenario Name");
        JLabel xDimText1 = new JLabel("Width");
        JLabel meter1 = new JLabel("Meter");
        JLabel yDimText1 = new JLabel("Height");
        JLabel meter2 = new JLabel("Meter");
        JLabel szenarioTime1 = new JLabel("Szenario Time");
        JLabel szenarioTime2 = new JLabel("Milliseconds");
        this._textField[0] = new TextFieldGenerator("DefaultSzenario");
        this._textField[1] = new TextFieldGenerator("500");
        this._textField[2] = new TextFieldGenerator("500");
        this._textField[3] = new TextFieldGenerator("120.0");
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
        dialogDescription.setHorizontalAlignment(0);
        this.getContentPane().add((Component)dialogDescription, "North");
        jPanel2.setLayout(new GridLayout(4, 0, 1, 1));
        jPanel2.add(szenarioName);
        jPanel2.add(this._textField[0].getTextField());
        jPanel2.add(new JLabel());
        jPanel2.add(xDimText1);
        jPanel2.add(this._textField[1].getTextField());
        jPanel2.add(meter1);
        jPanel2.add(yDimText1);
        jPanel2.add(this._textField[2].getTextField());
        jPanel2.add(meter2);
        jPanel2.add(szenarioTime1);
        jPanel2.add(this._textField[3].getTextField());
        jPanel2.add(szenarioTime2);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel1.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeclarationDialogs.this._valueNew.setSzenarioName(DeclarationDialogs.this._textField[0].getText());
                DeclarationDialogs.this._valueNew.setDimension(new Position(Double.parseDouble(DeclarationDialogs.this._textField[1].getText()), Double.parseDouble(DeclarationDialogs.this._textField[2].getText())));
                DeclarationDialogs.this._valueNew.setSimulationTime(Double.parseDouble(DeclarationDialogs.this._textField[3].getText()));
                DeclarationDialogs.this._canceled = false;
                DeclarationDialogs.this.dispose();
            }
        });
        jPanel1.add(buttonOK);
        buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeclarationDialogs.this._canceled = true;
                DeclarationDialogs.this.dispose();
            }
        });
        jPanel1.add(buttonCancel);
        this.getContentPane().add((Component)jPanel1, "South");
        this.pack();
    }

    private void menuItem_Node() {
        JLabel dialogDescription = new JLabel("Creating Nodes");
        this._textField = new TextFieldGenerator[4];
        JTabbedPane jtp = new JTabbedPane();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
        dialogDescription.setHorizontalAlignment(0);
        this.getContentPane().add((Component)dialogDescription, "North");
        this.panel1_Node(panel1);
        this.panel2_Node(panel2);
        jtp.add("Node", panel1);
        jtp.add("Group of Nodes", panel2);
        this.getContentPane().add(jtp);
        panel3.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeclarationDialogs.this._numberOfNodes = Integer.parseInt(DeclarationDialogs.this._textField[2].getText());
                if (DeclarationDialogs.this._comboBox[0].getSelectedItem().equals("Declare")) {
                    boolean isInMovementField = false;
                    Position position = new Position(Double.parseDouble(DeclarationDialogs.this._textField[0].getText()) / DeclarationDialogs.this._zrx, Double.parseDouble(DeclarationDialogs.this._textField[1].getText()) / DeclarationDialogs.this._zrx);
                    DeclarationDialogs.this._node.setPosition(position);
                    if (!DeclarationDialogs.this._valueTable.isInMovementList(position)) {
                        DeclarationDialogs.this.witchContentPane(new JFrame(), 0, "Error", "Error:\nThe Node has to placed on a MovementField!");
                        return;
                    }
                }
                if (DeclarationDialogs.this._comboBox[0].getSelectedItem().equals("Random")) {
                    DeclarationDialogs.this._node.setRandomStartPoint(true);
                }
                if (DeclarationDialogs.this._comboBox[0].getSelectedItem().equals("Set")) {
                    DeclarationDialogs.this._setNodes = true;
                }
                if (DeclarationDialogs.this._comboBox[1].getSelectedItem().equals("Random")) {
                    DeclarationDialogs.this._node.setRandomMovement(true);
                }
                int i = 0;
                while (i < DeclarationDialogs.this._numberOfNodes) {
                    DeclarationDialogs.this._node = new Node(DeclarationDialogs.this._node, DeclarationDialogs.this._valueTable.getValueNew().getSimulationTime());
                    DeclarationDialogs.this._nodeList.add(DeclarationDialogs.this._node);
                    ++i;
                }
                DeclarationDialogs.this._canceled = false;
                DeclarationDialogs.this.dispose();
            }
        });
        panel3.add(buttonOK);
        buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeclarationDialogs.this._canceled = true;
                DeclarationDialogs.this.dispose();
            }
        });
        panel3.add(buttonCancel);
        this.getContentPane().add((Component)panel3, "South");
        this.pack();
    }

    public void menuItem_TimeScheduler() {
        this._textField = new TextFieldGenerator[5];
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel dialogDescription = new JLabel("Create a path:");
        JLabel startPos = new JLabel("Startposition :");
        JLabel startPosition = new JLabel("" + this._timeSlot.getStartPosition());
        JLabel stopPosX = new JLabel("Start Position x ");
        JLabel stopPosY = new JLabel("Stop  Position y ");
        JLabel startTIME = new JLabel("Start Time");
        JLabel startTIMELabel = new JLabel("" + this._timeSlot.getStartTime());
        JLabel startTime = new JLabel("Start Time");
        JLabel stopTime = new JLabel("Stop  Time");
        JLabel speed = new JLabel("Speed");
        JLabel meter1 = new JLabel("Meter");
        JLabel meter2 = new JLabel("Meter");
        JLabel meter3 = new JLabel("Meter");
        JLabel time1 = new JLabel("Seconds");
        JLabel time2 = new JLabel("Seconds");
        JLabel time3 = new JLabel("Seconds");
        JLabel speedV = new JLabel("km/h");
        this._textField[0] = new TextFieldGenerator(this.format(this._timeSlot.getStopPosition().getX()));
        this._textField[1] = new TextFieldGenerator(this.format(this._timeSlot.getStopPosition().getY()));
        this._textField[2] = new TextFieldGenerator("" + this._timeSlot.getStartTime());
        this._textField[3] = new TextFieldGenerator("" + this._timeSlot.getStopTime());
        this._textField[4] = new TextFieldGenerator("" + this._timeSlot.getSpeed());
        dialogDescription.setHorizontalAlignment(0);
        this.getContentPane().add((Component)dialogDescription, "North");
        jPanel2.setLayout(new GridLayout(7, 3, 1, 1));
        jPanel2.add(startPos);
        jPanel2.add(startPosition);
        jPanel2.add(meter1);
        jPanel2.add(stopPosX);
        jPanel2.add(this._textField[0].getTextField());
        jPanel2.add(meter2);
        jPanel2.add(stopPosY);
        jPanel2.add(this._textField[1].getTextField());
        jPanel2.add(meter3);
        jPanel2.add(startTIME);
        jPanel2.add(startTIMELabel);
        jPanel2.add(time1);
        jPanel2.add(startTime);
        jPanel2.add(this._textField[2].getTextField());
        jPanel2.add(time2);
        jPanel2.add(stopTime);
        jPanel2.add(this._textField[3].getTextField());
        jPanel2.add(time3);
        jPanel2.add(speed);
        jPanel2.add(this._textField[4].getTextField());
        jPanel2.add(speedV);
        this.getContentPane().add((Component)jPanel2, "Center");
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Cancel");
        jPanel1.setLayout(new GridLayout(1, 0, 1, 1));
        buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (Double.parseDouble(DeclarationDialogs.this._textField[4].getText()) == 0.0) {
                    DeclarationDialogs.this._timeSlot = new TimeSlot(Double.parseDouble(DeclarationDialogs.this._textField[2].getText()), Double.parseDouble(DeclarationDialogs.this._textField[3].getText()), DeclarationDialogs.this._timeSlot.getStartPosition(), new Position(Double.parseDouble(DeclarationDialogs.this._textField[0].getText()), Double.parseDouble(DeclarationDialogs.this._textField[1].getText())));
                } else {
                    DeclarationDialogs.this._timeSlot = new TimeSlot(Double.parseDouble(DeclarationDialogs.this._textField[4].getText()), DeclarationDialogs.this._timeSlot.getStartPosition(), new Position(Double.parseDouble(DeclarationDialogs.this._textField[0].getText()), Double.parseDouble(DeclarationDialogs.this._textField[1].getText())), Double.parseDouble(DeclarationDialogs.this._textField[2].getText()));
                }
                DeclarationDialogs.this._canceled = false;
                DeclarationDialogs.this.dispose();
            }
        });
        jPanel1.add(buttonOK);
        buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeclarationDialogs.this._canceled = true;
                DeclarationDialogs.this.dispose();
            }
        });
        jPanel1.add(buttonCancel);
        this.getContentPane().add((Component)jPanel1, "South");
        this.pack();
    }

    private void panel1_Node(JPanel panel) {
        this._comboBox = new JComboBox[2];
        JLabel startPoint = new JLabel("Start Point: ");
        JLabel xDimText1 = new JLabel("Width");
        JLabel meter1 = new JLabel("Meter");
        JLabel yDimText1 = new JLabel("Height");
        JLabel meter2 = new JLabel("Meter");
        JLabel movement = new JLabel("Movement");
        JLabel groupNodes = new JLabel("Number of Nodes");
        this._textField[0] = new TextFieldGenerator("50");
        this._textField[1] = new TextFieldGenerator("50");
        this._textField[2] = new TextFieldGenerator("1");
        this._comboBox[0] = new JComboBox<String>(new String[]{"Set", "Declare", "Random"});
        this._comboBox[1] = new JComboBox<String>(new String[]{"Set", "Random"});
        panel.setLayout(new GridLayout(5, 3, 1, 1));
        panel.add(startPoint);
        panel.add(this._comboBox[0]);
        this._comboBox[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (DeclarationDialogs.this._comboBox[0].getSelectedItem().equals("Declare")) {
                    DeclarationDialogs.this._textField[0].getTextField().setEditable(true);
                    DeclarationDialogs.this._textField[1].getTextField().setEditable(true);
                    return;
                }
                DeclarationDialogs.this._textField[0].getTextField().setEditable(false);
                DeclarationDialogs.this._textField[1].getTextField().setEditable(false);
            }
        });
        panel.add(new JLabel());
        panel.add(xDimText1);
        this._textField[0].getTextField().setEditable(false);
        panel.add(this._textField[0].getTextField());
        panel.add(meter1);
        panel.add(yDimText1);
        this._textField[1].getTextField().setEditable(false);
        panel.add(this._textField[1].getTextField());
        panel.add(meter2);
        panel.add(movement);
        panel.add(this._comboBox[1]);
        panel.add(new JLabel());
        panel.add(groupNodes);
        panel.add(this._textField[2].getTextField());
        panel.add(new JLabel());
    }

    private void panel2_Node(JPanel panel) {
    }

    public HashSet getNodeList() {
        return this._nodeList;
    }

    public int getNumberOfNodes() {
        return this._numberOfNodes;
    }

    public boolean getSet() {
        return this._setNodes;
    }

    public void setValueTable(ValueTable valueTable) {
        this._valueTable = valueTable;
    }

    public ValueNew getValue_New() {
        return this._valueNew;
    }

    public void setTimeSlot(TimeSlot timeSlot) {
        this._timeSlot = new TimeSlot(timeSlot);
    }

    public TimeSlot getTimeSlot() {
        return this._timeSlot;
    }

    public File getImageFile() {
        return this._imageFile;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private String format(double value) {
        DecimalFormat dec = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        dec.applyPattern("######0.00");
        return dec.format(value);
    }
}

