/*
 * Decompiled with CFR 0.152.
 */
package mapper.GUIComponents;

import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.Position;

public class ChoiceTree {
    private DefaultMutableTreeNode _treeRoot = new DefaultMutableTreeNode("Maps");
    private DefaultMutableTreeNode _treeMovementField = new DefaultMutableTreeNode("Movement Fields");
    private DefaultMutableTreeNode _treeNode = new DefaultMutableTreeNode("Nodes");
    private JTree _tree;
    private DefaultTreeModel model;

    public ChoiceTree() {
        this._treeRoot.add(this._treeMovementField);
        this._treeRoot.add(this._treeNode);
        this._tree = new JTree(this._treeRoot);
    }

    public ChoiceTree(String szenarioName, double simulationTime) {
        this._treeRoot = new DefaultMutableTreeNode(szenarioName);
        this._treeRoot.add(new DefaultMutableTreeNode("SimTime: " + simulationTime));
        this._treeRoot.add(this._treeMovementField);
        this._treeRoot.add(this._treeNode);
        this._tree = new JTree(this._treeRoot);
    }

    public JTree getTree() {
        return this._tree;
    }

    public void add(MovementField movementField) {
        DefaultMutableTreeNode movementFieldValues = new DefaultMutableTreeNode("Field(" + movementField.getName() + ")");
        DefaultMutableTreeNode movementFieldNodes = new DefaultMutableTreeNode("Dimension");
        movementFieldValues.add(new DefaultMutableTreeNode("Static: " + movementField.getStaticStatus()));
        Iterator iter = movementField.getNodes().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            movementFieldNodes.add(new DefaultMutableTreeNode((Position)element));
        }
        movementFieldValues.add(movementFieldNodes);
        this._treeMovementField.add(movementFieldValues);
        this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
    }

    public void add(HashSet nodes) {
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            DefaultMutableTreeNode nodeValues = new DefaultMutableTreeNode("Node(" + node.getName() + ")");
            nodeValues.add(new DefaultMutableTreeNode("Random Startpoint: " + node.isRandomStartPoint()));
            nodeValues.add(new DefaultMutableTreeNode("Random Movement: " + node.getRandomMovement()));
            nodeValues.add(new DefaultMutableTreeNode("Position: " + node.getPosition()));
            this._treeNode.add(nodeValues);
            this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
        }
    }

    public void remove(Object element) {
        if (element instanceof Node) {
            int i = 0;
            while (i < this._treeNode.getChildCount()) {
                TreeNode node = this._treeNode.getChildAt(i);
                if (node.toString().equals("Node(" + ((Node)element).getName() + ")")) {
                    this._treeNode.remove(i);
                    this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._treeMovementField.getChildCount()) {
                TreeNode node = this._treeMovementField.getChildAt(i);
                if (node.toString().equals("Field(" + ((MovementField)element).getName() + ")")) {
                    this._treeMovementField.remove(i);
                    this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
                }
                ++i;
            }
        }
    }

    public void set(Object element) {
        TreeNode node;
        int i;
        if (element instanceof Node) {
            i = 0;
            while (i < this._treeNode.getChildCount()) {
                node = this._treeNode.getChildAt(i);
                if (node.toString().equals("Node(" + ((Node)element).getName() + ")")) {
                    this._treeNode.remove(i);
                    HashSet<Object> nodes = new HashSet<Object>();
                    nodes.add(element);
                    this.add(nodes);
                    this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
                }
                ++i;
            }
        }
        if (element instanceof MovementField) {
            i = 0;
            while (i < this._treeMovementField.getChildCount()) {
                node = this._treeMovementField.getChildAt(i);
                if (node.toString().equals("Field(" + ((MovementField)element).getName() + ")")) {
                    this._treeMovementField.remove(i);
                    this.add((MovementField)element);
                    this._tree = new JTree(new DefaultTreeModel(this._treeRoot));
                }
                ++i;
            }
        }
    }
}

