/*
 * Decompiled with CFR 0.152.
 */
package mapper.DataStrukture;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import mapper.DataStrukture.MovementField;
import mapper.DataStrukture.Node;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.ValueNew;

public class ValueTable {
    private ValueNew _valueNew = new ValueNew();
    private HashMap _movementFieldList = new HashMap();
    private HashSet _nodeList = new HashSet();
    private MovementField _markedMovementField;
    private Node _markedNode;
    private Position _markedPolygonNode;
    private Object _markedKey;
    private int _marked = -1;
    private int _numberOfMovementFields = 0;
    private int _numberOfNodes = 0;

    public MovementField setElement(MovementField movementField) {
        movementField.setName(this._numberOfMovementFields);
        this._movementFieldList.put(new Integer(movementField.getName()), movementField);
        ++this._numberOfMovementFields;
        return movementField;
    }

    public HashSet setElement(HashSet nodeList) {
        Iterator iter = nodeList.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.setName(this._numberOfNodes);
            this._nodeList.add(node);
            ++this._numberOfNodes;
        }
        return nodeList;
    }

    public HashSet setElement(Node node) {
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(node);
        return this.setElement(nodes);
    }

    public HashSet getNodes() {
        return this._nodeList;
    }

    public HashMap getMovementFieldList() {
        return this._movementFieldList;
    }

    public void setValueNew(ValueNew valueNew) {
        this._valueNew = valueNew;
    }

    public ValueNew getValueNew() {
        return this._valueNew;
    }

    public Object getMarked() {
        if (this._markedMovementField != null) {
            return this._markedMovementField;
        }
        return this._markedNode;
    }

    public Object getKey() {
        return this._markedKey;
    }

    public Object remove(Object key) {
        if (this._markedMovementField != null) {
            this._movementFieldList.remove(key);
            return this._markedMovementField;
        }
        this._nodeList.remove(key);
        return this._markedNode;
    }

    public int isMarked() {
        return this._marked;
    }

    public void unmark() {
        this._marked = -1;
    }

    public boolean isInMovementList(Position position) {
        boolean isInMovementField = false;
        Iterator iter = this._movementFieldList.entrySet().iterator();
        while (iter.hasNext()) {
            MovementField movementField = (MovementField)iter.next().getValue();
            if (!movementField.isPointInMovementField(position)) continue;
            isInMovementField = true;
        }
        return isInMovementField;
    }

    public boolean isElementAt(Position position) {
        this._markedKey = null;
        Iterator iter = this._movementFieldList.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            Object key = me.getKey();
            MovementField marked = (MovementField)me.getValue();
            if (!marked.isPointInMovementField(position)) continue;
            this.setMarked(marked, key);
        }
        iter = this._nodeList.iterator();
        while (iter.hasNext()) {
            Map.Entry key = iter.next();
            Node marked = (Node)((Object)key);
            if (!marked.isPointInNode(position)) continue;
            this.setMarked(marked, key);
        }
        return this._markedKey != null;
    }

    public void identify(Position position, double zrx, double zry) {
        if (this._markedMovementField != null) {
            int i = 0;
            ListIterator liter = this._markedMovementField.getNodes().listIterator();
            while (liter.hasNext()) {
                Position posit = (Position)liter.next();
                if (posit.getX() - 5.0 / zrx < position.getX() && posit.getX() + 5.0 / zrx > position.getX() && posit.getY() - 5.0 / zry < position.getY() && posit.getY() + 5.0 / zry > position.getY()) {
                    this._marked = i;
                    return;
                }
                ++i;
            }
            if (this.isElementAt(position)) {
                this._marked = -2;
            }
            return;
        }
        Iterator iter = this._nodeList.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.isRandomStartPoint() || !(node.getPosition().getX() - 5.0 < position.getX()) || !(node.getPosition().getX() + 5.0 > position.getX()) || !(node.getPosition().getY() - 5.0 < position.getY()) || !(node.getPosition().getY() + 5.0 > position.getY())) continue;
            this._marked = 0;
            this.setMarked(node, (Object)node);
            return;
        }
    }

    public void movePolygonNode(Position position) {
        this._markedMovementField.getNodes().set(this._marked, position);
    }

    public boolean moveNode(Position position) {
        if (this.isInMovementList(position)) {
            this._markedNode.setPosition(position);
            return true;
        }
        return false;
    }

    public void setMarkedToDefault() {
        this._markedNode = null;
        this._markedMovementField = null;
        this._markedKey = null;
        this._marked = -1;
    }

    public void initialRectangle(Position position) {
        this._markedPolygonNode = position;
    }

    public Position getInitialRectangle() {
        return this._markedPolygonNode;
    }

    public MovementField finishRectangle(Position position, double zrx, double zry) {
        MovementField movementField = new MovementField(this.getValueNew().getSimulationTime());
        movementField.setNode(new Position(this._markedPolygonNode.getX() / zrx, this._markedPolygonNode.getY() / zry));
        movementField.setNode(new Position(this._markedPolygonNode.getX() / zrx, position.getY() / zry));
        movementField.setNode(new Position(position.getX() / zrx, position.getY() / zry));
        movementField.setNode(new Position(position.getX() / zrx, this._markedPolygonNode.getY() / zry));
        return this.setElement(movementField);
    }

    public void moveMovementField(Position position) {
        if (this._markedMovementField != null) {
            MovementField movementField = (MovementField)this._movementFieldList.get(this._markedKey);
            ListIterator<Position> liter = movementField.getNodes().listIterator();
            while (liter.hasNext()) {
                Position posit = (Position)liter.next();
                liter.set(new Position(posit.getX() + position.getX(), posit.getY() + position.getY()));
            }
        }
    }

    public Object getCopy() {
        if (this._markedMovementField != null) {
            MovementField movementField = new MovementField(this.getValueNew().getSimulationTime());
            movementField.setNodes(this._markedMovementField.getNodes());
            return movementField;
        }
        if (this._markedNode != null) {
            Node node = new Node(this._valueNew.getSimulationTime());
            node.setPosition(this._markedNode.getPosition());
            node.setRandomStartPoint(this._markedNode.getRandomMovement());
            node.setRandomMovement(this._markedNode.getRandomMovement());
            node.setTimeScheduler(this._markedNode.getTimeScheduler());
            return node;
        }
        return null;
    }

    private void setMarked(MovementField marked, Object key) {
        this._markedNode = null;
        this._markedMovementField = marked;
        this._markedKey = key;
    }

    private void setMarked(Node marked, Object key) {
        this._markedMovementField = null;
        this._markedKey = key;
        this._markedNode = marked;
    }
}

