/*
 * Decompiled with CFR 0.152.
 */
package mapper.DataStrukture;

import mapper.DataStrukture.Position;

public class TimeSlot {
    private Position _startPosition;
    private Position _stopPosition;
    private double _startTime;
    private double _stopTime;
    private double _speed;

    public TimeSlot() {
        this._startPosition = null;
        this._stopPosition = null;
        this._startTime = 0.0;
        this._stopTime = 0.0;
        this._speed = 0.0;
    }

    public TimeSlot(TimeSlot timeSlot) {
        this._startPosition = timeSlot.getStartPosition();
        this._stopPosition = timeSlot.getStopPosition();
        this._startTime = timeSlot.getStartTime();
        this._stopTime = timeSlot.getStopTime();
        this._speed = timeSlot.getSpeed();
    }

    public TimeSlot(Position startPosition) {
        this._startPosition = startPosition;
        this._stopPosition = null;
        this._startTime = 0.0;
        this._stopTime = 0.0;
        this._speed = 0.0;
    }

    public TimeSlot(Position startPosition, double startTime) {
        this._startPosition = startPosition;
        this._stopPosition = null;
        this._startTime = startTime;
        this._stopTime = startTime;
        this._speed = 0.0;
    }

    public TimeSlot(double speed, Position startPosition, Position stopPosition, double startTime) {
        this._startPosition = startPosition;
        this._stopPosition = stopPosition;
        this._startTime = startTime;
        if (speed < 0.0) {
            speed = 0.0;
        }
        this._speed = speed;
        this._stopTime = this.computeTime();
    }

    public TimeSlot(double startTime, double stopTime, Position startPosition, Position stopPosition) {
        this._startPosition = startPosition;
        this._stopPosition = stopPosition;
        this._startTime = startTime;
        if (this._startTime > stopTime) {
            stopTime = this._startTime;
        }
        this._stopTime = stopTime;
        this._speed = this.computeSpeed();
    }

    public void setStartPosition(Position startPosition) {
        this._startPosition = startPosition;
        this._speed = this.computeSpeed();
    }

    public Position getStartPosition() {
        return this._startPosition;
    }

    public void setStopPosition(Position stopPosition) {
        this._stopPosition = stopPosition;
    }

    public Position getStopPosition() {
        return this._stopPosition;
    }

    public double getStartTime() {
        return this._startTime;
    }

    public void setStartTime(double startTime) {
        this._startTime = startTime;
        this._speed = this.computeSpeed();
    }

    public void setStopTime(double stopTime) {
        this._stopTime = stopTime;
        this._speed = this.computeSpeed();
    }

    public double getStopTime() {
        return this._stopTime;
    }

    public double getSpeed() {
        return this._speed;
    }

    private boolean canCompute() {
        return this._startTime > -1.0 && (this._stopTime > -1.0 || this._speed > -1.0);
    }

    private double lineLength(Position startPosition, Position stopPosition) {
        double a = Math.abs(startPosition.getX() - stopPosition.getX());
        double b = Math.abs(startPosition.getY() - stopPosition.getY());
        return Math.sqrt(a * a + b * b);
    }

    private double computeSpeed() {
        double c = this.lineLength(this._startPosition, this._stopPosition);
        double time = this._stopTime - this._startTime;
        return c * 3.6 / time;
    }

    private double computeTime() {
        double c = this.lineLength(this._startPosition, this._stopPosition);
        return this._startTime + c * 3.6 / this._speed;
    }
}

