/*
 * Decompiled with CFR 0.152.
 */
package mapper.DataStrukture;

import java.util.ArrayList;
import mapper.DataStrukture.TimeSlot;

public class TimeScheduler {
    ArrayList _timeSlotList = null;
    int _firstElement = -1;
    int _lastElement = -1;
    double _simulationTime;
    boolean _noElementsAnymore = false;

    public TimeScheduler(double simulationTime) {
        this._simulationTime = simulationTime;
        this._timeSlotList = new ArrayList();
    }

    public double getSimTime() {
        return this._simulationTime;
    }

    public boolean setTimeSlot(TimeSlot timeSlot) {
        TimeSlot slot;
        if (this._noElementsAnymore) {
            return false;
        }
        if (this._lastElement != -1 && (slot = (TimeSlot)this._timeSlotList.get(this._lastElement)).getStopTime() > timeSlot.getStartTime()) {
            timeSlot.setStartTime(slot.getStopTime());
        }
        if (this._firstElement == -1) {
            ++this._firstElement;
        }
        if (timeSlot.getStartTime() >= this._simulationTime) {
            this._noElementsAnymore = true;
            timeSlot.setStopPosition(timeSlot.getStartPosition());
            timeSlot.setStartTime(this._simulationTime);
            timeSlot.setStopTime(this._simulationTime);
        }
        if (timeSlot.getStopTime() >= this._simulationTime) {
            this._noElementsAnymore = true;
            timeSlot.setStopPosition(timeSlot.getStartPosition());
            timeSlot.setStopTime(this._simulationTime);
        }
        this._timeSlotList.add(timeSlot);
        ++this._lastElement;
        return true;
    }

    public int getFirstKey() {
        return this._firstElement;
    }

    public TimeSlot getFirstTimeSlot() {
        return (TimeSlot)this._timeSlotList.get(this._firstElement);
    }

    public int getLastKey() {
        return this._lastElement;
    }

    public TimeSlot getLastTimeSlot() {
        return (TimeSlot)this._timeSlotList.get(this._lastElement);
    }

    public TimeSlot getTimeSlot(int key) {
        return (TimeSlot)this._timeSlotList.get(key);
    }

    public int getSuccessor(int key) {
        if (key >= this._lastElement) {
            return -1;
        }
        return key + 1;
    }

    public int Size() {
        return this._lastElement + 1;
    }

    public boolean isElementsAnymore() {
        return this._noElementsAnymore;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TimeScheduler[");
        buffer.append("_timeSlotList = ").append(this._timeSlotList);
        buffer.append(", _firstElement = ").append(this._firstElement);
        buffer.append(", _lastElement = ").append(this._lastElement);
        buffer.append(", _simulationTime = ").append(this._simulationTime);
        buffer.append(", _noElementsAnymore = ").append(this._noElementsAnymore);
        buffer.append("]");
        return buffer.toString();
    }
}

