/*
 * Decompiled with CFR 0.152.
 */
package mapper.DataStrukture;

import mapper.DataStrukture.Position;
import mapper.DataStrukture.TimeScheduler;
import mapper.DataStrukture.TimeSlot;

public class Node {
    private Position _position;
    private TimeScheduler _timeScheduler = null;
    private int _nodeNameNumber;
    private boolean _randomStartPoint;
    private boolean _randomMovement;

    public Node(double simulationTime) {
        this._position = new Position();
        this._randomStartPoint = false;
        this._randomMovement = false;
        this._timeScheduler = new TimeScheduler(simulationTime);
    }

    public Node(Node node, double simulationTime) {
        this._position = node.getPosition();
        this._timeScheduler = node.getTimeScheduler();
        this._randomStartPoint = node.isRandomStartPoint();
        this._randomMovement = node.getRandomMovement();
        this._timeScheduler = new TimeScheduler(simulationTime);
    }

    public Node(double x, double y, double simulationTime) {
        this._position = new Position(x, y);
        this._randomStartPoint = false;
        this._randomMovement = false;
        this._timeScheduler = new TimeScheduler(simulationTime);
    }

    public void setTimeScheduler(TimeScheduler timeScheduler) {
        this._timeScheduler = timeScheduler;
    }

    public TimeScheduler getTimeScheduler() {
        return this._timeScheduler;
    }

    public TimeSlot getTimeSlot() {
        if (this._timeScheduler.getLastKey() == -1) {
            return new TimeSlot(this._position);
        }
        return new TimeSlot(this._timeScheduler.getLastTimeSlot().getStopPosition(), this._timeScheduler.getLastTimeSlot().getStopTime());
    }

    public Position getTimeSlotPosition() {
        if (this._timeScheduler.getLastKey() == -1) {
            return this._position;
        }
        return this._timeScheduler.getLastTimeSlot().getStopPosition();
    }

    public void setPosition(Position position) {
        this._timeScheduler = new TimeScheduler(this._timeScheduler.getSimTime());
        this._position = position;
    }

    public Position getPosition() {
        return this._position;
    }

    public void setRandomStartPoint(boolean randomStartPoint) {
        if (randomStartPoint) {
            this._position = null;
        }
        this._randomStartPoint = randomStartPoint;
    }

    public boolean isRandomStartPoint() {
        return this._randomStartPoint;
    }

    public void setRandomMovement(boolean randomMovement) {
        this._randomMovement = randomMovement;
    }

    public boolean getRandomMovement() {
        return this._randomMovement;
    }

    public void setName(int nameNumber) {
        this._nodeNameNumber = nameNumber;
    }

    public int getName() {
        return this._nodeNameNumber;
    }

    public boolean isPointInNode(Position cursorPosition) {
        int x = (int)(cursorPosition.getX() - this._position.getX());
        int y = (int)(cursorPosition.getY() - this._position.getY());
        return x > -5 && x < 5 && y > -5 && y < 5;
    }
}

