/*
 * Decompiled with CFR 0.152.
 */
package mapper.DataStrukture;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import mapper.DataStrukture.Position;
import mapper.DataStrukture.TimeScheduler;
import mapper.DataStrukture.TimeSlot;

public class MovementField {
    static final double MAXVALUE = 1.7E308;
    static final double MINVALUE = 1.7E-308;
    private ArrayList _polygonNodes = new ArrayList();
    private TimeScheduler _timeScheduler = null;
    private int _movementFieldNameNumber;
    private boolean _isStatic = true;

    public MovementField(double simulationTime) {
        this._polygonNodes = new ArrayList();
        this._isStatic = true;
        this._timeScheduler = new TimeScheduler(simulationTime);
    }

    public MovementField(MovementField movementField) {
        this._polygonNodes = movementField.getNodes();
        this._movementFieldNameNumber = movementField.getName();
        this._isStatic = movementField.getStaticStatus();
        this._timeScheduler = movementField.getTimeScheduler();
    }

    public MovementField(ArrayList polygon, double simulationTime) {
        this._polygonNodes = new ArrayList(polygon);
        this._timeScheduler = new TimeScheduler(simulationTime);
    }

    public void setName(int nameNumber) {
        this._movementFieldNameNumber = nameNumber;
    }

    public int getName() {
        return this._movementFieldNameNumber;
    }

    public void setNodes(ArrayList polygon) {
        this._polygonNodes = new ArrayList(polygon);
    }

    public void setNode(Position node) {
        this._polygonNodes.add(node);
    }

    public ArrayList getNodes() {
        return this._polygonNodes;
    }

    public Position getPosition() {
        double xMin = 1.7E308;
        double yMin = 1.7E308;
        double xMax = 1.7E-308;
        double yMax = 1.7E-308;
        Iterator iter = this._polygonNodes.iterator();
        while (iter.hasNext()) {
            Position position = (Position)iter.next();
            if (position.getX() < xMin) {
                xMin = position.getX();
            }
            if (position.getY() < yMin) {
                yMin = position.getY();
            }
            if (position.getX() > xMax) {
                xMax = position.getX();
            }
            if (!(position.getY() > yMax)) continue;
            yMax = position.getY();
        }
        return new Position(xMin + (xMax - xMin) / 2.0, yMin + (yMax - yMin) / 2.0);
    }

    public void setStaticStatus(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public boolean getStaticStatus() {
        return this._isStatic;
    }

    public boolean isPointInMovementField(Position node) {
        return this.getPolygon().contains(node.getX(), node.getY());
    }

    public Polygon getPolygon() {
        Polygon polygon = new Polygon();
        Iterator iter = this._polygonNodes.iterator();
        while (iter.hasNext()) {
            Position node = (Position)iter.next();
            polygon.addPoint((int)node.getX(), (int)node.getY());
        }
        return polygon;
    }

    public void setTimeScheduler(TimeScheduler timeScheduler) {
        this._timeScheduler = timeScheduler;
    }

    public TimeScheduler getTimeScheduler() {
        return this._timeScheduler;
    }

    public TimeSlot getTimeSlot() {
        if (this._timeScheduler.getLastKey() == -1) {
            return new TimeSlot(this.getPosition());
        }
        return new TimeSlot(this._timeScheduler.getLastTimeSlot().getStopPosition(), this._timeScheduler.getLastTimeSlot().getStopTime());
    }

    public Position getTimeSlotPosition() {
        if (this._timeScheduler.getLastKey() == -1) {
            return this.getPosition();
        }
        return this._timeScheduler.getLastTimeSlot().getStopPosition();
    }
}

