package manager.gui;

import manager.*;
import manager.stub.*;
import java.awt.*;
import javax.swing.*;

/**
 *  \brief Class for registering monitoring instances.
 */
public class RegisterMonitoringfunction extends javax.swing.JDialog {
    
    DisplayError displayError;
    
    /** Creates new form TestDialog2 */
    public RegisterMonitoringfunction(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        displayError = new DisplayError();
    }
    public RegisterMonitoringfunction() {
        super(new javax.swing.JFrame(), true);
        initComponents();
        displayError = new DisplayError();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        selectFunctionDialog = new javax.swing.JDialog();
        registerEventComboBox = new javax.swing.JComboBox();
        registerAbortButton = new javax.swing.JButton();
        registerForwardButton = new javax.swing.JButton();
        descriptionWindowScrollPane = new javax.swing.JScrollPane();
        descriptionWindow = new javax.swing.JTextArea();
        parameterFieldScrollPane = new javax.swing.JScrollPane();
        parameterFieldPanel = new javax.swing.JPanel();
        registerBackButton = new javax.swing.JButton();
        registerOKButton = new javax.swing.JButton();

        selectFunctionDialog.getContentPane().setLayout(new java.awt.GridBagLayout());

        selectFunctionDialog.setTitle("Anmelden...");
        selectFunctionDialog.setModal(true);
        selectFunctionDialog.setResizable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        selectFunctionDialog.getContentPane().add(registerEventComboBox, gridBagConstraints);

        registerAbortButton.setText("Abbrechen");
        registerAbortButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                registerAbortButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        selectFunctionDialog.getContentPane().add(registerAbortButton, gridBagConstraints);

        registerForwardButton.setText("Weiter >");
        registerForwardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                registerForwardButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        selectFunctionDialog.getContentPane().add(registerForwardButton, gridBagConstraints);

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Parametereinstellungen (Anmelden...)");
        setResizable(false);
        descriptionWindowScrollPane.setAutoscrolls(true);
        descriptionWindowScrollPane.setMinimumSize(new java.awt.Dimension(400, 600));
        descriptionWindowScrollPane.setPreferredSize(new java.awt.Dimension(400, 300));
        descriptionWindow.setEditable(false);
        descriptionWindow.setLineWrap(true);
        descriptionWindow.setWrapStyleWord(true);
        descriptionWindow.setOpaque(false);
        descriptionWindowScrollPane.setViewportView(descriptionWindow);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(descriptionWindowScrollPane, gridBagConstraints);

        parameterFieldScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        parameterFieldScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        parameterFieldScrollPane.setPreferredSize(new java.awt.Dimension(200, 300));
        parameterFieldPanel.setLayout(new java.awt.GridBagLayout());

        parameterFieldScrollPane.setViewportView(parameterFieldPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        getContentPane().add(parameterFieldScrollPane, gridBagConstraints);

        registerBackButton.setText("< Zur\u00fcck");
        registerBackButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                registerBackButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(registerBackButton, gridBagConstraints);

        registerOKButton.setText("OK");
        registerOKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                registerOKButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(registerOKButton, gridBagConstraints);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void registerOKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_registerOKButtonActionPerformed
// TODO add your handling code here:
        register_Part3();
    }//GEN-LAST:event_registerOKButtonActionPerformed

    private void registerAbortButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_registerAbortButtonActionPerformed
// TODO add your handling code here:
        selectFunctionDialog.setVisible(false);
    }//GEN-LAST:event_registerAbortButtonActionPerformed

    private void registerForwardButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_registerForwardButtonActionPerformed
// TODO add your handling code here:
        register_Part2();
    }//GEN-LAST:event_registerForwardButtonActionPerformed

    private void registerBackButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_registerBackButtonActionPerformed
// TODO add your handling code here:
        this.setVisible(false);
    }//GEN-LAST:event_registerBackButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descriptionWindow;
    private javax.swing.JScrollPane descriptionWindowScrollPane;
    private javax.swing.JPanel parameterFieldPanel;
    private javax.swing.JScrollPane parameterFieldScrollPane;
    private javax.swing.JButton registerAbortButton;
    private javax.swing.JButton registerBackButton;
    private javax.swing.JComboBox registerEventComboBox;
    private javax.swing.JButton registerForwardButton;
    private javax.swing.JButton registerOKButton;
    private javax.swing.JDialog selectFunctionDialog;
    // End of variables declaration//GEN-END:variables

    
//**********************************************************************
//*******************   register monitor functions   *******************
//**********************************************************************
    
    /**
     *  \brief Shows Panel to enter parameters
     *
     *  This method shows a panel with number of input fields specified by
     *  a monitoring object.
     */
    private void showSubscribeParameterPanel(int quantity)
    {
        parameterFieldPanel.removeAll();
        parameterFieldPanel.setLocation(0,0);
        
        for (int i=0; i < quantity; i++)
        {
            JPanel parameterPanel = new JPanel();
            JLabel parameterLabel = new JLabel();
            JTextField parameterTextField = new JTextField();
            GridBagConstraints parameterPanelConstraints = new GridBagConstraints();

            parameterPanelConstraints.gridx = 0;
            parameterPanelConstraints.gridy = i;

            parameterLabel.setText((i + 1) + ":");
            parameterTextField.setPreferredSize(new Dimension(150,19));
            parameterPanel.add(parameterLabel);
            parameterPanel.add(parameterTextField);
            parameterFieldPanel.add(parameterPanel, parameterPanelConstraints);
        }
    }
    
    /**
     *  \brief Converts parameters 
     *
     *  This method converts the parameters entered in the parameter panel
     *  within a gui dialoge to a string array.
     */
    private String[] parameterPanelToStringArray()
    {
        int fieldsInPanel = parameterFieldPanel.getComponentCount();
        if (fieldsInPanel == 0)
        {
            return null;
        }
        else
        {
            String[] parameterList = new String[fieldsInPanel];
            
            for (int i=0; i<fieldsInPanel; i++)
            {
                JPanel parameterPanel = (JPanel) parameterFieldPanel.getComponent(i);
                JTextField parameterTextField = (JTextField) parameterPanel.getComponent(1);
                parameterList[i] = parameterTextField.getText();
            }
            return parameterList;
        }
    }
    
    /**
     *  \brief Registeres a monitoring instance (Part 1)
     *
     *  This method retrieves a list of all monitoring objects integrated
     *  in an agent connected to and shows these in a combo box.
     */
    protected void register_Part1()
    {
        try
        {
            registerEventComboBox.removeAllItems();
            String[] objects = WebserviceOperations.getMonitorObjects();

            if ((objects == null) || (objects.length == 0))
            {
                displayError.showError("Keine Monitoringobjekte gefunden.");
            }
            else
            {
                for (int i=0; i < objects.length; i++)
                    registerEventComboBox.addItem(objects[i]);
                registerEventComboBox.validate();
                if (!selectFunctionDialog.isVisible())
                {
                    selectFunctionDialog.pack();
                    selectFunctionDialog.setLocation((GuiMain.screenSize().width - selectFunctionDialog.getBounds().width)/2,
                            (GuiMain.screenSize().height - selectFunctionDialog.getBounds().height)/2);
                }
                    selectFunctionDialog.setVisible(true);
            }
        }
        catch (electric.util.WrappedException e0)
        {
            displayError.showError("Kommunikationsfehler<BR><BR>" +
                            "(" + e0.toString() + ")");
        }
    }
    
    /**
     *  \brief Registeres a monitoring instance (Part 2)
     *
     *  This method shows the dialoge for configuring the chosen monitoring
     *  instance in "register_Part1()" to enter the parameters.
     */
    private void register_Part2()
    {
        String selectedMonitoringfunction;
        String[] parameterInformation;
        int fieldsInParameterPanel;
        
        try
        {
            if (!this.isVisible())
            {
                this.pack();
                this.setLocation((GuiMain.screenSize().width - this.getBounds().width)/2,
                        (GuiMain.screenSize().height - this.getBounds().height)/2);
            }

            selectedMonitoringfunction = registerEventComboBox.getSelectedItem().toString();
            try
            {
                parameterInformation = WebserviceOperations.getParameterInformation(selectedMonitoringfunction);

                try
                { 
                    fieldsInParameterPanel = Integer.decode(parameterInformation[0]);
                    if (fieldsInParameterPanel < 0) throw new NumberFormatException();
                    showSubscribeParameterPanel(fieldsInParameterPanel);
                    descriptionWindow.setText(parameterInformation[1]);
                    descriptionWindow.setCaretPosition(0);
                    this.setVisible(true);
                }
                catch (NumberFormatException e0)
                {
                    displayError.showError("Fehler in Monitoringobjekt: Ungltige Feldanzahl " +
                            "fr Parameterliste der Monitoringfunktion \"" + 
                            selectedMonitoringfunction + "\"\n" + "(Wert: " + 
                            parameterInformation[0] + ")");
                }
            }
            catch (IServiceConfig$InvalidParameterListException e0)
            {
                displayError.showError("Fehler beim Verarbeiten der Parameterinformationen der " + 
                        "Monitoringfunktion \"" + selectedMonitoringfunction + "\"\n" + 
                        "(Parameterliste ist ungltig)");
            }
        }
        catch (electric.util.WrappedException e0)
        {
            displayError.showError("Kommunikationsfehler<BR><BR>" +
                            "(" + e0.toString() + ")");
        }
    }
    
    /**
     *  \brief Registeres a monitoring instance (Part 3)
     *
     *  This method configures a new monitoring instance with the entered
     *  parameters and hides all dialoge boxes used for configuring.
     */
    private void register_Part3()
    {
        String selectedMonitorfunction;
        String[] parameterlist;
        int handle;

        try
        {
            selectedMonitorfunction = registerEventComboBox.getSelectedItem().toString();
            parameterlist = parameterPanelToStringArray();
            try
            {
                handle = WebserviceOperations.subscribeMonitoringFunction(selectedMonitorfunction, parameterlist);
                this.setVisible(false);
                selectFunctionDialog.setVisible(false);
            }
            catch (IServiceConfig$InvalidGuidException e0)
            {
                displayError.showError(String.valueOf("GUID des Managers ist ungltig"));
            }
            catch (IServiceConfig$NoFreeEventHandlesAvailableException e0)
            {
                displayError.showError(String.valueOf("Keine Handles mehr auf dem " +
                            "Agenten verfgbar"));
            }
            catch (IServiceConfig$MaxRegisteredManagersReachedException e0)
            {
                displayError.showError(String.valueOf("Die maximale Anzahl registrierter " +
                        "Manager an dem Agenten\nist erreicht. Anmeldung abgelehnt"));
            }    
            catch (IServiceConfig$InvalidParameterListException e0)
            {
                displayError.showError(String.valueOf("Parameter ungltig"));
            }
            catch (IServiceConfig$UnknownMonitoringfunctionException e0)
            {
                displayError.showError(String.valueOf("Unbekannte Monitoringfunktion"));
            }
            catch (IServiceConfig$ErrorInMonitoringfunctionException e0)
            {
                displayError.showError(String.valueOf("Fehler im Monitorobjekt auf dem Agenten"));
            }
            catch (IServiceConfig$CallbackInterfaceBindErrorException e0)
            {
                displayError.showError(String.valueOf("Agent konnte keine Verbindung zur " +
                        "zur Benachrichtigungs-\nschnittstelle des Agenten aufbauen"));
            }
            catch (IServiceConfig$UnknownErrorException e0)
            {
                displayError.showError(String.valueOf("** Unbekannter Fehler **"));
            }
        }
        catch (electric.util.WrappedException e0)
        {
            displayError.showError("Kommunikationsfehler<BR><BR>" +
                            "(" + e0.toString() + ")");
        }
    }
}
