/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.GraphSelectionListener;
import com.borland.jbcl.model.GraphSubfocusListener;
import com.borland.jbcl.model.GraphViewManager;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.SingleGraphSelection;
import com.borland.jbcl.model.WritableGraphModel;
import com.borland.jbcl.model.WritableGraphSelection;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.ExpandingTextItemEditor;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.GraphView;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.TreeCore;
import com.borland.jbcl.view.TreeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TreeView
extends JScrollPane
implements GraphView,
Serializable {
    public static final int STYLE_PLUSES = 1;
    public static final int STYLE_ARROWS = 2;
    private TreeCore core = new TreeCore(this);

    public TreeView() {
        super.setDoubleBuffered(true);
        this.getViewport().setView(this.core);
        this.getHorizontalScrollBar().setUnitIncrement(16);
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
        this.setSelection(this.createDefaultSelection());
        super.setBackground(UIManager.getColor("Tree.background"));
        super.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        if (BeanPanel.is1dot3) {
            SwingUtilities.replaceUIActionMap(this, null);
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tree.background"));
        super.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
    }

    protected GraphModel createDefaultModel() {
        return new BasicTreeContainer();
    }

    protected GraphViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter())), new ExpandingTextItemEditor());
    }

    protected WritableGraphSelection createDefaultSelection() {
        return new SingleGraphSelection();
    }

    public void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            this.core.repaintNodes();
        }
    }

    public Component getCoreComponent() {
        return this.core;
    }

    public void refresh() {
        this.core.refresh();
    }

    public void setModel(GraphModel model) {
        this.core.setModel(model);
    }

    public GraphModel getModel() {
        return this.core.getModel();
    }

    public WritableGraphModel getWriteModel() {
        return this.core.getWriteModel();
    }

    public void setViewManager(GraphViewManager viewManager) {
        this.core.setViewManager(viewManager);
    }

    public GraphViewManager getViewManager() {
        return this.core.getViewManager();
    }

    public void setReadOnly(boolean readOnly) {
        this.core.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.core.isReadOnly();
    }

    public void setSelection(WritableGraphSelection selection) {
        this.core.setSelection(selection);
    }

    public WritableGraphSelection getSelection() {
        return this.core.getSelection();
    }

    public void setShowFocus(boolean show) {
        this.core.setShowFocus(show);
    }

    public boolean isShowFocus() {
        return this.core.isShowFocus();
    }

    public void setShowRollover(boolean showRollover) {
        this.core.setShowRollover(showRollover);
    }

    public boolean isShowRollover() {
        return this.core.isShowRollover();
    }

    public void setDataToolTip(boolean dataToolTip) {
        this.core.setDataToolTip(dataToolTip);
    }

    public boolean isDataToolTip() {
        return this.core.isDataToolTip();
    }

    public void setToolTipText(String text) {
        this.core.setToolTipText(text);
    }

    public String getToolTipText() {
        return this.core.getToolTipText();
    }

    public void setSubfocus(GraphLocation subfocus) {
        this.core.setSubfocus(subfocus);
    }

    public GraphLocation getSubfocus() {
        return this.core.getSubfocus();
    }

    public void setDragSubfocus(boolean drag) {
        this.core.setDragSubfocus(drag);
    }

    public boolean isDragSubfocus() {
        return this.core.isDragSubfocus();
    }

    public void setPostOnEndEdit(boolean post) {
        this.core.setPostOnEndEdit(post);
    }

    public boolean isPostOnEndEdit() {
        return this.core.isPostOnEndEdit();
    }

    public void setSnapOrigin(boolean snapOrigin) {
        this.core.setSnapOrigin(snapOrigin);
    }

    public boolean isSnapOrigin() {
        return this.core.isSnapOrigin();
    }

    public void setHSnap(boolean hSnap) {
        this.core.setHSnap(hSnap);
    }

    public boolean isHSnap() {
        return this.core.isHSnap();
    }

    public void setEditInPlace(boolean editInPlace) {
        this.core.setEditInPlace(editInPlace);
    }

    public boolean isEditInPlace() {
        return this.core.isEditInPlace();
    }

    public void setAutoEdit(boolean autoEdit) {
        this.core.setAutoEdit(autoEdit);
    }

    public boolean isAutoEdit() {
        return this.core.isAutoEdit();
    }

    public void setGrowEditor(boolean growEditor) {
        this.core.setGrowEditor(growEditor);
    }

    public boolean isGrowEditor() {
        return this.core.isGrowEditor();
    }

    public boolean isEditing() {
        return this.core.isEditing();
    }

    public ItemEditor getEditor() {
        return this.core.getEditor();
    }

    public void setBatchMode(boolean batchMode) {
        this.core.setBatchMode(batchMode);
    }

    public boolean isBatchMode() {
        return this.core.isBatchMode();
    }

    public void setOpaque(boolean opaque) {
        if (this.core != null) {
            this.core.setOpaque(opaque);
        }
    }

    public boolean isOpaque() {
        return this.core.isOpaque();
    }

    public void setTexture(Image texture) {
        this.core.setTexture(texture);
    }

    public Image getTexture() {
        return this.core.getTexture();
    }

    public void setShowRoot(boolean show) {
        this.core.setShowRoot(show);
    }

    public boolean isShowRoot() {
        return this.core.isShowRoot();
    }

    public void setExpandByDefault(boolean expand) {
        this.core.setExpandByDefault(expand);
    }

    public boolean isExpandByDefault() {
        return this.core.isExpandByDefault();
    }

    public void setStyle(int style) {
        this.core.setStyle(style);
    }

    public int getStyle() {
        return this.core.getStyle();
    }

    public void setAlignment(int alignment) {
        this.core.setAlignment(alignment);
    }

    public int getAlignment() {
        return this.core.getAlignment();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.core != null) {
            this.core.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.core != null) {
            this.core.setForeground(color);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.core != null) {
            this.core.setFont(font);
        }
    }

    public void setItemMargins(Insets margins) {
        this.core.setItemMargins(margins);
    }

    public Insets getItemMargins() {
        return this.core.getItemMargins();
    }

    public void setLeftMargin(int leftMargin) {
        this.core.setLeftMargin(leftMargin);
    }

    public int getLeftMargin() {
        return this.core.getLeftMargin();
    }

    public void setTopMargin(int topMargin) {
        this.core.setTopMargin(topMargin);
    }

    public int getTopMargin() {
        return this.core.getTopMargin();
    }

    public void setBoxSize(Dimension boxSize) {
        this.core.setBoxSize(boxSize);
    }

    public Dimension getBoxSize() {
        return this.core.getBoxSize();
    }

    public void setVgap(int vgap) {
        this.core.setVgap(vgap);
    }

    public int getVgap() {
        return this.core.getVgap();
    }

    public void setHIndent(int hIndent) {
        this.core.setHIndent(hIndent);
    }

    public int getHIndent() {
        return this.core.getHIndent();
    }

    public void setItemOffset(int itemOffset) {
        this.core.setItemOffset(itemOffset);
    }

    public int getItemOffset() {
        return this.core.getItemOffset();
    }

    public Rectangle getNodeRect(GraphLocation node) {
        return this.core.getNodeRect(node);
    }

    public void startEdit(GraphLocation node) {
        this.core.startEdit(node);
    }

    public void endEdit() throws Exception {
        this.core.endEdit();
    }

    public void endEdit(boolean post) throws Exception {
        this.core.endEdit(post);
    }

    public void safeEndEdit() {
        this.core.safeEndEdit();
    }

    public void safeEndEdit(boolean post) {
        this.core.safeEndEdit(post);
    }

    public void requestFocus() {
        this.core.requestFocus();
    }

    public boolean hasFocus() {
        return this.core.hasFocus();
    }

    public boolean isExpanded(GraphLocation location) {
        return this.core.isExpanded(location);
    }

    public void expand(GraphLocation location) {
        this.core.expand(location);
    }

    public void collapse(GraphLocation location) {
        this.core.collapse(location);
    }

    public void toggleExpanded(GraphLocation location) {
        this.core.toggleExpanded(location);
    }

    public void expandAll(GraphLocation location) {
        this.core.expandAll(location);
    }

    public void collapseAll(GraphLocation location) {
        this.core.collapseAll(location);
    }

    public void repaintNode(GraphLocation location) {
        this.core.repaintNode(location);
    }

    public void repaintNodes() {
        this.core.repaintNodes();
    }

    public GraphLocation hitTest(int xPos, int yPos) {
        return this.core.hitTest(xPos, yPos);
    }

    public void checkParentWindow() {
        this.core.checkParentWindow();
    }

    public void addModelListener(GraphModelListener listener) {
        this.core.addModelListener(listener);
    }

    public void removeModelListener(GraphModelListener listener) {
        this.core.removeModelListener(listener);
    }

    public void addSelectionListener(GraphSelectionListener listener) {
        this.core.addSelectionListener(listener);
    }

    public void removeSelectionListener(GraphSelectionListener listener) {
        this.core.removeSelectionListener(listener);
    }

    public void addSubfocusListener(GraphSubfocusListener l) {
        this.core.addSubfocusListener(l);
    }

    public void removeSubfocusListener(GraphSubfocusListener l) {
        this.core.removeSubfocusListener(l);
    }

    public void addTreeListener(TreeListener l) {
        this.core.addTreeListener(l);
    }

    public void removeTreeListener(TreeListener l) {
        this.core.removeTreeListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.core.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.core.removeActionListener(l);
    }

    public void addFocusListener(FocusListener l) {
        if (this.core != null) {
            this.core.addFocusListener(l);
        } else {
            super.addFocusListener(l);
        }
    }

    public void removeFocusListener(FocusListener l) {
        this.core.removeFocusListener(l);
    }

    public void addKeyListener(KeyListener l) {
        this.core.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.core.removeKeyListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.core.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.core.removeMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.core.addMouseMotionListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.core.removeMouseMotionListener(l);
    }

    public void addCustomItemListener(CustomItemListener l) {
        this.core.addCustomItemListener(l);
    }

    public void removeCustomItemListener(CustomItemListener l) {
        this.core.removeCustomItemListener(l);
    }

    public void setScrollPosition(int x, int y) {
        this.getViewport().setViewPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        this.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.getViewport().getViewPosition();
    }

    public Dimension getViewportSize() {
        return this.getViewport().getExtentSize();
    }

    public void setDoubleBuffer(boolean buffer) {
        this.setDoubleBuffered(buffer);
    }

    public boolean isDoubleBuffer() {
        return this.isDoubleBuffered();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.core.setEnabled(enabled);
        this.getHorizontalScrollBar().setEnabled(enabled);
        this.getVerticalScrollBar().setEnabled(enabled);
        this.core.repaint(100L);
    }

    public Dimension getPreferredSize() {
        Dimension ps = this.core.getPreferredSize();
        if (ps.width < 100) {
            ps.width = 100;
        }
        if (ps.height < 100) {
            ps.height = 100;
        }
        Insets in = this.getInsets();
        ps.width += in.left + in.right;
        ps.height += in.top + in.bottom;
        return ps;
    }

    public Dimension getMinimumSize() {
        JScrollBar vsb;
        JScrollBar hsb;
        Component rhv;
        Component chv;
        Dimension cms = this.core.getMinimumSize();
        if (this.getColumnHeader() != null && (chv = this.getColumnHeader().getView()) != null && chv.isVisible()) {
            cms.height += chv.getSize().height;
        }
        if (this.getRowHeader() != null && (rhv = this.getRowHeader().getView()) != null && rhv.isVisible()) {
            cms.width += rhv.getSize().width;
        }
        if ((hsb = this.getHorizontalScrollBar()) != null && hsb.isVisible()) {
            cms.height += hsb.getSize().height;
        }
        if ((vsb = this.getVerticalScrollBar()) != null && vsb.isVisible()) {
            cms.width += vsb.getSize().width;
        }
        return cms;
    }
}

