/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.CompositeItemPainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class CompositeItemEditor
implements ToggleItemEditor,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient ItemEditor editor1;
    private transient ItemEditor editor2;
    private transient ItemEditSite site;
    private transient Object data;
    private CompositeItemPainter compositePainter;
    private int activeEditor = 0;
    private int defaultEditor;
    private transient ItemEditor currentEditor;
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();

    public CompositeItemEditor(CompositeItemPainter compositePainter, ItemEditor firstEditor, ItemEditor secondEditor, int defaultEditor) {
        this(compositePainter, firstEditor, secondEditor);
        this.defaultEditor = defaultEditor;
    }

    public CompositeItemEditor(CompositeItemPainter compositePainter, ItemEditor firstEditor, ItemEditor secondEditor) {
        this.compositePainter = compositePainter;
        this.editor1 = firstEditor;
        this.editor2 = secondEditor;
        if (this.editor1 != null) {
            this.editor1.addKeyListener(this.keyMulticaster);
        }
        if (this.editor2 != null) {
            this.editor2.addKeyListener(this.keyMulticaster);
        }
        if (this.editor1 != null) {
            this.defaultEditor = 1;
        } else if (this.editor2 != null) {
            this.defaultEditor = 2;
        }
    }

    public CompositeItemEditor(CompositeItemPainter compositePainter) {
        this(compositePainter, null, null);
    }

    public CompositeItemEditor() {
    }

    public void setCompositeItemPainter(CompositeItemPainter compositePainter) {
        this.compositePainter = compositePainter;
    }

    public CompositeItemPainter getCompositeItemPainter() {
        return this.compositePainter;
    }

    public void setEditor1(ItemEditor firstEditor) {
        this.editor1 = firstEditor;
    }

    public ItemEditor getEditor1() {
        return this.editor1;
    }

    public void setEditor2(ItemEditor secondEditor) {
        this.editor2 = secondEditor;
    }

    public ItemEditor getEditor2() {
        return this.editor2;
    }

    public int getDefaultEditor() {
        return this.defaultEditor;
    }

    public void setDefaultEditor(int defaultEditor) {
        if (defaultEditor <= 0 || defaultEditor > 2) {
            throw new IllegalArgumentException();
        }
        this.defaultEditor = defaultEditor;
    }

    public Object getValue() {
        if (this.activeEditor == 1 && this.editor1 != null) {
            return this.editor1.getValue();
        }
        if (this.activeEditor == 2 && this.editor2 != null) {
            return this.editor2.getValue();
        }
        return null;
    }

    public Component getComponent() {
        if (this.currentEditor != null) {
            return this.currentEditor.getComponent();
        }
        if (this.editor1 != null && this.editor2 != null) {
            return null;
        }
        if (this.activeEditor == 1 && this.editor1 != null) {
            return this.editor1.getComponent();
        }
        if (this.activeEditor == 2 && this.editor2 != null) {
            return this.editor2.getComponent();
        }
        if (this.defaultEditor == 1 && this.editor1 != null) {
            return this.editor1.getComponent();
        }
        if (this.defaultEditor == 2 && this.editor2 != null) {
            return this.editor2.getComponent();
        }
        return null;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        this.data = data;
        this.site = editSite;
        Rectangle rect1 = new Rectangle();
        Rectangle rect2 = new Rectangle();
        this.compositePainter.calculateRects(data, editSite.getSiteGraphics(), bounds, 0, editSite, rect1, rect2);
        Point click = editSite.getEditClickPoint();
        int hitEditor = this.hitTest(click, rect1, rect2);
        if (hitEditor == 0) {
            hitEditor = this.editor1 != null ? 1 : 2;
        }
        this.activeEditor = hitEditor;
        this.currentEditor = null;
        Rectangle currentRect = null;
        if (this.activeEditor == 1 && this.editor1 != null) {
            this.currentEditor = this.editor1;
            currentRect = rect1;
        } else if (this.activeEditor == 2 && this.editor2 != null) {
            this.currentEditor = this.editor2;
            currentRect = rect2;
        } else if (this.defaultEditor == 1 && this.editor1 != null) {
            this.currentEditor = this.editor1;
            currentRect = rect1;
        } else if (this.defaultEditor == 2 && this.editor2 != null) {
            this.currentEditor = this.editor2;
            currentRect = rect2;
        }
        if (this.editor1 != null && this.editor2 != null && this.currentEditor.getComponent() != null) {
            this.currentEditor.getComponent().setVisible(false);
            try {
                ((Container)editSite.getSiteComponent()).add(this.currentEditor.getComponent());
            }
            catch (ClassCastException e2) {
                editSite.getSiteComponent().getParent().add(this.currentEditor.getComponent());
            }
        }
        this.currentEditor.startEdit(data, currentRect, editSite);
    }

    public void changeBounds(Rectangle bounds) {
        Rectangle rect1 = new Rectangle();
        Rectangle rect2 = new Rectangle();
        if (this.site != null) {
            this.compositePainter.calculateRects(this.data, this.site.getSiteGraphics(), bounds, 0, this.site, rect1, rect2);
        } else {
            rect1 = rect2 = bounds;
        }
        if (this.activeEditor == 1 && this.editor1 != null) {
            this.editor1.changeBounds(rect1);
        } else if (this.activeEditor == 2 && this.editor2 != null) {
            this.editor2.changeBounds(rect2);
        }
    }

    public boolean canPost() {
        if (this.activeEditor == 1 && this.editor1 != null) {
            return this.editor1.canPost();
        }
        if (this.activeEditor == 2 && this.editor2 != null) {
            return this.editor2.canPost();
        }
        return false;
    }

    public void endEdit(boolean posted) {
        if (this.activeEditor == 1 && this.editor1 != null) {
            this.editor1.endEdit(posted);
        } else if (this.activeEditor == 2 && this.editor2 != null) {
            this.editor2.endEdit(posted);
        }
        this.currentEditor = null;
        this.activeEditor = 0;
        this.data = null;
    }

    public boolean isToggle(Object data, Rectangle rect, ItemEditSite editSite) {
        if (this.editor1 instanceof ToggleItemEditor || this.editor2 instanceof ToggleItemEditor) {
            this.data = data;
            this.site = editSite;
            Rectangle rect1 = new Rectangle();
            Rectangle rect2 = new Rectangle();
            this.compositePainter.calculateRects(data, editSite.getSiteGraphics(), rect, 0, editSite, rect1, rect2);
            Point click = editSite.getEditClickPoint();
            int hit = this.hitTest(click, rect1, rect2);
            if (hit == 1 && this.editor1 instanceof ToggleItemEditor && ((ToggleItemEditor)this.editor1).isToggle(data, rect1, this.site)) {
                return true;
            }
            if (hit == 2 && this.editor2 instanceof ToggleItemEditor && ((ToggleItemEditor)this.editor2).isToggle(data, rect2, this.site)) {
                return true;
            }
        }
        return false;
    }

    public void addKeyListener(KeyListener l) {
        this.keyMulticaster.add(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyMulticaster.remove(l);
    }

    public int hitTest(Point clickPoint, Rectangle rect1, Rectangle rect2) {
        if (clickPoint != null && rect1 != null && rect2 != null) {
            return rect1.contains(clickPoint) ? 1 : (rect2.contains(clickPoint) ? 2 : 0);
        }
        return this.defaultEditor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, ItemEditor> hash = new Hashtable<String, ItemEditor>(2);
        if (this.editor1 instanceof Serializable) {
            hash.put("1", this.editor1);
        }
        if (this.editor2 instanceof Serializable) {
            hash.put("2", this.editor2);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("1");
        if (data instanceof ItemEditor) {
            this.editor1 = (ItemEditor)data;
        }
        if ((data = hash.get("2")) instanceof ItemEditor) {
            this.editor2 = (ItemEditor)data;
        }
    }
}

