/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.sql.monitor;

import com.borland.jbcl.sql.monitor.Res;
import com.borland.jbcl.sql.monitor.TextAreaStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MonitorPanel
extends JPanel
implements ActionListener,
ItemListener {
    public final int hlpMonitorPanel = 0;
    public final int hlpSourceDialog = 1;
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JTextArea textArea = new JTextArea();
    protected JScrollPane scrollPane = new JScrollPane();
    protected JButton clearButton = new JButton(Res._Clear);
    protected JButton saveButton = new JButton(Res._Save);
    protected JCheckBox enableOutputCheckbox = new JCheckBox(Res._Enable);
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JPanel outerButtonPanel = new JPanel();
    protected TextAreaStream textAreaStream = new TextAreaStream(this.textArea);

    public MonitorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.scrollPane.setPreferredSize(new Dimension(100, 250));
        this.clearButton.setMnemonic(Res._ClearMnemonic.charAt(0));
        this.saveButton.setMnemonic(Res._SaveMnemonic.charAt(0));
        this.enableOutputCheckbox.setMnemonic(Res._EnableMnemonic.charAt(0));
        this.setLayout(this.borderLayout1);
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.buttonPanel.add((Component)this.enableOutputCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.saveButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.clearButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.saveButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.enableOutputCheckbox.setSelected(true);
        this.enableOutputCheckbox.addItemListener(this);
        this.textAreaStream.setEnabled(true);
        this.textArea.setEditable(false);
        this.scrollPane.getViewport().add(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    public void setOutputEnabled(boolean outputEnabled) {
        this.textAreaStream.setEnabled(outputEnabled);
    }

    public boolean isOutputEnabled() {
        return this.textAreaStream.isEnabled();
    }

    public void setMaxLogSize(int length) {
        this.textAreaStream.setMaxLength(length);
    }

    public int getMaxLogSize() {
        return this.textAreaStream.getMaxLength();
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource() == this.enableOutputCheckbox) {
            this.textAreaStream.setEnabled(this.enableOutputCheckbox.isSelected());
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.saveButton) {
            this.saveToFile();
        } else if (e2.getSource() == this.clearButton) {
            if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                this.textArea.setText("");
            } else {
                this.textArea.replaceRange("", this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
            }
            this.textAreaStream.resetLength();
        }
    }

    private void saveToFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int val = fileChooser.showSaveDialog(this);
        if (val == 0) {
            try {
                File file = new File(fileChooser.getSelectedFile().toString());
                if (file != null) {
                    PrintWriter stream = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 1024));
                    if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                        stream.println(this.textArea.getText());
                    } else {
                        stream.println(this.textArea.getSelectedText());
                    }
                    stream.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

