/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.ModelEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class MatrixModelEvent
extends ModelEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    public static final int CONTENT_CHANGED = 1;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int ITEM_CHANGED = 17;
    public static final int ITEM_TOUCHED = 33;
    public static final int ROW_CHANGED = 49;
    public static final int COLUMN_CHANGED = 65;
    public static final int ROW_ADDED = 18;
    public static final int ROW_REMOVED = 34;
    public static final int COLUMN_ADDED = 50;
    public static final int COLUMN_REMOVED = 66;
    private transient MatrixModel model;
    private MatrixLocation location;
    private int change;

    public MatrixModelEvent(MatrixModel model, int change) {
        super(model, change);
        this.model = model;
        this.change = change;
    }

    public MatrixModelEvent(MatrixModel model, int change, MatrixLocation location) {
        this(model, change);
        this.location = location;
    }

    public MatrixModel getModel() {
        return this.model;
    }

    public int getChange() {
        return this.change;
    }

    public MatrixLocation getLocation() {
        return this.location;
    }

    public void dispatch(EventListener listener) {
        switch (this.getID()) {
            case 1: {
                ((MatrixModelListener)listener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((MatrixModelListener)listener).modelStructureChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        String changeString;
        switch (this.change) {
            case 1: {
                changeString = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                changeString = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                changeString = "ITEM_CHANGED";
                break;
            }
            case 33: {
                changeString = "ITEM_TOUCHED";
                break;
            }
            case 49: {
                changeString = "ROW_CHANGED";
                break;
            }
            case 65: {
                changeString = "COLUMN_CHANGED";
                break;
            }
            case 18: {
                changeString = "ROW_ADDED";
                break;
            }
            case 34: {
                changeString = "ROW_REMOVED";
                break;
            }
            case 50: {
                changeString = "COLUMN_ADDED";
                break;
            }
            case 66: {
                changeString = "COLUMN_REMOVED";
                break;
            }
            default: {
                changeString = "<INVALID>";
            }
        }
        return super.paramString() + ",model=" + this.model + ",change=" + changeString + ",location=" + this.location;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof MatrixModel) {
            this.model = (MatrixModel)data;
        }
    }
}

