/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.LinkedTreeIterator;
import com.borland.jbcl.model.Res;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;

public class LinkedTreeNode
implements GraphLocation,
Serializable {
    protected LinkedTreeNode parent;
    protected LinkedTreeNode nextSibling;
    protected LinkedTreeNode firstChild;
    protected int childCount;

    public LinkedTreeNode() {
    }

    public LinkedTreeNode(LinkedTreeNode parent) {
        this.parent = parent;
    }

    public GraphLocation getParent() {
        return this.parent;
    }

    public int hasChildren() {
        return this.firstChild != null ? 1 : 0;
    }

    public GraphLocation[] getChildren() {
        GraphLocation[] children = new GraphLocation[this.childCount];
        int i2 = 0;
        Enumeration enumerator = this.getChildIterator();
        while (enumerator.hasMoreElements()) {
            if (i2 >= children.length) {
                this.childCount = i2 + 1;
                GraphLocation[] c2 = new GraphLocation[this.childCount];
                System.arraycopy(children, 0, c2, 0, this.childCount - 1);
                children = c2;
            }
            children[i2++] = (GraphLocation)enumerator.nextElement();
        }
        return children;
    }

    public LinkedTreeNode getFirstChild() {
        return this.firstChild;
    }

    public Enumeration getChildIterator() {
        return new LinkedTreeIterator(this.firstChild);
    }

    public LinkedTreeNode getNextSibling() {
        return this.nextSibling;
    }

    public void appendChild(LinkedTreeNode newChild) {
        this.doAddChild(newChild, null);
    }

    public void insertChild(LinkedTreeNode newChild) {
        this.doAddChild(newChild, this.firstChild);
    }

    public void insertChild(LinkedTreeNode newChild, LinkedTreeNode aheadOf) {
        this.doAddChild(newChild, aheadOf);
    }

    protected void doAddChild(LinkedTreeNode newChild, LinkedTreeNode aheadOf) {
        LinkedTreeNode newChildTail = newChild;
        while (true) {
            if (newChildTail.parent == null) {
                newChildTail.setParent(this);
                ++this.childCount;
            } else if (newChildTail.parent != this) {
                throw new IllegalArgumentException(MessageFormat.format(Res._CantAdd, String.valueOf(newChildTail), String.valueOf(this), String.valueOf(newChildTail.parent)));
            }
            if (newChildTail.nextSibling == null) break;
            newChildTail = newChildTail.nextSibling;
        }
        if (this.firstChild != null && this.firstChild != aheadOf) {
            LinkedTreeNode c2 = this.firstChild;
            while (true) {
                if (c2.nextSibling == this.firstChild) {
                    throw new IllegalStateException(MessageFormat.format(Res._TreeCircularity, this, c2));
                }
                if (c2.nextSibling == newChild) {
                    throw new IllegalStateException(MessageFormat.format(Res._TreeNode, this, newChild));
                }
                if (c2.nextSibling == null || c2.nextSibling == aheadOf) {
                    newChildTail.nextSibling = c2.nextSibling;
                    c2.nextSibling = newChild;
                    return;
                }
                c2 = c2.nextSibling;
            }
        }
        newChildTail.nextSibling = this.firstChild;
        this.firstChild = newChild;
    }

    public void insertSibling(LinkedTreeNode newSibling) {
        LinkedTreeNode s = newSibling;
        while (true) {
            if (s.parent != null) {
                throw new IllegalArgumentException(MessageFormat.format(Res._TreeNode1, s, s.parent));
            }
            if (s.nextSibling == this) {
                throw new IllegalStateException(MessageFormat.format(Res._TreeNode2, this, newSibling));
            }
            s.setParent(this.parent);
            if (s.nextSibling == null) break;
            ++this.childCount;
            s = s.nextSibling;
        }
        s.nextSibling = this.nextSibling;
        this.nextSibling = newSibling;
    }

    public void removeChild(LinkedTreeNode unwantedChild) {
        if (this.firstChild == unwantedChild) {
            this.firstChild = unwantedChild.nextSibling;
        } else if (this.firstChild != null) {
            LinkedTreeNode c2 = this.firstChild;
            while (true) {
                if (c2.nextSibling == unwantedChild) {
                    c2.nextSibling = unwantedChild.nextSibling;
                    break;
                }
                if (c2.nextSibling == null) {
                    throw new IllegalArgumentException(MessageFormat.format(Res._TreeNode3, unwantedChild, this));
                }
                c2 = c2.nextSibling;
            }
        }
        unwantedChild.setParent(null);
        unwantedChild.nextSibling = null;
        --this.childCount;
    }

    public LinkedTreeNode removeNode(LinkedTreeNode root) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else if (this == root) {
            root = this.nextSibling;
        } else {
            LinkedTreeNode lastSibling = root;
            while (lastSibling.nextSibling != this) {
                lastSibling = lastSibling.nextSibling;
            }
            lastSibling.nextSibling = this.nextSibling;
        }
        this.nextSibling = null;
        return root;
    }

    protected void setParent(LinkedTreeNode parent) {
        this.parent = parent;
    }

    public void print() {
        this.print(0);
    }

    public void print(int level) {
        for (int i2 = 0; i2 < 2 * level; ++i2) {
            System.err.print(" ");
        }
        System.err.println(this + " L" + level);
        if (this.firstChild != null) {
            this.firstChild.print(level + 1);
        }
        if (this.nextSibling != null) {
            this.nextSibling.print(level);
        }
    }

    public void check() {
        LinkedTreeNode c2 = this.firstChild;
        while (c2 != null) {
            if (c2.parent != this) {
                throw new IllegalStateException(MessageFormat.format(Res._TreeNode4, c2, this));
            }
            if (c2.nextSibling == this.firstChild) {
                throw new IllegalStateException(MessageFormat.format(Res._TreeCircularity, this, c2));
            }
            c2 = c2.nextSibling;
        }
    }
}

