/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSIndexInput;
import org.apache.lucene.store.FSIndexOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private File lockDir;
    private static final char[] HEX_DIGITS;

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir;
        file = new File(file.getCanonicalPath());
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                try {
                    dir = (FSDirectory)IMPL.newInstance();
                }
                catch (Exception e2) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e2.toString(), e2);
                }
                dir.init(file, create);
                DIRECTORIES.put(file, dir);
            } else if (create) {
                dir.create();
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    protected FSDirectory() {
    }

    private void init(File path, boolean create) throws IOException {
        this.directory = path;
        this.lockDir = LOCK_DIR == null ? this.directory : new File(LOCK_DIR);
        if (!this.lockDir.exists()) {
            if (!this.lockDir.mkdirs()) {
                throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
            }
        } else if (!this.lockDir.isDirectory()) {
            throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
        }
        if (create) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(path + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(this.directory + " not a directory");
        }
        String[] files = this.directory.list(new IndexFileNameFilter());
        if (files == null) {
            throw new IOException("Cannot read directory " + this.directory.getAbsolutePath());
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(this.directory, files[i]);
            if (file.delete()) continue;
            throw new IOException("Cannot delete " + file);
        }
        String lockPrefix = this.getLockPrefix().toString();
        files = this.lockDir.list();
        if (files == null) {
            throw new IOException("Cannot read lock directory " + this.lockDir.getAbsolutePath());
        }
        for (int i = 0; i < files.length; ++i) {
            File lockFile;
            if (!files[i].startsWith(lockPrefix) || (lockFile = new File(this.lockDir, files[i])).delete()) continue;
            throw new IOException("Cannot delete " + lockFile);
        }
    }

    public String[] list() {
        return this.directory.list();
    }

    public boolean fileExists(String name) {
        File file = new File(this.directory, name);
        return file.exists();
    }

    public long fileModified(String name) {
        File file = new File(this.directory, name);
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, name);
        return file.lastModified();
    }

    public void touchFile(String name) {
        File file = new File(this.directory, name);
        file.setLastModified(System.currentTimeMillis());
    }

    public long fileLength(String name) {
        File file = new File(this.directory, name);
        return file.length();
    }

    public void deleteFile(String name) throws IOException {
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void renameFile(String from, String to) throws IOException {
        FileOutputStream out;
        block14: {
            File old = new File(this.directory, from);
            File nu = new File(this.directory, to);
            if (nu.exists() && !nu.delete()) {
                throw new IOException("Cannot delete " + nu);
            }
            if (old.renameTo(nu)) return;
            FileInputStream in = null;
            out = null;
            try {
                try {
                    int len;
                    in = new FileInputStream(old);
                    out = new FileOutputStream(nu);
                    if (this.buffer == null) {
                        this.buffer = new byte[1024];
                    }
                    while ((len = ((InputStream)in).read(this.buffer)) >= 0) {
                        ((OutputStream)out).write(this.buffer, 0, len);
                    }
                    old.delete();
                }
                catch (IOException ioe) {
                    IOException newExc = new IOException("Cannot rename " + old + " to " + nu);
                    newExc.initCause(ioe);
                    throw newExc;
                }
                Object var10_9 = null;
                if (in == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException("Cannot close input stream: " + e2.toString(), e2);
                    }
                }
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new RuntimeException("Cannot close output stream: " + e3.toString(), e3);
                }
            }
            try {}
            catch (IOException e2) {
                throw new RuntimeException("Cannot close input stream: " + e2.toString(), e2);
            }
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException e3) {
            throw new RuntimeException("Cannot close output stream: " + e3.toString(), e3);
        }
        ((OutputStream)out).close();
    }

    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.directory, name));
    }

    public Lock makeLock(String name) {
        StringBuffer buf = this.getLockPrefix();
        buf.append("-");
        buf.append(name);
        final File lockFile = new File(this.lockDir, buf.toString());
        return new Lock(){

            public boolean obtain() throws IOException {
                if (disableLocks) {
                    return true;
                }
                if (!FSDirectory.this.lockDir.exists() && !FSDirectory.this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create lock directory: " + FSDirectory.this.lockDir);
                }
                return lockFile.createNewFile();
            }

            public void release() {
                if (disableLocks) {
                    return;
                }
                lockFile.delete();
            }

            public boolean isLocked() {
                if (disableLocks) {
                    return false;
                }
                return lockFile.exists();
            }

            public String toString() {
                return "Lock@" + lockFile;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getLockPrefix() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2.toString(), e2);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.directory;
    }

    static {
        try {
            String name = System.getProperty("org.apache.lucene.FSDirectory.class", FSDirectory.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("cannot load FSDirectory class: " + e2.toString(), e2);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(FSDirectory.class.getName());
            }
            catch (ClassNotFoundException e3) {
                throw new RuntimeException("cannot load default FSDirectory class: " + e3.toString(), e3);
            }
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e4) {
            throw new RuntimeException(e4.toString(), e4);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

