/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.NonMatchingScorer;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class BooleanScorer2
extends Scorer {
    private ArrayList requiredScorers = new ArrayList();
    private ArrayList optionalScorers = new ArrayList();
    private ArrayList prohibitedScorers = new ArrayList();
    private final Coordinator coordinator;
    private Scorer countingSumScorer = null;
    private final int minNrShouldMatch;
    private static Similarity defaultSimilarity = new DefaultSimilarity();

    public BooleanScorer2(Similarity similarity, int minNrShouldMatch) {
        super(similarity);
        if (minNrShouldMatch < 0) {
            throw new IllegalArgumentException("Minimum number of optional scorers should not be negative");
        }
        this.coordinator = new Coordinator();
        this.minNrShouldMatch = minNrShouldMatch;
    }

    public BooleanScorer2(Similarity similarity) {
        this(similarity, 0);
    }

    public void add(Scorer scorer, boolean required, boolean prohibited) {
        if (!prohibited) {
            ++this.coordinator.maxCoord;
        }
        if (required) {
            if (prohibited) {
                throw new IllegalArgumentException("scorer cannot be required and prohibited");
            }
            this.requiredScorers.add(scorer);
        } else if (prohibited) {
            this.prohibitedScorers.add(scorer);
        } else {
            this.optionalScorers.add(scorer);
        }
    }

    private void initCountingSumScorer() {
        this.coordinator.init();
        this.countingSumScorer = this.makeCountingSumScorer();
    }

    private Scorer countingDisjunctionSumScorer(List scorers, int minMrShouldMatch) {
        return new DisjunctionSumScorer(scorers, minMrShouldMatch){
            private int lastScoredDoc;
            {
                this.lastScoredDoc = -1;
            }

            public float score() throws IOException {
                if (this.doc() > this.lastScoredDoc) {
                    this.lastScoredDoc = this.doc();
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += this.nrMatchers;
                }
                return super.score();
            }
        };
    }

    private Scorer countingConjunctionSumScorer(List requiredScorers) {
        final int requiredNrMatchers = requiredScorers.size();
        ConjunctionScorer cs = new ConjunctionScorer(defaultSimilarity){
            private int lastScoredDoc;
            {
                super(x0);
                this.lastScoredDoc = -1;
            }

            public float score() throws IOException {
                if (this.doc() > this.lastScoredDoc) {
                    this.lastScoredDoc = this.doc();
                    ((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers += requiredNrMatchers;
                }
                return super.score();
            }
        };
        Iterator rsi = requiredScorers.iterator();
        while (rsi.hasNext()) {
            cs.add((Scorer)rsi.next());
        }
        return cs;
    }

    private Scorer dualConjunctionSumScorer(Scorer req1, Scorer req2) {
        int requiredNrMatchers = this.requiredScorers.size();
        ConjunctionScorer cs = new ConjunctionScorer(defaultSimilarity);
        cs.add(req1);
        cs.add(req2);
        return cs;
    }

    private Scorer makeCountingSumScorer() {
        return this.requiredScorers.size() == 0 ? this.makeCountingSumScorerNoReq() : this.makeCountingSumScorerSomeReq();
    }

    private Scorer makeCountingSumScorerNoReq() {
        int nrOptRequired;
        if (this.optionalScorers.size() == 0) {
            return new NonMatchingScorer();
        }
        int n = nrOptRequired = this.minNrShouldMatch < 1 ? 1 : this.minNrShouldMatch;
        if (this.optionalScorers.size() < nrOptRequired) {
            return new NonMatchingScorer();
        }
        Scorer requiredCountingSumScorer = this.optionalScorers.size() > nrOptRequired ? this.countingDisjunctionSumScorer(this.optionalScorers, nrOptRequired) : (this.optionalScorers.size() == 1 ? new SingleMatchScorer((Scorer)this.optionalScorers.get(0)) : this.countingConjunctionSumScorer(this.optionalScorers));
        return this.addProhibitedScorers(requiredCountingSumScorer);
    }

    private Scorer makeCountingSumScorerSomeReq() {
        Scorer requiredCountingSumScorer;
        if (this.optionalScorers.size() < this.minNrShouldMatch) {
            return new NonMatchingScorer();
        }
        if (this.optionalScorers.size() == this.minNrShouldMatch) {
            ArrayList allReq = new ArrayList(this.requiredScorers);
            allReq.addAll(this.optionalScorers);
            return this.addProhibitedScorers(this.countingConjunctionSumScorer(allReq));
        }
        Scorer scorer = requiredCountingSumScorer = this.requiredScorers.size() == 1 ? new SingleMatchScorer((Scorer)this.requiredScorers.get(0)) : this.countingConjunctionSumScorer(this.requiredScorers);
        if (this.minNrShouldMatch > 0) {
            return this.addProhibitedScorers(this.dualConjunctionSumScorer(requiredCountingSumScorer, this.countingDisjunctionSumScorer(this.optionalScorers, this.minNrShouldMatch)));
        }
        return new ReqOptSumScorer(this.addProhibitedScorers(requiredCountingSumScorer), this.optionalScorers.size() == 1 ? new SingleMatchScorer((Scorer)this.optionalScorers.get(0)) : this.countingDisjunctionSumScorer(this.optionalScorers, 1));
    }

    private Scorer addProhibitedScorers(Scorer requiredCountingSumScorer) {
        return this.prohibitedScorers.size() == 0 ? requiredCountingSumScorer : new ReqExclScorer(requiredCountingSumScorer, this.prohibitedScorers.size() == 1 ? (Scorer)this.prohibitedScorers.get(0) : new DisjunctionSumScorer(this.prohibitedScorers));
    }

    public void score(HitCollector hc) throws IOException {
        if (this.countingSumScorer == null) {
            this.initCountingSumScorer();
        }
        while (this.countingSumScorer.next()) {
            hc.collect(this.countingSumScorer.doc(), this.score());
        }
    }

    protected boolean score(HitCollector hc, int max2) throws IOException {
        int docNr = this.countingSumScorer.doc();
        while (docNr < max2) {
            hc.collect(docNr, this.score());
            if (!this.countingSumScorer.next()) {
                return false;
            }
            docNr = this.countingSumScorer.doc();
        }
        return true;
    }

    public int doc() {
        return this.countingSumScorer.doc();
    }

    public boolean next() throws IOException {
        if (this.countingSumScorer == null) {
            this.initCountingSumScorer();
        }
        return this.countingSumScorer.next();
    }

    public float score() throws IOException {
        this.coordinator.initDoc();
        float sum = this.countingSumScorer.score();
        return sum * this.coordinator.coordFactor();
    }

    public boolean skipTo(int target) throws IOException {
        if (this.countingSumScorer == null) {
            this.initCountingSumScorer();
        }
        return this.countingSumScorer.skipTo(target);
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }

    private class SingleMatchScorer
    extends Scorer {
        private Scorer scorer;
        private int lastScoredDoc;

        SingleMatchScorer(Scorer scorer) {
            super(scorer.getSimilarity());
            this.lastScoredDoc = -1;
            this.scorer = scorer;
        }

        public float score() throws IOException {
            if (this.doc() > this.lastScoredDoc) {
                this.lastScoredDoc = this.doc();
                ++((BooleanScorer2)BooleanScorer2.this).coordinator.nrMatchers;
            }
            return this.scorer.score();
        }

        public int doc() {
            return this.scorer.doc();
        }

        public boolean next() throws IOException {
            return this.scorer.next();
        }

        public boolean skipTo(int docNr) throws IOException {
            return this.scorer.skipTo(docNr);
        }

        public Explanation explain(int docNr) throws IOException {
            return this.scorer.explain(docNr);
        }
    }

    private class Coordinator {
        int maxCoord = 0;
        private float[] coordFactors = null;
        int nrMatchers;

        private Coordinator() {
        }

        void init() {
            this.coordFactors = new float[this.maxCoord + 1];
            Similarity sim = BooleanScorer2.this.getSimilarity();
            for (int i = 0; i <= this.maxCoord; ++i) {
                this.coordFactors[i] = sim.coord(i, this.maxCoord);
            }
        }

        void initDoc() {
            this.nrMatchers = 0;
        }

        float coordFactor() {
            return this.coordFactors[this.nrMatchers];
        }
    }
}

