/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTools {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private DateTools() {
    }

    public static String dateToString(Date date2, Resolution resolution) {
        return DateTools.timeToString(date2.getTime(), resolution);
    }

    public static String timeToString(long time, Resolution resolution) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(new Date(DateTools.round(time, resolution)));
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(GMT);
        String pattern = null;
        if (resolution == Resolution.YEAR) {
            pattern = "yyyy";
        } else if (resolution == Resolution.MONTH) {
            pattern = "yyyyMM";
        } else if (resolution == Resolution.DAY) {
            pattern = "yyyyMMdd";
        } else if (resolution == Resolution.HOUR) {
            pattern = "yyyyMMddHH";
        } else if (resolution == Resolution.MINUTE) {
            pattern = "yyyyMMddHHmm";
        } else if (resolution == Resolution.SECOND) {
            pattern = "yyyyMMddHHmmss";
        } else if (resolution == Resolution.MILLISECOND) {
            pattern = "yyyyMMddHHmmssSSS";
        } else {
            throw new IllegalArgumentException("unknown resolution " + resolution);
        }
        sdf.applyPattern(pattern);
        return sdf.format(cal.getTime());
    }

    public static long stringToTime(String dateString) throws ParseException {
        return DateTools.stringToDate(dateString).getTime();
    }

    public static Date stringToDate(String dateString) throws ParseException {
        String pattern = null;
        if (dateString.length() == 4) {
            pattern = "yyyy";
        } else if (dateString.length() == 6) {
            pattern = "yyyyMM";
        } else if (dateString.length() == 8) {
            pattern = "yyyyMMdd";
        } else if (dateString.length() == 10) {
            pattern = "yyyyMMddHH";
        } else if (dateString.length() == 12) {
            pattern = "yyyyMMddHHmm";
        } else if (dateString.length() == 14) {
            pattern = "yyyyMMddHHmmss";
        } else if (dateString.length() == 17) {
            pattern = "yyyyMMddHHmmssSSS";
        } else {
            throw new ParseException("Input is not valid date string: " + dateString, 0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(GMT);
        Date date2 = sdf.parse(dateString);
        return date2;
    }

    public static Date round(Date date2, Resolution resolution) {
        return new Date(DateTools.round(date2.getTime(), resolution));
    }

    public static long round(long time, Resolution resolution) {
        Calendar cal = Calendar.getInstance(GMT);
        cal.setTime(new Date(time));
        if (resolution == Resolution.YEAR) {
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.MONTH) {
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.DAY) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.HOUR) {
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.MINUTE) {
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (resolution == Resolution.SECOND) {
            cal.set(14, 0);
        } else if (resolution != Resolution.MILLISECOND) {
            throw new IllegalArgumentException("unknown resolution " + resolution);
        }
        return cal.getTime().getTime();
    }

    public static class Resolution {
        public static final Resolution YEAR = new Resolution("year");
        public static final Resolution MONTH = new Resolution("month");
        public static final Resolution DAY = new Resolution("day");
        public static final Resolution HOUR = new Resolution("hour");
        public static final Resolution MINUTE = new Resolution("minute");
        public static final Resolution SECOND = new Resolution("second");
        public static final Resolution MILLISECOND = new Resolution("millisecond");
        private String resolution;

        private Resolution() {
        }

        private Resolution(String resolution) {
            this.resolution = resolution;
        }

        public String toString() {
            return this.resolution;
        }
    }
}

