/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.policy;

import net.ponder2.ManagedObject;
import net.ponder2.P2ManagedObject;
import net.ponder2.Policy;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2Object;

public class AuthorisationPolicy
extends Policy
implements ManagedObject {
    static final boolean DEBUG = false;
    private P2Block requestCondition = null;
    private P2Block replyCondition = null;
    private P2ManagedObject subject = null;
    private P2ManagedObject target = null;
    private String action = null;
    private char focus;
    private boolean isAuthRequestNeg = false;
    private boolean isAuthReplyNeg = false;
    private boolean isFinal = false;

    @Ponder2op(value="subject:action:target:focus:")
    public AuthorisationPolicy(P2Object subject, String action, P2Object target, String focus) {
        this.subject = subject.getManagedObject();
        this.subject.applyPolicy(this);
        this.target = target.getManagedObject();
        this.action = action;
        this.focus = focus.charAt(0);
    }

    @Ponder2op(value="final")
    protected void operation_set_final() {
        this.isFinal = true;
    }

    @Ponder2op(value="reqneg")
    protected void operation_set_inneg() {
        this.isAuthRequestNeg = true;
    }

    @Ponder2op(value="repneg")
    protected void operation_set_outneg() {
        this.isAuthReplyNeg = true;
    }

    @Ponder2op(value="reqcondition:")
    protected P2Object operation_in_condition(P2Block aBlock) {
        this.requestCondition = aBlock;
        return aBlock;
    }

    @Ponder2op(value="repcondition:")
    protected P2Object operation_out_condition(P2Block aBlock) {
        this.replyCondition = aBlock;
        return aBlock;
    }

    P2ManagedObject getSubject() {
        return this.subject;
    }

    P2ManagedObject getTarget() {
        return this.target;
    }

    boolean isAuthRequestNeg() {
        return this.isAuthRequestNeg;
    }

    boolean isAuthReplyNeg() {
        return this.isAuthReplyNeg;
    }

    String getAction() {
        return this.action;
    }

    boolean isFinal() {
        return this.isFinal;
    }

    void setTarget(P2Object target) {
        this.target = target.getManagedObject();
    }

    char getFocus() {
        return this.focus;
    }

    public String toString() {
        String spolicy = "";
        spolicy = String.valueOf(spolicy) + "{" + Integer.toHexString(this.hashCode()) + ",";
        spolicy = String.valueOf(spolicy) + this.subject.getOID() + ",";
        spolicy = String.valueOf(spolicy) + this.target.getOID() + ",";
        spolicy = this.isFinal ? String.valueOf(spolicy) + "Final," : String.valueOf(spolicy) + "Normal,";
        spolicy = String.valueOf(spolicy) + this.focus + ",";
        spolicy = this.isActive() ? String.valueOf(spolicy) + "active," : String.valueOf(spolicy) + "NOTactive,";
        spolicy = this.isAuthRequestNeg ? String.valueOf(spolicy) + "Request-," : String.valueOf(spolicy) + "Request+,";
        spolicy = String.valueOf(spolicy) + this.action + ",";
        spolicy = this.isAuthReplyNeg ? String.valueOf(spolicy) + "Result-}" : String.valueOf(spolicy) + "Result+}";
        return spolicy;
    }

    public boolean checkRequestCondition(P2Object subject, P2Object ... argAttribute) {
        try {
            return this.checkCondition(subject, "in", argAttribute);
        }
        catch (Ponder2Exception e2) {
            System.err.println("AuthorisationPolicy.checkRequestCondition(): a Ponder2Exception occurred. Printing the Stack Trace...");
            e2.printStackTrace();
            return false;
        }
    }

    public boolean checkReturnCondition(P2Object subject, P2Object ... argAttribute) {
        try {
            return this.checkCondition(subject, "out", argAttribute);
        }
        catch (Ponder2Exception e2) {
            System.err.println("AuthorisationPolicy.checkReturnCondition(): a Ponder2Exception occurred. Printing the Stack Trace...");
            e2.printStackTrace();
            return false;
        }
    }

    protected boolean checkCondition(P2Object subject, String conditionType, P2Object ... argAttribute) throws Ponder2Exception {
        if ("in".equals(conditionType)) {
            if (this.requestCondition != null) {
                return this.requestCondition.operation_array(subject, new P2Array(argAttribute)).asBoolean();
            }
        } else if ("out".equals(conditionType) && this.replyCondition != null) {
            return this.replyCondition.operation_array(subject, new P2Array(argAttribute)).asBoolean();
        }
        return true;
    }
}

