/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.Element;
import com.twicom.qdparser.TaggedElement;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Boolean;
import net.ponder2.objects.P2Number;
import net.ponder2.objects.P2Object;
import net.ponder2.objects.P2StringP2Adaptor;
import net.ponder2.objects.P2XML;

public class P2String
extends P2Object
implements ManagedObject {
    private String string;
    private boolean booleanSet = false;
    private boolean booleanValue = false;
    private boolean intSet = false;
    private int intValue = 0;

    public P2String() {
        this.string = null;
    }

    public P2String(String value) {
        this.string = value;
    }

    public String asString() throws Ponder2ArgumentException {
        return this.string;
    }

    public boolean asBoolean() throws Ponder2ArgumentException {
        if (this.booleanSet) {
            return this.booleanValue;
        }
        this.booleanValue = P2Boolean.from(this.string).asBoolean();
        this.booleanSet = true;
        return this.booleanValue;
    }

    public int asNumber() throws Ponder2ArgumentException {
        if (this.intSet) {
            return this.intValue;
        }
        this.intValue = new P2Number(this.string).asNumber();
        this.intSet = true;
        return this.intValue;
    }

    @Ponder2op(value="+")
    public String add(String aString) {
        return String.valueOf(this.string) + aString;
    }

    @Ponder2op(value="==")
    public boolean equals(String aString) {
        return this.string.equals(aString);
    }

    @Ponder2op(value="!=")
    public boolean nequals(String aString) {
        return !this.string.equals(aString);
    }

    @Ponder2op(value="*")
    public String times(int aNumber) {
        StringBuffer buf = new StringBuffer(this.string.length() * aNumber);
        int i = 0;
        while (i < aNumber) {
            buf.append(this.string);
            ++i;
        }
        return buf.toString();
    }

    @Ponder2op(value="asXML")
    public P2XML asXML() throws Ponder2ArgumentException {
        return new P2XML(this.string);
    }

    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2StringP2Adaptor.doOp(this, this, source, operation, args);
    }

    public String toString() {
        return String.valueOf('\"') + this.string + '\"';
    }

    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        xml.add(Element.quote(this.string));
        return xml;
    }

    public P2Object readXml(TaggedElement xml) {
        this.string = Element.unquote(xml.getChild(0).toString());
        return this;
    }
}

