/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Block;
import net.ponder2.objects.P2BooleanP2Adaptor;
import net.ponder2.objects.P2Object;

public class P2Boolean
extends P2Object
implements ManagedObject {
    public static final P2Boolean True = new P2Boolean(true);
    public static final P2Boolean False = new P2Boolean(false);
    private boolean value;

    protected P2Boolean() {
    }

    public static P2Boolean from(String string) throws Ponder2ArgumentException {
        if (string.equals("true")) {
            return True;
        }
        if (string.equals("false")) {
            return False;
        }
        throw new Ponder2ArgumentException("Bad boolean string '" + string + "'");
    }

    private P2Boolean(boolean value) {
        this.value = value;
    }

    public boolean asBoolean() throws Ponder2ArgumentException {
        return this.value;
    }

    @Ponder2op(value="&")
    protected boolean and(boolean aBoolean) {
        return this.value & aBoolean;
    }

    @Ponder2op(value="|")
    protected boolean or(boolean aBoolean) {
        return this.value | aBoolean;
    }

    @Ponder2op(value="and:")
    protected boolean and(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return this.value ? aBlock.execute(source, new P2Object[0]).asBoolean() : false;
    }

    @Ponder2op(value="or:")
    protected boolean or(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return this.value ? true : aBlock.execute(source, new P2Object[0]).asBoolean();
    }

    @Ponder2op(value="ifTrue:")
    protected P2Object ifTrue(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return this.value ? aBlock.execute(source, new P2Object[0]) : P2Object.create();
    }

    @Ponder2op(value="ifFalse:")
    protected P2Object ifFalse(P2Object source, P2Block aBlock) throws Ponder2Exception {
        return this.value ? P2Object.create() : aBlock.execute(source, new P2Object[0]);
    }

    @Ponder2op(value="ifTrue:ifFalse:")
    protected P2Object ifTrueifFalse(P2Object source, P2Block aBlockTrue, P2Block aBlockFalse) throws Ponder2Exception {
        return this.value ? aBlockTrue.execute(source, new P2Object[0]) : aBlockFalse.execute(source, new P2Object[0]);
    }

    @Ponder2op(value="ifFalse:ifTrue:")
    protected P2Object ifFalseifTrue(P2Object source, P2Block aBlockFalse, P2Block aBlockTrue) throws Ponder2Exception {
        return this.value ? aBlockTrue.execute(source, new P2Object[0]) : aBlockFalse.execute(source, new P2Object[0]);
    }

    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2BooleanP2Adaptor.doOp(this, this, source, operation, args);
    }

    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        xml.setAttribute("value", this.toString());
        return xml;
    }

    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException {
        boolean bool = Boolean.parseBoolean(xml.getAttribute("value"));
        return bool ? True : False;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }
}

