/*
 * Decompiled with CFR 0.152.
 */
package net.ponder2.objects;

import com.twicom.qdparser.TaggedElement;
import java.util.HashMap;
import java.util.Map;
import net.ponder2.ManagedObject;
import net.ponder2.apt.Ponder2op;
import net.ponder2.exception.Ponder2ArgumentException;
import net.ponder2.exception.Ponder2Exception;
import net.ponder2.exception.Ponder2OperationException;
import net.ponder2.objects.P2Array;
import net.ponder2.objects.P2BlockP2Adaptor;
import net.ponder2.objects.P2Boolean;
import net.ponder2.objects.P2Hash;
import net.ponder2.objects.P2Object;
import net.ponder2.parser.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Block
extends P2Object
implements ManagedObject {
    private Map<String, P2Object> variables;
    private TaggedElement block;
    private boolean firstTime;
    private int argCount;
    private String[] argName;
    private TaggedElement code;

    protected P2Block() {
    }

    public P2Block(Map<String, P2Object> variables, TaggedElement block) {
        this.variables = new HashMap<String, P2Object>(variables);
        this.block = block;
        this.firstTime = true;
    }

    @Override
    public P2Block asBlock() throws Ponder2ArgumentException {
        return this;
    }

    @Ponder2op(value="hasArgs:")
    protected P2Object operation_hasArgs(P2Hash aHash) throws Ponder2ArgumentException {
        this.setup();
        int i = 0;
        while (i < this.argName.length) {
            if (!aHash.operation_has(this.argName[i])) {
                return P2Boolean.False;
            }
            ++i;
        }
        return P2Boolean.True;
    }

    @Ponder2op(value="valueHash:")
    public P2Object operation_valueHash(P2Object source, P2Hash hash) throws Ponder2Exception {
        this.setup();
        P2Object[] args = new P2Object[this.argCount];
        int i = 0;
        while (i < this.argCount) {
            args[i] = hash.operation_at(this.argName[i]);
            if (args[i] == null) {
                throw new Ponder2ArgumentException("Block: Hash is missing argument: " + this.argName[i]);
            }
            ++i;
        }
        return this.execute(source, args);
    }

    @Ponder2op(value="value")
    public P2Object operation_value0(P2Object source) throws Ponder2Exception {
        return this.execute(source, new P2Object[0]);
    }

    @Ponder2op(value="value:")
    public P2Object operation_value1(P2Object source, P2Object arg0) throws Ponder2Exception {
        return this.execute(source, arg0);
    }

    @Ponder2op(value="value:value:")
    public P2Object operation_value2(P2Object source, P2Object arg0, P2Object arg1) throws Ponder2Exception {
        return this.execute(source, arg0, arg1);
    }

    @Ponder2op(value="value:value:value:")
    public P2Object operation_value3(P2Object source, P2Object arg0, P2Object arg1, P2Object arg2) throws Ponder2Exception {
        return this.execute(source, arg0, arg1, arg2);
    }

    @Ponder2op(value="values:")
    public P2Object operation_array(P2Object source, P2Array anArray) throws Ponder2Exception {
        return this.execute(source, anArray.asArray());
    }

    protected P2Object execute(P2Object source, P2Object ... args) throws Ponder2Exception {
        this.setup();
        P2Hash variables = new P2Hash(this.variables);
        variables.put("Variables", variables);
        if (this.argCount > 0) {
            if (args.length < this.argCount) {
                throw new Ponder2ArgumentException("Not enough arguments for block. " + args.length + " given, " + this.argCount + " expected.");
            }
            int i = 0;
            while (i < this.argCount) {
                variables.put(this.argName[i], args[i]);
                ++i;
            }
        }
        return new XMLParser(variables).execute(source, this.code);
    }

    private void setup() {
        if (!this.firstTime) {
            return;
        }
        this.firstTime = false;
        this.code = (TaggedElement)this.block.getChild(1);
        TaggedElement child = (TaggedElement)this.block.getChild(0);
        this.argCount = child.elements();
        if (this.argCount == 0) {
            return;
        }
        this.argName = new String[this.argCount];
        int i = 0;
        while (i < this.argCount) {
            TaggedElement arginfo = (TaggedElement)child.getChild(i);
            this.argName[i] = arginfo.getAttribute("name");
            ++i;
        }
    }

    @Override
    public P2Object operation(P2Object source, String operation, P2Object ... args) throws Ponder2Exception {
        return P2BlockP2Adaptor.doOp(this, this, source, operation, args);
    }

    @Override
    public TaggedElement writeXml() throws Ponder2OperationException {
        TaggedElement xml = super.writeXml();
        xml.add(P2Object.create(this.variables).writeXml());
        xml.add(this.block);
        return xml;
    }

    @Override
    public P2Object readXml(TaggedElement xml) throws Ponder2OperationException, Ponder2ArgumentException {
        this.variables = new HashMap<String, P2Object>();
        TaggedElement child = (TaggedElement)xml.getChild(0);
        P2Object obj = P2Object.fromXml(child);
        this.variables = obj.asHash().asMap();
        this.block = (TaggedElement)xml.getChild(1);
        this.firstTime = true;
        return this;
    }

    public String toString() {
        return String.valueOf(this.variables.toString()) + this.block.toString();
    }
}

